package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class GRPCRouteRuleFluent<A extends GRPCRouteRuleFluent<A>> extends BaseFluent<A>{
  public GRPCRouteRuleFluent() {
  }
  public GRPCRouteRuleFluent(GRPCRouteRule instance) {
    instance = (instance != null ? instance : new GRPCRouteRule());

    if (instance != null) {
      this.withBackendRefs(instance.getBackendRefs());
      this.withFilters(instance.getFilters());
      this.withMatches(instance.getMatches());
      this.withBackendRefs(instance.getBackendRefs());
      this.withFilters(instance.getFilters());
      this.withMatches(instance.getMatches());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<GRPCBackendRefBuilder> backendRefs = new ArrayList<GRPCBackendRefBuilder>();
  private ArrayList<GRPCRouteFilterBuilder> filters = new ArrayList<GRPCRouteFilterBuilder>();
  private ArrayList<GRPCRouteMatchBuilder> matches = new ArrayList<GRPCRouteMatchBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToBackendRefs(int index,GRPCBackendRef item) {
    if (this.backendRefs == null) {this.backendRefs = new ArrayList<GRPCBackendRefBuilder>();}
    GRPCBackendRefBuilder builder = new GRPCBackendRefBuilder(item);
    if (index < 0 || index >= backendRefs.size()) { _visitables.get("backendRefs").add(builder); backendRefs.add(builder); } else { _visitables.get("backendRefs").add(index, builder); backendRefs.add(index, builder);}
    return (A)this;
  }
  public A setToBackendRefs(int index,GRPCBackendRef item) {
    if (this.backendRefs == null) {this.backendRefs = new ArrayList<GRPCBackendRefBuilder>();}
    GRPCBackendRefBuilder builder = new GRPCBackendRefBuilder(item);
    if (index < 0 || index >= backendRefs.size()) { _visitables.get("backendRefs").add(builder); backendRefs.add(builder); } else { _visitables.get("backendRefs").set(index, builder); backendRefs.set(index, builder);}
    return (A)this;
  }
  public A addToBackendRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCBackendRef... items) {
    if (this.backendRefs == null) {this.backendRefs = new ArrayList<GRPCBackendRefBuilder>();}
    for (GRPCBackendRef item : items) {GRPCBackendRefBuilder builder = new GRPCBackendRefBuilder(item);_visitables.get("backendRefs").add(builder);this.backendRefs.add(builder);} return (A)this;
  }
  public A addAllToBackendRefs(Collection<GRPCBackendRef> items) {
    if (this.backendRefs == null) {this.backendRefs = new ArrayList<GRPCBackendRefBuilder>();}
    for (GRPCBackendRef item : items) {GRPCBackendRefBuilder builder = new GRPCBackendRefBuilder(item);_visitables.get("backendRefs").add(builder);this.backendRefs.add(builder);} return (A)this;
  }
  public A removeFromBackendRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCBackendRef... items) {
    if (this.backendRefs == null) return (A)this;
    for (GRPCBackendRef item : items) {GRPCBackendRefBuilder builder = new GRPCBackendRefBuilder(item);_visitables.get("backendRefs").remove(builder); this.backendRefs.remove(builder);} return (A)this;
  }
  public A removeAllFromBackendRefs(Collection<GRPCBackendRef> items) {
    if (this.backendRefs == null) return (A)this;
    for (GRPCBackendRef item : items) {GRPCBackendRefBuilder builder = new GRPCBackendRefBuilder(item);_visitables.get("backendRefs").remove(builder); this.backendRefs.remove(builder);} return (A)this;
  }
  public A removeMatchingFromBackendRefs(Predicate<GRPCBackendRefBuilder> predicate) {
    if (backendRefs == null) return (A) this;
    final Iterator<GRPCBackendRefBuilder> each = backendRefs.iterator();
    final List visitables = _visitables.get("backendRefs");
    while (each.hasNext()) {
      GRPCBackendRefBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<GRPCBackendRef> buildBackendRefs() {
    return backendRefs != null ? build(backendRefs) : null;
  }
  public GRPCBackendRef buildBackendRef(int index) {
    return this.backendRefs.get(index).build();
  }
  public GRPCBackendRef buildFirstBackendRef() {
    return this.backendRefs.get(0).build();
  }
  public GRPCBackendRef buildLastBackendRef() {
    return this.backendRefs.get(backendRefs.size() - 1).build();
  }
  public GRPCBackendRef buildMatchingBackendRef(Predicate<GRPCBackendRefBuilder> predicate) {
    for (GRPCBackendRefBuilder item: backendRefs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingBackendRef(Predicate<GRPCBackendRefBuilder> predicate) {
    for (GRPCBackendRefBuilder item: backendRefs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withBackendRefs(List<GRPCBackendRef> backendRefs) {
    if (this.backendRefs != null) { _visitables.get("backendRefs").clear();}
    if (backendRefs != null) {this.backendRefs = new ArrayList(); for (GRPCBackendRef item : backendRefs){this.addToBackendRefs(item);}} else { this.backendRefs = null;} return (A) this;
  }
  public A withBackendRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCBackendRef... backendRefs) {
    if (this.backendRefs != null) {this.backendRefs.clear(); _visitables.remove("backendRefs"); }
    if (backendRefs != null) {for (GRPCBackendRef item :backendRefs){ this.addToBackendRefs(item);}} return (A) this;
  }
  public boolean hasBackendRefs() {
    return backendRefs != null && !backendRefs.isEmpty();
  }
  public BackendRefsNested<A> addNewBackendRef() {
    return new BackendRefsNested(-1, null);
  }
  public BackendRefsNested<A> addNewBackendRefLike(GRPCBackendRef item) {
    return new BackendRefsNested(-1, item);
  }
  public BackendRefsNested<A> setNewBackendRefLike(int index,GRPCBackendRef item) {
    return new BackendRefsNested(index, item);
  }
  public BackendRefsNested<A> editBackendRef(int index) {
    if (backendRefs.size() <= index) throw new RuntimeException("Can't edit backendRefs. Index exceeds size.");
    return setNewBackendRefLike(index, buildBackendRef(index));
  }
  public BackendRefsNested<A> editFirstBackendRef() {
    if (backendRefs.size() == 0) throw new RuntimeException("Can't edit first backendRefs. The list is empty.");
    return setNewBackendRefLike(0, buildBackendRef(0));
  }
  public BackendRefsNested<A> editLastBackendRef() {
    int index = backendRefs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last backendRefs. The list is empty.");
    return setNewBackendRefLike(index, buildBackendRef(index));
  }
  public BackendRefsNested<A> editMatchingBackendRef(Predicate<GRPCBackendRefBuilder> predicate) {
    int index = -1;
    for (int i=0;i<backendRefs.size();i++) { 
    if (predicate.test(backendRefs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching backendRefs. No match found.");
    return setNewBackendRefLike(index, buildBackendRef(index));
  }
  public A addToFilters(int index,GRPCRouteFilter item) {
    if (this.filters == null) {this.filters = new ArrayList<GRPCRouteFilterBuilder>();}
    GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);
    if (index < 0 || index >= filters.size()) { _visitables.get("filters").add(builder); filters.add(builder); } else { _visitables.get("filters").add(index, builder); filters.add(index, builder);}
    return (A)this;
  }
  public A setToFilters(int index,GRPCRouteFilter item) {
    if (this.filters == null) {this.filters = new ArrayList<GRPCRouteFilterBuilder>();}
    GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);
    if (index < 0 || index >= filters.size()) { _visitables.get("filters").add(builder); filters.add(builder); } else { _visitables.get("filters").set(index, builder); filters.set(index, builder);}
    return (A)this;
  }
  public A addToFilters(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteFilter... items) {
    if (this.filters == null) {this.filters = new ArrayList<GRPCRouteFilterBuilder>();}
    for (GRPCRouteFilter item : items) {GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);_visitables.get("filters").add(builder);this.filters.add(builder);} return (A)this;
  }
  public A addAllToFilters(Collection<GRPCRouteFilter> items) {
    if (this.filters == null) {this.filters = new ArrayList<GRPCRouteFilterBuilder>();}
    for (GRPCRouteFilter item : items) {GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);_visitables.get("filters").add(builder);this.filters.add(builder);} return (A)this;
  }
  public A removeFromFilters(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteFilter... items) {
    if (this.filters == null) return (A)this;
    for (GRPCRouteFilter item : items) {GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);_visitables.get("filters").remove(builder); this.filters.remove(builder);} return (A)this;
  }
  public A removeAllFromFilters(Collection<GRPCRouteFilter> items) {
    if (this.filters == null) return (A)this;
    for (GRPCRouteFilter item : items) {GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);_visitables.get("filters").remove(builder); this.filters.remove(builder);} return (A)this;
  }
  public A removeMatchingFromFilters(Predicate<GRPCRouteFilterBuilder> predicate) {
    if (filters == null) return (A) this;
    final Iterator<GRPCRouteFilterBuilder> each = filters.iterator();
    final List visitables = _visitables.get("filters");
    while (each.hasNext()) {
      GRPCRouteFilterBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<GRPCRouteFilter> buildFilters() {
    return filters != null ? build(filters) : null;
  }
  public GRPCRouteFilter buildFilter(int index) {
    return this.filters.get(index).build();
  }
  public GRPCRouteFilter buildFirstFilter() {
    return this.filters.get(0).build();
  }
  public GRPCRouteFilter buildLastFilter() {
    return this.filters.get(filters.size() - 1).build();
  }
  public GRPCRouteFilter buildMatchingFilter(Predicate<GRPCRouteFilterBuilder> predicate) {
    for (GRPCRouteFilterBuilder item: filters) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingFilter(Predicate<GRPCRouteFilterBuilder> predicate) {
    for (GRPCRouteFilterBuilder item: filters) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withFilters(List<GRPCRouteFilter> filters) {
    if (this.filters != null) { _visitables.get("filters").clear();}
    if (filters != null) {this.filters = new ArrayList(); for (GRPCRouteFilter item : filters){this.addToFilters(item);}} else { this.filters = null;} return (A) this;
  }
  public A withFilters(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteFilter... filters) {
    if (this.filters != null) {this.filters.clear(); _visitables.remove("filters"); }
    if (filters != null) {for (GRPCRouteFilter item :filters){ this.addToFilters(item);}} return (A) this;
  }
  public boolean hasFilters() {
    return filters != null && !filters.isEmpty();
  }
  public FiltersNested<A> addNewFilter() {
    return new FiltersNested(-1, null);
  }
  public FiltersNested<A> addNewFilterLike(GRPCRouteFilter item) {
    return new FiltersNested(-1, item);
  }
  public FiltersNested<A> setNewFilterLike(int index,GRPCRouteFilter item) {
    return new FiltersNested(index, item);
  }
  public FiltersNested<A> editFilter(int index) {
    if (filters.size() <= index) throw new RuntimeException("Can't edit filters. Index exceeds size.");
    return setNewFilterLike(index, buildFilter(index));
  }
  public FiltersNested<A> editFirstFilter() {
    if (filters.size() == 0) throw new RuntimeException("Can't edit first filters. The list is empty.");
    return setNewFilterLike(0, buildFilter(0));
  }
  public FiltersNested<A> editLastFilter() {
    int index = filters.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last filters. The list is empty.");
    return setNewFilterLike(index, buildFilter(index));
  }
  public FiltersNested<A> editMatchingFilter(Predicate<GRPCRouteFilterBuilder> predicate) {
    int index = -1;
    for (int i=0;i<filters.size();i++) { 
    if (predicate.test(filters.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching filters. No match found.");
    return setNewFilterLike(index, buildFilter(index));
  }
  public A addToMatches(int index,GRPCRouteMatch item) {
    if (this.matches == null) {this.matches = new ArrayList<GRPCRouteMatchBuilder>();}
    GRPCRouteMatchBuilder builder = new GRPCRouteMatchBuilder(item);
    if (index < 0 || index >= matches.size()) { _visitables.get("matches").add(builder); matches.add(builder); } else { _visitables.get("matches").add(index, builder); matches.add(index, builder);}
    return (A)this;
  }
  public A setToMatches(int index,GRPCRouteMatch item) {
    if (this.matches == null) {this.matches = new ArrayList<GRPCRouteMatchBuilder>();}
    GRPCRouteMatchBuilder builder = new GRPCRouteMatchBuilder(item);
    if (index < 0 || index >= matches.size()) { _visitables.get("matches").add(builder); matches.add(builder); } else { _visitables.get("matches").set(index, builder); matches.set(index, builder);}
    return (A)this;
  }
  public A addToMatches(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteMatch... items) {
    if (this.matches == null) {this.matches = new ArrayList<GRPCRouteMatchBuilder>();}
    for (GRPCRouteMatch item : items) {GRPCRouteMatchBuilder builder = new GRPCRouteMatchBuilder(item);_visitables.get("matches").add(builder);this.matches.add(builder);} return (A)this;
  }
  public A addAllToMatches(Collection<GRPCRouteMatch> items) {
    if (this.matches == null) {this.matches = new ArrayList<GRPCRouteMatchBuilder>();}
    for (GRPCRouteMatch item : items) {GRPCRouteMatchBuilder builder = new GRPCRouteMatchBuilder(item);_visitables.get("matches").add(builder);this.matches.add(builder);} return (A)this;
  }
  public A removeFromMatches(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteMatch... items) {
    if (this.matches == null) return (A)this;
    for (GRPCRouteMatch item : items) {GRPCRouteMatchBuilder builder = new GRPCRouteMatchBuilder(item);_visitables.get("matches").remove(builder); this.matches.remove(builder);} return (A)this;
  }
  public A removeAllFromMatches(Collection<GRPCRouteMatch> items) {
    if (this.matches == null) return (A)this;
    for (GRPCRouteMatch item : items) {GRPCRouteMatchBuilder builder = new GRPCRouteMatchBuilder(item);_visitables.get("matches").remove(builder); this.matches.remove(builder);} return (A)this;
  }
  public A removeMatchingFromMatches(Predicate<GRPCRouteMatchBuilder> predicate) {
    if (matches == null) return (A) this;
    final Iterator<GRPCRouteMatchBuilder> each = matches.iterator();
    final List visitables = _visitables.get("matches");
    while (each.hasNext()) {
      GRPCRouteMatchBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<GRPCRouteMatch> buildMatches() {
    return matches != null ? build(matches) : null;
  }
  public GRPCRouteMatch buildMatch(int index) {
    return this.matches.get(index).build();
  }
  public GRPCRouteMatch buildFirstMatch() {
    return this.matches.get(0).build();
  }
  public GRPCRouteMatch buildLastMatch() {
    return this.matches.get(matches.size() - 1).build();
  }
  public GRPCRouteMatch buildMatchingMatch(Predicate<GRPCRouteMatchBuilder> predicate) {
    for (GRPCRouteMatchBuilder item: matches) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingMatch(Predicate<GRPCRouteMatchBuilder> predicate) {
    for (GRPCRouteMatchBuilder item: matches) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMatches(List<GRPCRouteMatch> matches) {
    if (this.matches != null) { _visitables.get("matches").clear();}
    if (matches != null) {this.matches = new ArrayList(); for (GRPCRouteMatch item : matches){this.addToMatches(item);}} else { this.matches = null;} return (A) this;
  }
  public A withMatches(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteMatch... matches) {
    if (this.matches != null) {this.matches.clear(); _visitables.remove("matches"); }
    if (matches != null) {for (GRPCRouteMatch item :matches){ this.addToMatches(item);}} return (A) this;
  }
  public boolean hasMatches() {
    return matches != null && !matches.isEmpty();
  }
  public MatchesNested<A> addNewMatch() {
    return new MatchesNested(-1, null);
  }
  public MatchesNested<A> addNewMatchLike(GRPCRouteMatch item) {
    return new MatchesNested(-1, item);
  }
  public MatchesNested<A> setNewMatchLike(int index,GRPCRouteMatch item) {
    return new MatchesNested(index, item);
  }
  public MatchesNested<A> editMatch(int index) {
    if (matches.size() <= index) throw new RuntimeException("Can't edit matches. Index exceeds size.");
    return setNewMatchLike(index, buildMatch(index));
  }
  public MatchesNested<A> editFirstMatch() {
    if (matches.size() == 0) throw new RuntimeException("Can't edit first matches. The list is empty.");
    return setNewMatchLike(0, buildMatch(0));
  }
  public MatchesNested<A> editLastMatch() {
    int index = matches.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last matches. The list is empty.");
    return setNewMatchLike(index, buildMatch(index));
  }
  public MatchesNested<A> editMatchingMatch(Predicate<GRPCRouteMatchBuilder> predicate) {
    int index = -1;
    for (int i=0;i<matches.size();i++) { 
    if (predicate.test(matches.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching matches. No match found.");
    return setNewMatchLike(index, buildMatch(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GRPCRouteRuleFluent that = (GRPCRouteRuleFluent) o;
    if (!java.util.Objects.equals(backendRefs, that.backendRefs)) return false;

    if (!java.util.Objects.equals(filters, that.filters)) return false;

    if (!java.util.Objects.equals(matches, that.matches)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(backendRefs,  filters,  matches,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (backendRefs != null && !backendRefs.isEmpty()) { sb.append("backendRefs:"); sb.append(backendRefs + ","); }
    if (filters != null && !filters.isEmpty()) { sb.append("filters:"); sb.append(filters + ","); }
    if (matches != null && !matches.isEmpty()) { sb.append("matches:"); sb.append(matches + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class BackendRefsNested<N> extends GRPCBackendRefFluent<BackendRefsNested<N>> implements Nested<N>{
    BackendRefsNested(int index,GRPCBackendRef item) {
      this.index = index;
      this.builder = new GRPCBackendRefBuilder(this, item);
    }
    GRPCBackendRefBuilder builder;
    int index;
    public N and() {
      return (N) GRPCRouteRuleFluent.this.setToBackendRefs(index,builder.build());
    }
    public N endBackendRef() {
      return and();
    }
    
  }
  public class FiltersNested<N> extends GRPCRouteFilterFluent<FiltersNested<N>> implements Nested<N>{
    FiltersNested(int index,GRPCRouteFilter item) {
      this.index = index;
      this.builder = new GRPCRouteFilterBuilder(this, item);
    }
    GRPCRouteFilterBuilder builder;
    int index;
    public N and() {
      return (N) GRPCRouteRuleFluent.this.setToFilters(index,builder.build());
    }
    public N endFilter() {
      return and();
    }
    
  }
  public class MatchesNested<N> extends GRPCRouteMatchFluent<MatchesNested<N>> implements Nested<N>{
    MatchesNested(int index,GRPCRouteMatch item) {
      this.index = index;
      this.builder = new GRPCRouteMatchBuilder(this, item);
    }
    GRPCRouteMatchBuilder builder;
    int index;
    public N and() {
      return (N) GRPCRouteRuleFluent.this.setToMatches(index,builder.build());
    }
    public N endMatch() {
      return and();
    }
    
  }
  
}