package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TLSRouteBuilder extends TLSRouteFluent<TLSRouteBuilder> implements VisitableBuilder<TLSRoute,TLSRouteBuilder>{
  public TLSRouteBuilder() {
    this(false);
  }
  public TLSRouteBuilder(Boolean validationEnabled) {
    this(new TLSRoute(), validationEnabled);
  }
  public TLSRouteBuilder(TLSRouteFluent<?> fluent) {
    this(fluent, false);
  }
  public TLSRouteBuilder(TLSRouteFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TLSRoute(), validationEnabled);
  }
  public TLSRouteBuilder(TLSRouteFluent<?> fluent,TLSRoute instance) {
    this(fluent, instance, false);
  }
  public TLSRouteBuilder(TLSRouteFluent<?> fluent,TLSRoute instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TLSRoute());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TLSRouteBuilder(TLSRoute instance) {
    this(instance,false);
  }
  public TLSRouteBuilder(TLSRoute instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TLSRoute());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TLSRouteFluent<?> fluent;
  Boolean validationEnabled;
  public TLSRoute build() {
    TLSRoute buildable = new TLSRoute(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}