package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class AllowedRoutesFluent<A extends AllowedRoutesFluent<A>> extends BaseFluent<A>{
  public AllowedRoutesFluent() {
  }
  public AllowedRoutesFluent(AllowedRoutes instance) {
    instance = (instance != null ? instance : new AllowedRoutes());

    if (instance != null) {
      this.withKinds(instance.getKinds());
      this.withNamespaces(instance.getNamespaces());
      this.withKinds(instance.getKinds());
      this.withNamespaces(instance.getNamespaces());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<RouteGroupKindBuilder> kinds = new ArrayList<RouteGroupKindBuilder>();
  private RouteNamespacesBuilder namespaces;
  private Map<String,Object> additionalProperties;
  public A addToKinds(int index,RouteGroupKind item) {
    if (this.kinds == null) {this.kinds = new ArrayList<RouteGroupKindBuilder>();}
    RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);
    if (index < 0 || index >= kinds.size()) { _visitables.get("kinds").add(builder); kinds.add(builder); } else { _visitables.get("kinds").add(index, builder); kinds.add(index, builder);}
    return (A)this;
  }
  public A setToKinds(int index,RouteGroupKind item) {
    if (this.kinds == null) {this.kinds = new ArrayList<RouteGroupKindBuilder>();}
    RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);
    if (index < 0 || index >= kinds.size()) { _visitables.get("kinds").add(builder); kinds.add(builder); } else { _visitables.get("kinds").set(index, builder); kinds.set(index, builder);}
    return (A)this;
  }
  public A addToKinds(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.RouteGroupKind... items) {
    if (this.kinds == null) {this.kinds = new ArrayList<RouteGroupKindBuilder>();}
    for (RouteGroupKind item : items) {RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);_visitables.get("kinds").add(builder);this.kinds.add(builder);} return (A)this;
  }
  public A addAllToKinds(Collection<RouteGroupKind> items) {
    if (this.kinds == null) {this.kinds = new ArrayList<RouteGroupKindBuilder>();}
    for (RouteGroupKind item : items) {RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);_visitables.get("kinds").add(builder);this.kinds.add(builder);} return (A)this;
  }
  public A removeFromKinds(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.RouteGroupKind... items) {
    if (this.kinds == null) return (A)this;
    for (RouteGroupKind item : items) {RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);_visitables.get("kinds").remove(builder); this.kinds.remove(builder);} return (A)this;
  }
  public A removeAllFromKinds(Collection<RouteGroupKind> items) {
    if (this.kinds == null) return (A)this;
    for (RouteGroupKind item : items) {RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);_visitables.get("kinds").remove(builder); this.kinds.remove(builder);} return (A)this;
  }
  public A removeMatchingFromKinds(Predicate<RouteGroupKindBuilder> predicate) {
    if (kinds == null) return (A) this;
    final Iterator<RouteGroupKindBuilder> each = kinds.iterator();
    final List visitables = _visitables.get("kinds");
    while (each.hasNext()) {
      RouteGroupKindBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<RouteGroupKind> buildKinds() {
    return kinds != null ? build(kinds) : null;
  }
  public RouteGroupKind buildKind(int index) {
    return this.kinds.get(index).build();
  }
  public RouteGroupKind buildFirstKind() {
    return this.kinds.get(0).build();
  }
  public RouteGroupKind buildLastKind() {
    return this.kinds.get(kinds.size() - 1).build();
  }
  public RouteGroupKind buildMatchingKind(Predicate<RouteGroupKindBuilder> predicate) {
    for (RouteGroupKindBuilder item: kinds) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingKind(Predicate<RouteGroupKindBuilder> predicate) {
    for (RouteGroupKindBuilder item: kinds) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withKinds(List<RouteGroupKind> kinds) {
    if (this.kinds != null) { _visitables.get("kinds").clear();}
    if (kinds != null) {this.kinds = new ArrayList(); for (RouteGroupKind item : kinds){this.addToKinds(item);}} else { this.kinds = null;} return (A) this;
  }
  public A withKinds(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.RouteGroupKind... kinds) {
    if (this.kinds != null) {this.kinds.clear(); _visitables.remove("kinds"); }
    if (kinds != null) {for (RouteGroupKind item :kinds){ this.addToKinds(item);}} return (A) this;
  }
  public boolean hasKinds() {
    return kinds != null && !kinds.isEmpty();
  }
  public A addNewKind(String group,String kind) {
    return (A)addToKinds(new RouteGroupKind(group, kind));
  }
  public KindsNested<A> addNewKind() {
    return new KindsNested(-1, null);
  }
  public KindsNested<A> addNewKindLike(RouteGroupKind item) {
    return new KindsNested(-1, item);
  }
  public KindsNested<A> setNewKindLike(int index,RouteGroupKind item) {
    return new KindsNested(index, item);
  }
  public KindsNested<A> editKind(int index) {
    if (kinds.size() <= index) throw new RuntimeException("Can't edit kinds. Index exceeds size.");
    return setNewKindLike(index, buildKind(index));
  }
  public KindsNested<A> editFirstKind() {
    if (kinds.size() == 0) throw new RuntimeException("Can't edit first kinds. The list is empty.");
    return setNewKindLike(0, buildKind(0));
  }
  public KindsNested<A> editLastKind() {
    int index = kinds.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last kinds. The list is empty.");
    return setNewKindLike(index, buildKind(index));
  }
  public KindsNested<A> editMatchingKind(Predicate<RouteGroupKindBuilder> predicate) {
    int index = -1;
    for (int i=0;i<kinds.size();i++) { 
    if (predicate.test(kinds.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching kinds. No match found.");
    return setNewKindLike(index, buildKind(index));
  }
  public RouteNamespaces buildNamespaces() {
    return this.namespaces!=null ?this.namespaces.build():null;
  }
  public A withNamespaces(RouteNamespaces namespaces) {
    _visitables.get("namespaces").remove(this.namespaces);
    if (namespaces!=null){ this.namespaces= new RouteNamespacesBuilder(namespaces); _visitables.get("namespaces").add(this.namespaces);} else { this.namespaces = null; _visitables.get("namespaces").remove(this.namespaces); } return (A) this;
  }
  public boolean hasNamespaces() {
    return this.namespaces != null;
  }
  public NamespacesNested<A> withNewNamespaces() {
    return new NamespacesNested(null);
  }
  public NamespacesNested<A> withNewNamespacesLike(RouteNamespaces item) {
    return new NamespacesNested(item);
  }
  public NamespacesNested<A> editNamespaces() {
    return withNewNamespacesLike(java.util.Optional.ofNullable(buildNamespaces()).orElse(null));
  }
  public NamespacesNested<A> editOrNewNamespaces() {
    return withNewNamespacesLike(java.util.Optional.ofNullable(buildNamespaces()).orElse(new RouteNamespacesBuilder().build()));
  }
  public NamespacesNested<A> editOrNewNamespacesLike(RouteNamespaces item) {
    return withNewNamespacesLike(java.util.Optional.ofNullable(buildNamespaces()).orElse(item));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AllowedRoutesFluent that = (AllowedRoutesFluent) o;
    if (!java.util.Objects.equals(kinds, that.kinds)) return false;

    if (!java.util.Objects.equals(namespaces, that.namespaces)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(kinds,  namespaces,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (kinds != null && !kinds.isEmpty()) { sb.append("kinds:"); sb.append(kinds + ","); }
    if (namespaces != null) { sb.append("namespaces:"); sb.append(namespaces + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class KindsNested<N> extends RouteGroupKindFluent<KindsNested<N>> implements Nested<N>{
    KindsNested(int index,RouteGroupKind item) {
      this.index = index;
      this.builder = new RouteGroupKindBuilder(this, item);
    }
    RouteGroupKindBuilder builder;
    int index;
    public N and() {
      return (N) AllowedRoutesFluent.this.setToKinds(index,builder.build());
    }
    public N endKind() {
      return and();
    }
    
  }
  public class NamespacesNested<N> extends RouteNamespacesFluent<NamespacesNested<N>> implements Nested<N>{
    NamespacesNested(RouteNamespaces item) {
      this.builder = new RouteNamespacesBuilder(this, item);
    }
    RouteNamespacesBuilder builder;
    public N and() {
      return (N) AllowedRoutesFluent.this.withNamespaces(builder.build());
    }
    public N endNamespaces() {
      return and();
    }
    
  }
  
}