package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class GatewayTLSConfigFluent<A extends GatewayTLSConfigFluent<A>> extends BaseFluent<A>{
  public GatewayTLSConfigFluent() {
  }
  public GatewayTLSConfigFluent(GatewayTLSConfig instance) {
    instance = (instance != null ? instance : new GatewayTLSConfig());

    if (instance != null) {
      this.withCertificateRefs(instance.getCertificateRefs());
      this.withMode(instance.getMode());
      this.withOptions(instance.getOptions());
      this.withCertificateRefs(instance.getCertificateRefs());
      this.withMode(instance.getMode());
      this.withOptions(instance.getOptions());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<SecretObjectReferenceBuilder> certificateRefs = new ArrayList<SecretObjectReferenceBuilder>();
  private String mode;
  private Map<String,String> options;
  private Map<String,Object> additionalProperties;
  public A addToCertificateRefs(int index,SecretObjectReference item) {
    if (this.certificateRefs == null) {this.certificateRefs = new ArrayList<SecretObjectReferenceBuilder>();}
    SecretObjectReferenceBuilder builder = new SecretObjectReferenceBuilder(item);
    if (index < 0 || index >= certificateRefs.size()) { _visitables.get("certificateRefs").add(builder); certificateRefs.add(builder); } else { _visitables.get("certificateRefs").add(index, builder); certificateRefs.add(index, builder);}
    return (A)this;
  }
  public A setToCertificateRefs(int index,SecretObjectReference item) {
    if (this.certificateRefs == null) {this.certificateRefs = new ArrayList<SecretObjectReferenceBuilder>();}
    SecretObjectReferenceBuilder builder = new SecretObjectReferenceBuilder(item);
    if (index < 0 || index >= certificateRefs.size()) { _visitables.get("certificateRefs").add(builder); certificateRefs.add(builder); } else { _visitables.get("certificateRefs").set(index, builder); certificateRefs.set(index, builder);}
    return (A)this;
  }
  public A addToCertificateRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.SecretObjectReference... items) {
    if (this.certificateRefs == null) {this.certificateRefs = new ArrayList<SecretObjectReferenceBuilder>();}
    for (SecretObjectReference item : items) {SecretObjectReferenceBuilder builder = new SecretObjectReferenceBuilder(item);_visitables.get("certificateRefs").add(builder);this.certificateRefs.add(builder);} return (A)this;
  }
  public A addAllToCertificateRefs(Collection<SecretObjectReference> items) {
    if (this.certificateRefs == null) {this.certificateRefs = new ArrayList<SecretObjectReferenceBuilder>();}
    for (SecretObjectReference item : items) {SecretObjectReferenceBuilder builder = new SecretObjectReferenceBuilder(item);_visitables.get("certificateRefs").add(builder);this.certificateRefs.add(builder);} return (A)this;
  }
  public A removeFromCertificateRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.SecretObjectReference... items) {
    if (this.certificateRefs == null) return (A)this;
    for (SecretObjectReference item : items) {SecretObjectReferenceBuilder builder = new SecretObjectReferenceBuilder(item);_visitables.get("certificateRefs").remove(builder); this.certificateRefs.remove(builder);} return (A)this;
  }
  public A removeAllFromCertificateRefs(Collection<SecretObjectReference> items) {
    if (this.certificateRefs == null) return (A)this;
    for (SecretObjectReference item : items) {SecretObjectReferenceBuilder builder = new SecretObjectReferenceBuilder(item);_visitables.get("certificateRefs").remove(builder); this.certificateRefs.remove(builder);} return (A)this;
  }
  public A removeMatchingFromCertificateRefs(Predicate<SecretObjectReferenceBuilder> predicate) {
    if (certificateRefs == null) return (A) this;
    final Iterator<SecretObjectReferenceBuilder> each = certificateRefs.iterator();
    final List visitables = _visitables.get("certificateRefs");
    while (each.hasNext()) {
      SecretObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<SecretObjectReference> buildCertificateRefs() {
    return certificateRefs != null ? build(certificateRefs) : null;
  }
  public SecretObjectReference buildCertificateRef(int index) {
    return this.certificateRefs.get(index).build();
  }
  public SecretObjectReference buildFirstCertificateRef() {
    return this.certificateRefs.get(0).build();
  }
  public SecretObjectReference buildLastCertificateRef() {
    return this.certificateRefs.get(certificateRefs.size() - 1).build();
  }
  public SecretObjectReference buildMatchingCertificateRef(Predicate<SecretObjectReferenceBuilder> predicate) {
    for (SecretObjectReferenceBuilder item: certificateRefs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingCertificateRef(Predicate<SecretObjectReferenceBuilder> predicate) {
    for (SecretObjectReferenceBuilder item: certificateRefs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCertificateRefs(List<SecretObjectReference> certificateRefs) {
    if (this.certificateRefs != null) { _visitables.get("certificateRefs").clear();}
    if (certificateRefs != null) {this.certificateRefs = new ArrayList(); for (SecretObjectReference item : certificateRefs){this.addToCertificateRefs(item);}} else { this.certificateRefs = null;} return (A) this;
  }
  public A withCertificateRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.SecretObjectReference... certificateRefs) {
    if (this.certificateRefs != null) {this.certificateRefs.clear(); _visitables.remove("certificateRefs"); }
    if (certificateRefs != null) {for (SecretObjectReference item :certificateRefs){ this.addToCertificateRefs(item);}} return (A) this;
  }
  public boolean hasCertificateRefs() {
    return certificateRefs != null && !certificateRefs.isEmpty();
  }
  public A addNewCertificateRef(String group,String kind,String name,String namespace) {
    return (A)addToCertificateRefs(new SecretObjectReference(group, kind, name, namespace));
  }
  public CertificateRefsNested<A> addNewCertificateRef() {
    return new CertificateRefsNested(-1, null);
  }
  public CertificateRefsNested<A> addNewCertificateRefLike(SecretObjectReference item) {
    return new CertificateRefsNested(-1, item);
  }
  public CertificateRefsNested<A> setNewCertificateRefLike(int index,SecretObjectReference item) {
    return new CertificateRefsNested(index, item);
  }
  public CertificateRefsNested<A> editCertificateRef(int index) {
    if (certificateRefs.size() <= index) throw new RuntimeException("Can't edit certificateRefs. Index exceeds size.");
    return setNewCertificateRefLike(index, buildCertificateRef(index));
  }
  public CertificateRefsNested<A> editFirstCertificateRef() {
    if (certificateRefs.size() == 0) throw new RuntimeException("Can't edit first certificateRefs. The list is empty.");
    return setNewCertificateRefLike(0, buildCertificateRef(0));
  }
  public CertificateRefsNested<A> editLastCertificateRef() {
    int index = certificateRefs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last certificateRefs. The list is empty.");
    return setNewCertificateRefLike(index, buildCertificateRef(index));
  }
  public CertificateRefsNested<A> editMatchingCertificateRef(Predicate<SecretObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<certificateRefs.size();i++) { 
    if (predicate.test(certificateRefs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching certificateRefs. No match found.");
    return setNewCertificateRefLike(index, buildCertificateRef(index));
  }
  public String getMode() {
    return this.mode;
  }
  public A withMode(String mode) {
    this.mode=mode; return (A) this;
  }
  public boolean hasMode() {
    return this.mode != null;
  }
  public A addToOptions(String key,String value) {
    if(this.options == null && key != null && value != null) { this.options = new LinkedHashMap(); }
    if(key != null && value != null) {this.options.put(key, value);} return (A)this;
  }
  public A addToOptions(Map<String,String> map) {
    if(this.options == null && map != null) { this.options = new LinkedHashMap(); }
    if(map != null) { this.options.putAll(map);} return (A)this;
  }
  public A removeFromOptions(String key) {
    if(this.options == null) { return (A) this; }
    if(key != null && this.options != null) {this.options.remove(key);} return (A)this;
  }
  public A removeFromOptions(Map<String,String> map) {
    if(this.options == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.options != null){this.options.remove(key);}}} return (A)this;
  }
  public Map<String,String> getOptions() {
    return this.options;
  }
  public <K,V>A withOptions(Map<String,String> options) {
    if (options == null) { this.options =  null;} else {this.options = new LinkedHashMap(options);} return (A) this;
  }
  public boolean hasOptions() {
    return this.options != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GatewayTLSConfigFluent that = (GatewayTLSConfigFluent) o;
    if (!java.util.Objects.equals(certificateRefs, that.certificateRefs)) return false;

    if (!java.util.Objects.equals(mode, that.mode)) return false;

    if (!java.util.Objects.equals(options, that.options)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(certificateRefs,  mode,  options,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (certificateRefs != null && !certificateRefs.isEmpty()) { sb.append("certificateRefs:"); sb.append(certificateRefs + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (options != null && !options.isEmpty()) { sb.append("options:"); sb.append(options + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CertificateRefsNested<N> extends SecretObjectReferenceFluent<CertificateRefsNested<N>> implements Nested<N>{
    CertificateRefsNested(int index,SecretObjectReference item) {
      this.index = index;
      this.builder = new SecretObjectReferenceBuilder(this, item);
    }
    SecretObjectReferenceBuilder builder;
    int index;
    public N and() {
      return (N) GatewayTLSConfigFluent.this.setToCertificateRefs(index,builder.build());
    }
    public N endCertificateRef() {
      return and();
    }
    
  }
  
}