package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPHeaderFilterBuilder extends HTTPHeaderFilterFluent<HTTPHeaderFilterBuilder> implements VisitableBuilder<HTTPHeaderFilter,HTTPHeaderFilterBuilder>{
  public HTTPHeaderFilterBuilder() {
    this(false);
  }
  public HTTPHeaderFilterBuilder(Boolean validationEnabled) {
    this(new HTTPHeaderFilter(), validationEnabled);
  }
  public HTTPHeaderFilterBuilder(HTTPHeaderFilterFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPHeaderFilterBuilder(HTTPHeaderFilterFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPHeaderFilter(), validationEnabled);
  }
  public HTTPHeaderFilterBuilder(HTTPHeaderFilterFluent<?> fluent,HTTPHeaderFilter instance) {
    this(fluent, instance, false);
  }
  public HTTPHeaderFilterBuilder(HTTPHeaderFilterFluent<?> fluent,HTTPHeaderFilter instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new HTTPHeaderFilter());

    if (instance != null) {
      fluent.withAdd(instance.getAdd());
      fluent.withRemove(instance.getRemove());
      fluent.withSet(instance.getSet());
      fluent.withAdd(instance.getAdd());
      fluent.withRemove(instance.getRemove());
      fluent.withSet(instance.getSet());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HTTPHeaderFilterBuilder(HTTPHeaderFilter instance) {
    this(instance,false);
  }
  public HTTPHeaderFilterBuilder(HTTPHeaderFilter instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new HTTPHeaderFilter());

    if (instance != null) {
      this.withAdd(instance.getAdd());
      this.withRemove(instance.getRemove());
      this.withSet(instance.getSet());
      this.withAdd(instance.getAdd());
      this.withRemove(instance.getRemove());
      this.withSet(instance.getSet());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  HTTPHeaderFilterFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPHeaderFilter build() {
    HTTPHeaderFilter buildable = new HTTPHeaderFilter(fluent.buildAdd(),fluent.getRemove(),fluent.buildSet());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}