/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mq;

import io.fabric8.mq.ActiveMQService;
import io.fabric8.mq.ConsumerThread;
import io.fabric8.mq.ProducerThread;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnectionFactory;

public class Main {
    static final String loggingLevelProperty = "org.ops4j.pax.logging.DefaultServiceLog.level";
    String action;
    String destination;
    String brokerUrl = ActiveMQConnectionFactory.DEFAULT_BROKER_URL;
    boolean persistent = true;
    int count = 100;
    int sleep = 0;
    int size = 0;
    long ttl = 0L;
    int parallelThreads = 1;
    String textSize;
    String clientId;
    String password;
    String user;
    String groupID;
    int batchSize;

    public static void main(String[] args) throws Exception {
        if (System.getProperty(loggingLevelProperty) == null) {
            System.setProperty(loggingLevelProperty, "INFO");
        }
        Main main = new Main();
        LinkedList<String> arg1 = new LinkedList<String>(Arrays.asList(args));
        main.action = Main.shift(arg1);
        while (!arg1.isEmpty()) {
            try {
                String arg = arg1.removeFirst();
                if ("--ttl".equals(arg)) {
                    main.ttl = Long.parseLong(Main.shift(arg1));
                    continue;
                }
                if ("--size".equals(arg)) {
                    main.size = Integer.parseInt(Main.shift(arg1));
                    continue;
                }
                if ("--textSize".equals(arg)) {
                    main.textSize = Main.shift(arg1);
                    continue;
                }
                if ("--count".equals(arg)) {
                    main.count = Integer.parseInt(Main.shift(arg1));
                    continue;
                }
                if ("--sleep".equals(arg)) {
                    main.sleep = Integer.parseInt(Main.shift(arg1));
                    continue;
                }
                if ("--destination".equals(arg)) {
                    main.destination = Main.shift(arg1);
                    continue;
                }
                if ("--brokerUrl".equals(arg)) {
                    main.brokerUrl = Main.shift(arg1);
                    continue;
                }
                if ("--groupId".equals(arg)) {
                    main.groupID = Main.shift(arg1);
                    continue;
                }
                if ("--user".equals(arg)) {
                    main.user = Main.shift(arg1);
                    continue;
                }
                if ("--password".equals(arg)) {
                    main.password = Main.shift(arg1);
                    continue;
                }
                if ("--clientId".equals(arg)) {
                    main.clientId = Main.shift(arg1);
                    continue;
                }
                if ("--batchSize".equals(arg)) {
                    main.batchSize = Integer.parseInt(Main.shift(arg1));
                    continue;
                }
                if ("--persistent".equals(arg)) {
                    main.persistent = Boolean.valueOf(Main.shift(arg1));
                    continue;
                }
                if ("--parallelThreads".equals(arg)) {
                    main.parallelThreads = Integer.parseInt(Main.shift(arg1));
                    continue;
                }
                System.err.println("Invalid usage: unknown option: " + arg);
                Main.displayHelpAndExit(1);
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid usage: argument not a number");
                Main.displayHelpAndExit(1);
            }
        }
        main.execute();
        System.exit(0);
    }

    private void execute() {
        this.initDestination();
        System.out.println("Using destination: " + this.destination + ", on broker: " + this.brokerUrl);
        ArrayList<ProducerThread> producerThreads = new ArrayList<ProducerThread>();
        ArrayList<ConsumerThread> consumerThreads = new ArrayList<ConsumerThread>();
        for (int i = 1; i <= this.parallelThreads; ++i) {
            ActiveMQService activeMQService = new ActiveMQService(this.user, this.password, this.brokerUrl);
            activeMQService.setTransacted(this.batchSize > 0);
            try {
                if ("producer".equals(this.action)) {
                    ProducerThread producerThread = new ProducerThread(activeMQService, this.destination);
                    producerThread.setMessageCount(this.count);
                    producerThread.setMessageSize(this.size);
                    producerThread.setTextMessageSize(this.textSize);
                    producerThread.setSleep(this.sleep);
                    producerThread.setPersistent(this.persistent);
                    producerThread.setTransactionBatchSize(this.batchSize);
                    producerThread.setTTL(this.ttl);
                    producerThread.setMsgGroupID(this.groupID);
                    producerThread.start();
                    producerThreads.add(producerThread);
                    continue;
                }
                if ("consumer".equals(this.action)) {
                    activeMQService.setClientId(this.clientId);
                    activeMQService.start();
                    ConsumerThread consumerThread = new ConsumerThread(activeMQService, this.destination);
                    consumerThread.setMessageCount(this.count);
                    consumerThread.setSleep(this.sleep);
                    consumerThread.setTransactionBatchSize(this.batchSize);
                    consumerThread.start();
                    consumerThreads.add(consumerThread);
                    continue;
                }
                Main.displayHelpAndExit(1);
                continue;
            }
            catch (JMSException error) {
                System.err.println(Thread.currentThread().getName() + "Execution failed with: " + (Object)((Object)error));
                error.printStackTrace(System.err);
                System.exit(2);
            }
        }
        while (true) {
            Iterator itr = null;
            if (producerThreads.size() > 0) {
                itr = producerThreads.iterator();
            }
            if (consumerThreads.size() > 0) {
                itr = consumerThreads.iterator();
            }
            int running = 0;
            while (itr.hasNext()) {
                Thread thread = (Thread)itr.next();
                if (!thread.isAlive()) continue;
                ++running;
            }
            if (running <= 0) break;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {}
        }
        System.out.println("All threads completed their work");
    }

    private void initDestination() {
        if (this.destination == null) {
            this.destination = this.clientId != null ? "topic://TEST" : "queue://TEST";
        }
    }

    private static String shift(LinkedList<String> argl) {
        if (argl.isEmpty()) {
            System.out.println("Invalid usage: Missing argument");
            Main.displayHelpAndExit(1);
        }
        return argl.removeFirst();
    }

    private static void displayHelpAndExit(int exitCode) {
        System.out.println(" usage   : (producer|consumer) [OPTIONS]");
        System.out.println(" options : [--destination (queue://..|topic://..) - ; default TEST");
        System.out.println("           [--persistent  true|false] - use persistent or non persistent messages; default true");
        System.out.println("           [--count           N] - number of messages to send or receive; default 100");
        System.out.println("           [--size            N] - size in bytes of a BytesMessage; default 0, a simple TextMessage is used");
        System.out.println("           [--textSize        N] - size in bytes of a TextMessage (supported values : 100b, 1K, 10K); default 100b, a Lorem ipsum dummy TextMessage is used");
        System.out.println("           [--sleep           N] - millisecond sleep period between sends or receives; default 0");
        System.out.println("           [--batchSize       N] - use send and receive transaction batches of size N; default 0, no jms transactions");
        System.out.println("           [--ttl             N] - message TTL in milliseconds");
        System.out.println("           [--parallelThreads N] - number of threads to run in parallel; default 1");
        System.out.println("           [--groupId       .. ] - JMS message group identifier");
        System.out.println("           [--clientId       id] - use a durable topic consumer with the supplied id; default null, non durable consumer");
        System.out.println("           [--brokerUrl     URL] - connection factory url; default " + ActiveMQConnectionFactory.DEFAULT_BROKER_URL);
        System.out.println("           [--user          .. ] - connection user name");
        System.out.println("           [--password      .. ] - connection password");
        System.out.println("");
        System.exit(exitCode);
    }
}

