/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mq.fabric.discovery;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.groups.Group;
import io.fabric8.groups.GroupListener;
import io.fabric8.groups.MultiGroup;
import io.fabric8.groups.NodeState;
import io.fabric8.groups.internal.ManagedGroupFactory;
import io.fabric8.groups.internal.ManagedGroupFactoryBuilder;
import io.fabric8.zookeeper.curator.CuratorACLManager;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.command.DiscoveryEvent;
import org.apache.activemq.transport.discovery.DiscoveryAgent;
import org.apache.activemq.transport.discovery.DiscoveryListener;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.retry.RetryOneTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricDiscoveryAgent
implements DiscoveryAgent,
Callable {
    private static final Logger LOG = LoggerFactory.getLogger(FabricDiscoveryAgent.class);
    protected CuratorFramework curator;
    private boolean managedZkClient;
    private String groupName = "default";
    private AtomicBoolean running = new AtomicBoolean();
    private final AtomicReference<DiscoveryListener> discoveryListener = new AtomicReference();
    private final HashMap<String, SimpleDiscoveryEvent> discoveredServices = new HashMap();
    private final AtomicInteger startCounter = new AtomicInteger(0);
    private long initialReconnectDelay = 1000L;
    private long maxReconnectDelay = 30000L;
    private long backOffMultiplier = 2L;
    private boolean useExponentialBackOff = true;
    private int maxReconnectAttempts = 0;
    private final Object sleepMutex = new Object();
    private long minConnectTime = 5000L;
    private String id;
    private String agent;
    MultiGroup<ActiveMQNode> group;
    ManagedGroupFactory factory;
    List<String> services = new ArrayList<String>();

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    ActiveMQNode createState() {
        ActiveMQNode state = new ActiveMQNode(this.id, this.agent);
        state.id = this.id;
        state.services = this.services.toArray(new String[this.services.size()]);
        return state;
    }

    public synchronized void registerService(String service) throws IOException {
        this.services.add(service);
        this.updateClusterState();
    }

    public void updateClusterState() {
        if (this.startCounter.get() > 0) {
            if (this.id == null) {
                throw new IllegalStateException("You must configure the id of the fabric discovery if you want to register services");
            }
            this.group.update((NodeState)this.createState());
        }
    }

    public void serviceFailed(DiscoveryEvent devent) throws IOException {
        final SimpleDiscoveryEvent event = (SimpleDiscoveryEvent)devent;
        if (event.failed.compareAndSet(false, true)) {
            this.discoveryListener.get().onServiceRemove((DiscoveryEvent)event);
            if (!event.removed.get()) {
                Thread thread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (event.connectTime + FabricDiscoveryAgent.this.minConnectTime > System.currentTimeMillis()) {
                            LOG.debug("Failure occurred soon after the discovery event was generated.  It will be classified as a connection failure: " + (Object)((Object)event));
                            event.connectFailures++;
                            if (FabricDiscoveryAgent.this.maxReconnectAttempts > 0 && event.connectFailures >= FabricDiscoveryAgent.this.maxReconnectAttempts) {
                                LOG.debug("Reconnect attempts exceeded " + FabricDiscoveryAgent.this.maxReconnectAttempts + " tries.  Reconnecting has been disabled.");
                                return;
                            }
                            Object object = FabricDiscoveryAgent.this.sleepMutex;
                            synchronized (object) {
                                try {
                                    if (!FabricDiscoveryAgent.this.running.get() || event.removed.get()) {
                                        return;
                                    }
                                    LOG.debug("Waiting " + event.reconnectDelay + " ms before attempting to reconnect.");
                                    FabricDiscoveryAgent.this.sleepMutex.wait(event.reconnectDelay);
                                }
                                catch (InterruptedException ie) {
                                    Thread.currentThread().interrupt();
                                    return;
                                }
                            }
                            if (!FabricDiscoveryAgent.this.useExponentialBackOff) {
                                event.reconnectDelay = FabricDiscoveryAgent.this.initialReconnectDelay;
                            } else {
                                event.reconnectDelay *= FabricDiscoveryAgent.this.backOffMultiplier;
                                if (event.reconnectDelay > FabricDiscoveryAgent.this.maxReconnectDelay) {
                                    event.reconnectDelay = FabricDiscoveryAgent.this.maxReconnectDelay;
                                }
                            }
                        } else {
                            event.connectFailures = 0;
                            event.reconnectDelay = FabricDiscoveryAgent.this.initialReconnectDelay;
                        }
                        if (!FabricDiscoveryAgent.this.running.get() || event.removed.get()) {
                            return;
                        }
                        event.connectTime = System.currentTimeMillis();
                        event.failed.set(false);
                        ((DiscoveryListener)FabricDiscoveryAgent.this.discoveryListener.get()).onServiceAdd((DiscoveryEvent)event);
                    }
                };
                thread.setDaemon(true);
                thread.start();
            }
        }
    }

    public void setDiscoveryListener(DiscoveryListener discoveryListener) {
        this.discoveryListener.set(discoveryListener);
    }

    public synchronized void start() throws Exception {
        if (this.startCounter.addAndGet(1) == 1) {
            this.running.set(true);
            if (this.curator != null) {
                this.managedZkClient = false;
            }
            this.getGroup().add((GroupListener)new GroupListener<ActiveMQNode>(){

                public void groupEvent(Group<ActiveMQNode> group, GroupListener.GroupEvent event) {
                    HashMap<String, ActiveMQNode> masters = new HashMap<String, ActiveMQNode>();
                    for (ActiveMQNode node : group.members().values()) {
                        if (masters.containsKey(node.id)) continue;
                        masters.put(node.id, node);
                    }
                    FabricDiscoveryAgent.this.update(masters.values());
                }
            });
            if (this.id != null) {
                this.group.update((NodeState)this.createState());
            }
            this.group.start();
        }
    }

    public synchronized void stop() throws Exception {
        if (this.startCounter.decrementAndGet() == 0) {
            this.running.set(false);
            try {
                if (this.group != null) {
                    this.group.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.managedZkClient) {
                try {
                    this.curator.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.curator = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Collection<ActiveMQNode> members) {
        DiscoveryListener discoveryListener = this.discoveryListener.get();
        if (discoveryListener != null) {
            HashSet<String> activeServices = new HashSet<String>();
            for (ActiveMQNode m : members) {
                String[] arr$ = m.services;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String service;
                    String resolved = service = arr$[i$];
                    try {
                        resolved = ZooKeeperUtils.getSubstitutedData((CuratorFramework)this.curator, (String)service);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!resolved.startsWith("tcp:") && !resolved.startsWith("ssl:") && !resolved.startsWith("nio:") && !resolved.startsWith("nio+ssl:")) continue;
                    activeServices.add(resolved);
                }
            }
            if (members != null && members.size() > 0) {
                HashMap<String, SimpleDiscoveryEvent> hashMap = this.discoveredServices;
                synchronized (hashMap) {
                    SimpleDiscoveryEvent e;
                    HashSet<String> removedServices = new HashSet<String>(this.discoveredServices.keySet());
                    removedServices.removeAll(activeServices);
                    HashSet addedServices = new HashSet(activeServices);
                    addedServices.removeAll(this.discoveredServices.keySet());
                    addedServices.removeAll(removedServices);
                    for (String service : addedServices) {
                        e = new SimpleDiscoveryEvent(service);
                        this.discoveredServices.put(service, e);
                        discoveryListener.onServiceAdd((DiscoveryEvent)e);
                    }
                    for (String service : removedServices) {
                        e = this.discoveredServices.remove(service);
                        if (e != null) {
                            e.removed.set(true);
                        }
                        discoveryListener.onServiceRemove((DiscoveryEvent)e);
                    }
                }
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getServices() {
        return this.services;
    }

    public void setServices(String[] services) {
        this.services.clear();
        for (String s : services) {
            this.services.add(s);
        }
        this.updateClusterState();
    }

    public MultiGroup<ActiveMQNode> getGroup() throws Exception {
        if (this.group == null) {
            this.factory = ManagedGroupFactoryBuilder.create((CuratorFramework)this.curator, (ClassLoader)this.getClass().getClassLoader(), (Callable)this);
            this.group = (MultiGroup)this.factory.createMultiGroup("/fabric/registry/clusters/amq/" + this.groupName, ActiveMQNode.class);
            this.curator = this.factory.getCurator();
        }
        return this.group;
    }

    public Object call() throws Exception {
        LOG.info("Using local ZKClient");
        this.managedZkClient = true;
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(System.getProperty("zookeeper.url", "localhost:2181")).retryPolicy((RetryPolicy)new RetryOneTime(1000)).connectionTimeoutMs(10000);
        String password = System.getProperty("zookeeper.password", "admin");
        if (password != null && !password.isEmpty()) {
            builder.aclProvider((ACLProvider)new CuratorACLManager());
            builder.authorization("digest", ("fabric:" + password).getBytes());
        }
        CuratorFramework client = builder.build();
        client.start();
        client.getZookeeperClient().blockUntilConnectedOrTimedOut();
        return client;
    }

    public CuratorFramework getCurator() {
        return this.curator;
    }

    public void setCurator(CuratorFramework curator) {
        this.curator = curator;
    }

    public String getAgent() {
        return this.agent;
    }

    public void setAgent(String agent) {
        this.agent = agent;
    }

    class SimpleDiscoveryEvent
    extends DiscoveryEvent {
        private int connectFailures;
        private long reconnectDelay;
        private long connectTime;
        private AtomicBoolean failed;
        private AtomicBoolean removed;

        public SimpleDiscoveryEvent(String service) {
            super(service);
            this.reconnectDelay = FabricDiscoveryAgent.this.initialReconnectDelay;
            this.connectTime = System.currentTimeMillis();
            this.failed = new AtomicBoolean(false);
            this.removed = new AtomicBoolean(false);
        }
    }

    public static class ActiveMQNode
    extends NodeState {
        @JsonProperty
        String[] services;

        public ActiveMQNode() {
        }

        public ActiveMQNode(String id, String container) {
            super(id, container);
        }
    }
}

