/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mq.fabric;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.groups.Group;
import io.fabric8.groups.GroupListener;
import io.fabric8.mq.fabric.FabricDiscoveryAgent;
import java.beans.PropertyEditorManager;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerContext;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.network.DiscoveryNetworkConnector;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.spring.SpringBrokerContext;
import org.apache.activemq.spring.Utils;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.curator.framework.CuratorFramework;
import org.apache.xbean.classloader.MultiParentClassLoader;
import org.apache.xbean.spring.context.ResourceXmlApplicationContext;
import org.apache.xbean.spring.context.impl.URIEditor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;

public class ActiveMQServiceFactory
implements ManagedServiceFactory,
ServiceTrackerCustomizer<CuratorFramework, CuratorFramework> {
    public static final Logger LOG = LoggerFactory.getLogger(ActiveMQServiceFactory.class);
    public static final ThreadLocal<Properties> CONFIG_PROPERTIES = new ThreadLocal();
    private BundleContext bundleContext;
    private Set<String> ownedPools = new HashSet<String>();
    private Map<String, ClusteredConfiguration> configurations = new HashMap<String, ClusteredConfiguration>();
    private ServiceTracker<FabricService, FabricService> fabricService;
    private ConfigThread config_thread;
    private CuratorFramework curator;
    private final List<ServiceReference<CuratorFramework>> boundCuratorRefs = new ArrayList<ServiceReference<CuratorFramework>>();
    private ServiceTracker<CuratorFramework, CuratorFramework> curatorService;
    private Filter filter;
    private ServiceTracker<URLStreamHandlerService, URLStreamHandlerService> urlHandlerService;

    public ActiveMQServiceFactory(BundleContext bundleContext) throws InvalidSyntaxException {
        this.bundleContext = bundleContext;
        this.config_thread = new ConfigThread();
        this.config_thread.setName("ActiveMQ Configuration Watcher");
        this.config_thread.start();
        this.fabricService = new ServiceTracker(this.bundleContext, FabricService.class, null);
        this.fabricService.open();
        this.curatorService = new ServiceTracker(this.bundleContext, CuratorFramework.class, (ServiceTrackerCustomizer)this);
        this.curatorService.open();
        this.filter = FrameworkUtil.createFilter((String)"(&(objectClass=org.osgi.service.url.URLStreamHandlerService)(url.handler.protocol=profile))");
        this.urlHandlerService = new ServiceTracker(this.bundleContext, this.filter, null);
        this.urlHandlerService.open();
    }

    public static void info(String str) {
        if (LOG.isInfoEnabled()) {
            LOG.info(str);
        }
    }

    public static void info(String str, Object ... args) {
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format(str, args));
        }
    }

    public static void debug(String str) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(str);
        }
    }

    public static void debug(String str, Object ... args) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format(str, args));
        }
    }

    public static void warn(String str) {
        if (LOG.isWarnEnabled()) {
            LOG.warn(str);
        }
    }

    public static void warn(String str, Object ... args) {
        if (LOG.isWarnEnabled()) {
            LOG.warn(String.format(str, args));
        }
    }

    public static Dictionary<String, Object> toDictionary(Properties properties) {
        Hashtable<String, Object> answer = new Hashtable<String, Object>();
        for (String k : properties.stringPropertyNames()) {
            answer.put(k, properties.getProperty(k));
        }
        return answer;
    }

    public static Properties toProperties(Dictionary<?, ?> properties) {
        Properties props = new Properties();
        Enumeration<?> keys = properties.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = properties.get(key);
            props.put(key.toString(), value != null ? value.toString() : "");
        }
        return props;
    }

    public static <T> T arg_error(String msg) {
        throw new IllegalArgumentException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerInfo createBroker(String uri, Properties properties) throws Exception {
        CONFIG_PROPERTIES.set(properties);
        try {
            String[] networksTab;
            String name;
            MultiParentClassLoader classLoader = new MultiParentClassLoader("xbean", new URL[0], new ClassLoader[]{this.getClass().getClassLoader(), BrokerService.class.getClassLoader()});
            Thread.currentThread().setContextClassLoader((ClassLoader)classLoader);
            Resource resource = Utils.resourceFromString((String)uri);
            ResourceXmlApplicationContext ctx = new ResourceXmlApplicationContext(resource){

                protected void initBeanDefinitionReader(XmlBeanDefinitionReader reader) {
                    reader.setValidating(false);
                }
            };
            String[] names = ctx.getBeanNamesForType(BrokerService.class);
            BrokerService broker = null;
            String[] arr$ = names;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (broker = (BrokerService)ctx.getBean(name = arr$[i$], BrokerService.class)) == null; ++i$) {
            }
            if (broker == null) {
                ActiveMQServiceFactory.arg_error("Configuration did not contain a BrokerService");
            }
            String networks = properties.getProperty("network", "");
            for (String name2 : networksTab = networks.split(",")) {
                if (name2.isEmpty()) continue;
                LOG.info("Adding network connector " + name2);
                DiscoveryNetworkConnector nc = new DiscoveryNetworkConnector(new URI("fabric:" + name2));
                nc.setName("fabric-" + name2);
                HashMap<String, String> networkProperties = new HashMap<String, String>();
                networkProperties.put("network.userName", "admin");
                networkProperties.put("network.password", properties.getProperty("zookeeper.password"));
                for (String k : properties.stringPropertyNames()) {
                    networkProperties.put(k, properties.getProperty(k));
                }
                IntrospectionSupport.setProperties((Object)nc, networkProperties, (String)"network.");
                if (broker == null) continue;
                broker.addNetworkConnector((NetworkConnector)nc);
            }
            SpringBrokerContext brokerContext = new SpringBrokerContext();
            brokerContext.setConfigurationUrl(resource.getURL().toExternalForm());
            brokerContext.setApplicationContext((ApplicationContext)ctx);
            if (broker != null) {
                broker.setBrokerContext((BrokerContext)brokerContext);
            }
            ServerInfo serverInfo = new ServerInfo(ctx, broker, resource);
            return serverInfo;
        }
        finally {
            CONFIG_PROPERTIES.remove();
        }
    }

    public synchronized boolean can_own_pool(ClusteredConfiguration cc) {
        return cc.pool == null || !this.ownedPools.contains(cc.pool);
    }

    public synchronized boolean take_pool(ClusteredConfiguration cc) {
        if (cc.pool == null) {
            return true;
        }
        if (this.ownedPools.contains(cc.pool)) {
            return false;
        }
        this.ownedPools.add(cc.pool);
        this.fire_pool_change(cc);
        return true;
    }

    public synchronized void return_pool(ClusteredConfiguration cc) {
        if (cc.pool != null) {
            this.ownedPools.remove(cc.pool);
            this.fire_pool_change(cc);
        }
    }

    private void fire_pool_change(final ClusteredConfiguration cc) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ActiveMQServiceFactory activeMQServiceFactory = ActiveMQServiceFactory.this;
                synchronized (activeMQServiceFactory) {
                    for (ClusteredConfiguration c : ActiveMQServiceFactory.this.configurations.values()) {
                        if (c == cc || c == null || c.pool == null || !c.pool.equals(cc.pool)) continue;
                        c.update_pool_state();
                    }
                }
            }
        }.start();
    }

    public String getName() {
        return "ActiveMQ Server Controller";
    }

    public synchronized void updated(String pid, Dictionary<String, ?> properties) throws ConfigurationException {
        try {
            this.deleted(pid);
            this.configurations.put(pid, new ClusteredConfiguration(ActiveMQServiceFactory.toProperties(properties)));
        }
        catch (Exception e) {
            ConfigurationException configurationException = new ConfigurationException(null, "Unable to parse ActiveMQ configuration: " + e.getMessage());
            configurationException.initCause((Throwable)e);
            throw configurationException;
        }
    }

    public synchronized void deleted(String pid) {
        ClusteredConfiguration cc = this.configurations.remove(pid);
        if (cc != null) {
            try {
                cc.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public CuratorFramework addingService(ServiceReference<CuratorFramework> reference) {
        CuratorFramework curator = (CuratorFramework)this.bundleContext.getService(reference);
        this.boundCuratorRefs.add(reference);
        Collections.sort(this.boundCuratorRefs);
        ServiceReference<CuratorFramework> bind = this.boundCuratorRefs.get(0);
        try {
            if (bind == reference) {
                this.bindCurator(curator);
            } else {
                this.bindCurator((CuratorFramework)this.curatorService.getService(bind));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return curator;
    }

    public void modifiedService(ServiceReference<CuratorFramework> reference, CuratorFramework service) {
    }

    public void removedService(ServiceReference<CuratorFramework> reference, CuratorFramework service) {
        this.boundCuratorRefs.remove(reference);
        try {
            if (this.boundCuratorRefs.isEmpty()) {
                this.bindCurator(null);
            } else {
                this.bindCurator((CuratorFramework)this.curatorService.getService(this.boundCuratorRefs.get(0)));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindCurator(CuratorFramework curator) throws Exception {
        this.curator = curator;
        ActiveMQServiceFactory activeMQServiceFactory = this;
        synchronized (activeMQServiceFactory) {
            for (ClusteredConfiguration c : this.configurations.values()) {
                c.updateCurator(curator);
            }
        }
    }

    public synchronized void destroy() throws InterruptedException {
        this.config_thread.running = false;
        this.config_thread.interrupt();
        this.config_thread.join();
        for (String pid : this.configurations.keySet()) {
            this.deleted(pid);
        }
        this.fabricService.close();
        this.curatorService.close();
        this.urlHandlerService.close();
    }

    static {
        PropertyEditorManager.registerEditor(URI.class, URIEditor.class);
    }

    private class ConfigThread
    extends Thread {
        private boolean running = true;

        private ConfigThread() {
        }

        @Override
        public void run() {
            while (this.running) {
                for (ClusteredConfiguration c : ActiveMQServiceFactory.this.configurations.values()) {
                    try {
                        long lm;
                        if (!c.configCheck || c.lastModified == -1L || c.server == null || (lm = c.server.getResource().lastModified()) == c.lastModified) continue;
                        c.lastModified = lm;
                        ActiveMQServiceFactory.info("updating " + c.properties);
                        ActiveMQServiceFactory.this.updated((String)c.properties.get("service.pid"), ActiveMQServiceFactory.toDictionary(c.properties));
                    }
                    catch (Throwable throwable) {}
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class ClusteredConfiguration {
        private Properties properties;
        private String name;
        private String data;
        private String config;
        private String group;
        private String pool;
        private String[] connectors;
        private boolean replicating;
        private boolean standalone;
        private boolean registerService;
        private boolean configCheck;
        private boolean pool_enabled = false;
        private long lastModified = -1L;
        private volatile ServerInfo server;
        private FabricDiscoveryAgent discoveryAgent = null;
        private final AtomicBoolean started = new AtomicBoolean();
        private ExecutorService executor = Executors.newSingleThreadExecutor();
        private Future<?> start_future = null;
        private Future<?> stop_future = null;
        private ServiceRegistration<ConnectionFactory> cfServiceRegistration = null;

        ClusteredConfiguration(Properties properties) throws Exception {
            this.properties = properties;
            this.name = properties.getProperty("broker-name");
            if (this.name == null) {
                this.name = System.getProperty("runtime.id");
            }
            this.data = properties.getProperty("data");
            if (this.data == null) {
                this.data = "data" + System.getProperty("file.separator") + this.name;
            }
            this.config = properties.getProperty("config");
            if (this.config == null) {
                ActiveMQServiceFactory.arg_error("config property must be set");
            }
            this.group = properties.getProperty("group");
            if (this.group == null) {
                this.group = "default";
            }
            this.pool = properties.getProperty("standby.pool");
            if (this.pool == null) {
                this.pool = "default";
            }
            String connectorsProperty = properties.getProperty("connectors", "");
            this.connectors = connectorsProperty.split("\\s");
            this.replicating = "true".equalsIgnoreCase(properties.getProperty("replicating"));
            this.standalone = "true".equalsIgnoreCase(properties.getProperty("standalone"));
            this.registerService = "true".equalsIgnoreCase(properties.getProperty("registerService"));
            this.configCheck = "true".equalsIgnoreCase(properties.getProperty("config.check"));
            this.ensure_broker_name_is_set();
            if (this.standalone) {
                if (this.started.compareAndSet(false, true)) {
                    ActiveMQServiceFactory.info("Standalone broker %s is starting.", this.name);
                    this.start();
                }
            } else {
                ActiveMQServiceFactory.this.urlHandlerService.waitForService(60000L);
                this.updateCurator(ActiveMQServiceFactory.this.curator);
            }
        }

        private void ensure_broker_name_is_set() {
            if (!this.properties.containsKey("broker-name")) {
                this.properties.setProperty("broker-name", this.name);
            }
            if (!this.properties.containsKey("data")) {
                this.properties.setProperty("data", this.data);
            }
        }

        public synchronized void update_pool_state() {
            boolean value = ActiveMQServiceFactory.this.can_own_pool(this);
            if (this.pool_enabled != value) {
                try {
                    this.pool_enabled = value;
                    if (value) {
                        if (this.pool != null) {
                            ActiveMQServiceFactory.info("Broker %s added to pool %s.", this.name, this.pool);
                        }
                        this.discoveryAgent.start();
                    } else {
                        if (this.pool != null) {
                            ActiveMQServiceFactory.info("Broker %s removed from pool %s.", this.name, this.pool);
                        }
                        this.discoveryAgent.stop();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        }

        public void osgiRegister(BrokerService broker) {
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://" + broker.getBrokerName() + "?create=false");
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put("name", broker.getBrokerName());
            this.cfServiceRegistration = ActiveMQServiceFactory.this.bundleContext.registerService(ConnectionFactory.class, (Object)connectionFactory, properties);
            ActiveMQServiceFactory.debug("registerService of type " + ConnectionFactory.class.getName() + " as: " + connectionFactory + " with name: " + broker.getBrokerName() + "; " + this.cfServiceRegistration);
        }

        public void osgiUnregister(BrokerService broker) {
            if (this.cfServiceRegistration != null) {
                this.cfServiceRegistration.unregister();
            }
            ActiveMQServiceFactory.debug("unregister connection factory for: " + broker.getBrokerName() + "; " + this.cfServiceRegistration);
        }

        private void start() {
            if (this.start_future == null || this.start_future.isDone()) {
                ActiveMQServiceFactory.info("Broker %s is being started.", this.name);
                this.start_future = this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        boolean started = false;
                        while (!started) {
                            try {
                                ClusteredConfiguration.this.doStart();
                                if (ClusteredConfiguration.this.server != null && ClusteredConfiguration.this.server.getResource() != null) {
                                    ClusteredConfiguration.this.lastModified = ClusteredConfiguration.this.server.getResource().lastModified();
                                }
                                started = true;
                            }
                            catch (Throwable e) {
                                if (ClusteredConfiguration.this.start_future.isCancelled() || Thread.currentThread().isInterrupted()) {
                                    ActiveMQServiceFactory.info("Broker %s interrupted while starting", ClusteredConfiguration.this.name);
                                    break;
                                }
                                ActiveMQServiceFactory.info("Broker %s failed to start.  Will try again in 10 seconds", ClusteredConfiguration.this.name);
                                LOG.error("Exception on start: " + e.getMessage(), e);
                                try {
                                    Thread.sleep(10000L);
                                }
                                catch (InterruptedException ignore) {
                                    ActiveMQServiceFactory.info("Broker %s interrupted while starting", ClusteredConfiguration.this.name);
                                    break;
                                }
                            }
                        }
                    }
                });
            }
        }

        private void doStart() throws Exception {
            FabricService fs = (FabricService)ActiveMQServiceFactory.this.fabricService.getService();
            if (fs != null) {
                Container container = fs.getCurrentContainer();
                if (!this.properties.containsKey("container.id")) {
                    this.properties.setProperty("container.id", container.getId());
                }
                if (!this.properties.containsKey("container.ip")) {
                    this.properties.setProperty("container.ip", container.getIp());
                }
                if (!this.properties.containsKey("zookeeper.url")) {
                    this.properties.setProperty("zookeeper.url", fs.getZookeeperUrl());
                }
                if (!this.properties.containsKey("zookeeper.password")) {
                    this.properties.setProperty("zookeeper.password", fs.getZookeeperPassword());
                }
            }
            ActiveMQServiceFactory.info("booting up a broker from: " + this.config);
            this.server = ActiveMQServiceFactory.this.createBroker(this.config, this.properties);
            for (TransportConnector t : this.server.getBroker().getTransportConnectors()) {
                String portKey = t.getName() + "-port";
                if (!this.properties.containsKey(portKey)) continue;
                URI template = t.getUri();
                t.setUri(new URI(template.getScheme(), template.getUserInfo(), template.getHost(), Integer.valueOf("" + this.properties.get(portKey)), template.getPath(), template.getQuery(), template.getFragment()));
            }
            this.server.getBroker().start();
            ActiveMQServiceFactory.info("Broker %s has started.", this.name);
            this.server.getBroker().waitUntilStarted();
            this.server.getBroker().addShutdownHook(new Runnable(){

                @Override
                public void run() {
                    if (ClusteredConfiguration.this.started.get() && ClusteredConfiguration.this.server != null) {
                        if (ClusteredConfiguration.this.server.getBroker().isRestartAllowed() && ClusteredConfiguration.this.server.getBroker().isRestartRequested()) {
                            ActiveMQServiceFactory.info("Restarting broker '%s' after shutdown on restart request", ClusteredConfiguration.this.name);
                            ClusteredConfiguration.this.discoveryAgent.setServices(new String[0]);
                            ClusteredConfiguration.this.start();
                        } else {
                            ActiveMQServiceFactory.info("Broker '%s' shut down, giving up being master", ClusteredConfiguration.this.name);
                            try {
                                ClusteredConfiguration.this.updateCurator(ActiveMQServiceFactory.this.curator);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e.getMessage(), e);
                            }
                        }
                    }
                }
            });
            if (this.replicating) {
                this.discoveryAgent.start();
            }
            LinkedList<String> services = new LinkedList<String>();
            if (!this.standalone || this.replicating) {
                for (String name : this.connectors) {
                    TransportConnector connector = this.server.getBroker().getConnectorByName(name);
                    if (connector == null) {
                        ActiveMQServiceFactory.warn("ActiveMQ broker '%s' does not have a connector called '%s'", name, name);
                        continue;
                    }
                    services.add(connector.getConnectUri().getScheme() + "://${zk:" + System.getProperty("runtime.id") + "/ip}:" + connector.getPublishableConnectURI().getPort());
                }
                this.discoveryAgent.setServices(services.toArray(new String[services.size()]));
            }
            if (this.registerService) {
                this.osgiRegister(this.server.getBroker());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws Exception {
            ClusteredConfiguration clusteredConfiguration = this;
            synchronized (clusteredConfiguration) {
                if (this.pool_enabled) {
                    ActiveMQServiceFactory.this.return_pool(this);
                }
                if (this.discoveryAgent != null) {
                    this.discoveryAgent.stop();
                }
                if (this.started.get()) {
                    this.stop();
                }
            }
            if (this.started.compareAndSet(true, false)) {
                this.waitForStop();
            }
            this.executor.shutdownNow();
        }

        public synchronized void stop() {
            this.interruptAndWaitForStart();
            if (this.stop_future == null || this.stop_future.isDone()) {
                this.stop_future = this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        ClusteredConfiguration.this.doStop();
                    }
                });
            }
        }

        private void doStop() {
            ServerInfo s = this.server;
            if (s != null) {
                try {
                    s.getBroker().stop();
                    s.getBroker().waitUntilStopped();
                    if (!this.standalone || this.replicating) {
                        this.discoveryAgent.setServices(new String[0]);
                    }
                    if (this.registerService) {
                        this.osgiUnregister(s.getBroker());
                    }
                }
                catch (Throwable e) {
                    LOG.debug("Exception on stop: " + e.getMessage(), e);
                }
                try {
                    s.getContext().close();
                }
                catch (Throwable e) {
                    LOG.debug("Exception on close: " + e.getMessage(), e);
                }
                this.server = null;
            }
        }

        private void waitForStop() throws ExecutionException, InterruptedException {
            if (this.stop_future != null && !this.stop_future.isDone()) {
                this.stop_future.get();
            }
        }

        private void interruptAndWaitForStart() {
            if (this.start_future != null && !this.start_future.isDone()) {
                this.start_future.cancel(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateCurator(CuratorFramework curator) throws Exception {
            if (!this.standalone) {
                ClusteredConfiguration clusteredConfiguration = this;
                synchronized (clusteredConfiguration) {
                    if (this.discoveryAgent != null) {
                        this.discoveryAgent.stop();
                        this.discoveryAgent = null;
                        if (this.started.compareAndSet(true, false)) {
                            ActiveMQServiceFactory.info("Lost zookeeper service for broker %s, stopping the broker.", this.name);
                            this.stop();
                            this.waitForStop();
                            ActiveMQServiceFactory.this.return_pool(this);
                            this.pool_enabled = false;
                        }
                    }
                    this.waitForStop();
                    if (curator != null) {
                        ActiveMQServiceFactory.info("Found zookeeper service for broker %s.", this.name);
                        this.discoveryAgent = new FabricDiscoveryAgent();
                        this.discoveryAgent.setAgent(System.getProperty("runtime.id"));
                        this.discoveryAgent.setId(this.name);
                        this.discoveryAgent.setGroupName(this.group);
                        this.discoveryAgent.setCurator(curator);
                        if (this.replicating) {
                            if (this.started.compareAndSet(false, true)) {
                                ActiveMQServiceFactory.info("Replicating broker %s is starting.", this.name);
                                this.start();
                            }
                        } else {
                            this.discoveryAgent.getGroup().add((GroupListener)new GroupListener<FabricDiscoveryAgent.ActiveMQNode>(){

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public void groupEvent(Group<FabricDiscoveryAgent.ActiveMQNode> group, GroupListener.GroupEvent event) {
                                    if (event.equals((Object)GroupListener.GroupEvent.CONNECTED) || event.equals((Object)GroupListener.GroupEvent.CHANGED)) {
                                        try {
                                            if (ClusteredConfiguration.this.discoveryAgent.getGroup().isMaster(ClusteredConfiguration.this.name)) {
                                                if (!ClusteredConfiguration.this.started.compareAndSet(false, true)) return;
                                                if (ActiveMQServiceFactory.this.take_pool(ClusteredConfiguration.this)) {
                                                    ActiveMQServiceFactory.info("Broker %s is now the master, starting the broker.", ClusteredConfiguration.this.name);
                                                    ClusteredConfiguration.this.start();
                                                    return;
                                                }
                                                ClusteredConfiguration.this.update_pool_state();
                                                ClusteredConfiguration.this.started.set(false);
                                                return;
                                            }
                                            if (ClusteredConfiguration.this.started.compareAndSet(true, false)) {
                                                ActiveMQServiceFactory.this.return_pool(ClusteredConfiguration.this);
                                                ActiveMQServiceFactory.info("Broker %s is now a slave, stopping the broker.", ClusteredConfiguration.this.name);
                                                ClusteredConfiguration.this.stop();
                                                return;
                                            }
                                            if (!event.equals((Object)GroupListener.GroupEvent.CHANGED)) return;
                                            ActiveMQServiceFactory.info("Broker %s is slave", ClusteredConfiguration.this.name);
                                            ClusteredConfiguration.this.discoveryAgent.setServices(new String[0]);
                                            return;
                                        }
                                        catch (Exception e) {
                                            throw new RuntimeException(e.getMessage(), e);
                                        }
                                    } else {
                                        if (!event.equals((Object)GroupListener.GroupEvent.DISCONNECTED)) return;
                                        ActiveMQServiceFactory.info("Disconnected from the group", ClusteredConfiguration.this.name);
                                        ClusteredConfiguration.this.discoveryAgent.setServices(new String[0]);
                                        ClusteredConfiguration.this.pool_enabled = false;
                                    }
                                }
                            });
                            ActiveMQServiceFactory.info("Broker %s is waiting to become the master", this.name);
                            this.update_pool_state();
                        }
                    }
                }
            }
        }
    }

    private static class ServerInfo {
        private ResourceXmlApplicationContext context;
        private BrokerService broker;
        private Resource resource;

        public ServerInfo(ResourceXmlApplicationContext context, BrokerService broker, Resource resource) {
            this.context = context;
            this.broker = broker;
            this.resource = resource;
        }

        public ResourceXmlApplicationContext getContext() {
            return this.context;
        }

        public BrokerService getBroker() {
            return this.broker;
        }

        public Resource getResource() {
            return this.resource;
        }
    }
}

