/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.utils;

import io.fabric8.common.util.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public final class FabricValidations {
    private static final Pattern ALLOWED_CONTAINER_NAMES_PATTERN = Pattern.compile("^[a-zA-Z0-9]+[\\.a-zA-Z0-9_-]*$");
    private static final Pattern ALLOWED_PROFILE_NAMES_PATTERN = Pattern.compile("^[a-zA-Z0-9]+[\\.a-zA-Z0-9_-]*$");

    private FabricValidations() {
    }

    public static void validateProfileNames(Collection<String> profileNames) {
        if (profileNames != null && !profileNames.isEmpty()) {
            for (String profileName : profileNames) {
                FabricValidations.validateProfileName(profileName);
            }
        }
    }

    public static void validateProfileName(String profileName) {
        if (!FabricValidations.isValidProfileName(profileName)) {
            throw new IllegalArgumentException("Profile name '" + profileName + "' is invalid. Profile name must be: letters, numbers, and . _ or - characters");
        }
    }

    public static void validateContainerNames(List<String> containerNames) {
        if (containerNames != null && !containerNames.isEmpty()) {
            for (String containerName : containerNames) {
                FabricValidations.validateContainerName(containerName);
            }
        }
    }

    public static void validateContainerName(String containerName) {
        if (!FabricValidations.isValidContainerName(containerName)) {
            throw new IllegalArgumentException("Container name '" + containerName + "' is invalid. Container name must be: letters, numbers, and _ or - characters");
        }
    }

    @Deprecated
    public static boolean isValidName(String containerName) {
        return FabricValidations.isValidContainerName(containerName);
    }

    public static boolean isValidContainerName(String containerName) {
        return containerName != null && !containerName.isEmpty() && ALLOWED_CONTAINER_NAMES_PATTERN.matcher(containerName).matches();
    }

    public static boolean isValidProfileName(String name) {
        return name != null && !name.isEmpty() && ALLOWED_PROFILE_NAMES_PATTERN.matcher(name).matches();
    }

    public static boolean isURIValid(String uriString) {
        String authority;
        URI uri = null;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            return false;
        }
        if (Strings.isEmpty((String)uri.getHost())) {
            return false;
        }
        String userInfo = uri.getUserInfo();
        String hostPort = authority = uri.getAuthority();
        if (userInfo != null && hostPort.contains("@")) {
            hostPort = hostPort.substring(hostPort.lastIndexOf("@"));
        }
        return uri.getPort() != -1 || hostPort.equals(uri.getHost());
    }
}

