/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mq.fabric;

import io.fabric8.api.scr.ValidatingReference;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Reference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="io.fabric8.mq.fabric.server", label="Fabric8 ActiveMQ Deployment", configurationFactory=true, policy=ConfigurationPolicy.REQUIRE)
public class BrokerDeployment {
    public static final String LOAD_TS = Long.toHexString(System.currentTimeMillis());
    public static final Logger LOG = LoggerFactory.getLogger(BrokerDeployment.class);
    @Reference(referenceInterface=ConfigurationAdmin.class)
    private final ValidatingReference<ConfigurationAdmin> configurationAdmin = new ValidatingReference();
    Configuration config;

    @Activate
    void activate(Map<String, ?> configuration) throws Exception {
        boolean standalone = "true".equalsIgnoreCase((String)configuration.get("standalone"));
        String factoryPid = standalone ? "io.fabric8.mq.fabric.standalone.server" : "io.fabric8.mq.fabric.clustered.server";
        this.config = ((ConfigurationAdmin)this.configurationAdmin.get()).createFactoryConfiguration(factoryPid, null);
        this.config.update(this.toDictionary(configuration));
    }

    private Dictionary<String, ?> toDictionary(Map<String, ?> configuration) {
        Hashtable properties = new Hashtable(configuration);
        properties.remove("component.id");
        properties.remove("component.name");
        properties.remove("service.factoryPid");
        properties.remove("fabric.zookeeper.pid");
        String pid = (String)properties.remove("service.pid");
        properties.put("mq.fabric.server.pid", pid);
        properties.put("mq.fabric.server.ts", LOAD_TS);
        return properties;
    }

    @Modified
    void modified(Map<String, ?> configuration) throws Exception {
        if (this.config != null) {
            try {
                this.config.update(this.toDictionary(configuration));
            }
            catch (IllegalStateException e) {
                this.activate(configuration);
            }
        }
    }

    @Deactivate
    void deactivate() throws IOException {
        if (this.config != null) {
            try {
                this.config.delete();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    void bindConfigurationAdmin(ConfigurationAdmin service) {
        this.configurationAdmin.bind((Object)service);
    }

    void unbindConfigurationAdmin(ConfigurationAdmin service) {
        this.configurationAdmin.unbind((Object)service);
    }
}

