/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mq.fabric;

import io.fabric8.api.FabricService;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.mq.fabric.BrokerDeploymentManager;
import io.fabric8.mq.fabric.StandaloneBrokerDeploymentManager;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.url.URLStreamHandlerService;

@Component(name="io.fabric8.mq.fabric.clustered-deployment-manager", label="Fabric8 ActiveMQ Clustered Deployment Manager", policy=ConfigurationPolicy.IGNORE)
@Properties(value={@Property(name="server.kind", value={"clustered"})})
@Service(value={BrokerDeploymentManager.class})
public class ClusteredBrokerDeploymentManager
extends StandaloneBrokerDeploymentManager
implements BrokerDeploymentManager {
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curatorFramework = new ValidatingReference();
    @Reference(referenceInterface=URLStreamHandlerService.class, target="(&(objectClass=org.osgi.service.url.URLStreamHandlerService)(url.handler.protocol=profile))")
    private final ValidatingReference<URLStreamHandlerService> urlStreamHandlerService = new ValidatingReference();

    @Override
    @Activate
    void activate(ComponentContext context) throws Exception {
        super.activate(context);
        this.serviceFactory.curator = (CuratorFramework)this.curatorFramework.get();
        this.serviceFactory.fabricService = (FabricService)this.fabricService.get();
    }

    @Override
    @Deactivate
    void deactivate() throws InterruptedException {
        super.deactivate();
    }

    void bindFabricService(FabricService service) {
        this.fabricService.bind((Object)service);
    }

    void unbindFabricService(FabricService service) {
        this.fabricService.unbind((Object)service);
    }

    void bindCuratorFramework(CuratorFramework service) {
        this.curatorFramework.bind((Object)service);
    }

    void unbindCuratorFramework(CuratorFramework service) {
        this.curatorFramework.unbind((Object)service);
    }

    void bindUrlStreamHandlerService(URLStreamHandlerService service) {
        this.urlStreamHandlerService.bind((Object)service);
    }

    void unbindUrlStreamHandlerService(URLStreamHandlerService service) {
        this.urlStreamHandlerService.unbind((Object)service);
    }
}

