/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mq.fabric;

import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.mq.fabric.BrokerDeployment;
import io.fabric8.mq.fabric.BrokerDeploymentManager;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Reference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="io.fabric8.mq.fabric.standalone.server", label="Fabric8 ActiveMQ Standalone Deployment", configurationFactory=true, policy=ConfigurationPolicy.REQUIRE)
public class StandaloneBrokerDeployment {
    public static final Logger LOG = LoggerFactory.getLogger(StandaloneBrokerDeployment.class);
    @Reference(referenceInterface=BrokerDeploymentManager.class, target="(&(objectClass=io.fabric8.mq.fabric.BrokerDeploymentManager)(server.kind=standalone))")
    private final ValidatingReference<BrokerDeploymentManager> brokerDeploymentManager = new ValidatingReference();
    @Reference(referenceInterface=ConfigurationAdmin.class)
    private final ValidatingReference<ConfigurationAdmin> configurationAdmin = new ValidatingReference();
    private String pid;

    @Activate
    void activate(Map<String, ?> configuration) throws Exception {
        Properties properties = StandaloneBrokerDeployment.toProperties(configuration);
        if (!BrokerDeployment.LOAD_TS.equals(properties.getProperty("mq.fabric.server.ts"))) {
            Configuration ourConfig = this.getConfigurationAdmin().getConfiguration(properties.getProperty("service.pid"));
            ourConfig.delete();
        } else {
            this.pid = properties.getProperty("service.pid");
            this.getBrokerDeploymentManager().updated(this.pid, properties);
        }
    }

    @Modified
    void modified(Map<String, ?> configuration) throws Exception {
        if (this.pid != null) {
            Properties properties = StandaloneBrokerDeployment.toProperties(configuration);
            this.getBrokerDeploymentManager().updated(this.pid, properties);
        }
    }

    @Deactivate
    void deactivate() {
        if (this.pid != null) {
            this.getBrokerDeploymentManager().deleted(this.pid);
        }
    }

    protected BrokerDeploymentManager getBrokerDeploymentManager() {
        return (BrokerDeploymentManager)this.brokerDeploymentManager.get();
    }

    protected ConfigurationAdmin getConfigurationAdmin() {
        return (ConfigurationAdmin)this.configurationAdmin.get();
    }

    void bindBrokerDeploymentManager(BrokerDeploymentManager service) {
        this.brokerDeploymentManager.bind((Object)service);
    }

    void unbindBrokerDeploymentManager(BrokerDeploymentManager service) {
        this.brokerDeploymentManager.unbind((Object)service);
    }

    private static Properties toProperties(Map<?, ?> properties) {
        Properties result = new Properties();
        for (Map.Entry<?, ?> entry : properties.entrySet()) {
            result.put(entry.getKey().toString(), entry.getValue() != null ? entry.getValue().toString() : "");
        }
        return result;
    }

    void bindConfigurationAdmin(ConfigurationAdmin service) {
        this.configurationAdmin.bind((Object)service);
    }

    void unbindConfigurationAdmin(ConfigurationAdmin service) {
        this.configurationAdmin.unbind((Object)service);
    }
}

