/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.base;

import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.StatusBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.ClientMixedOperation;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.EditReplaceDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Reaper;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.kubernetes.client.dsl.internal.WatchConnectionManager;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;

public class BaseOperation<T, L extends KubernetesResourceList, D extends Doneable<T>, R extends ClientResource<T, D>>
extends OperationSupport
implements ClientMixedOperation<T, L, D, R> {
    private final Boolean cascading;
    private final T item;
    private final Map<String, String> labels = new TreeMap<String, String>();
    private final Map<String, String> labelsNot = new TreeMap<String, String>();
    private final Map<String, String[]> labelsIn = new TreeMap<String, String[]>();
    private final Map<String, String[]> labelsNotIn = new TreeMap<String, String[]>();
    private final Map<String, String> fields = new TreeMap<String, String>();
    private final Class<T> type;
    private final Class<L> listType;
    private final Class<D> doneableType;
    private boolean reaping;
    protected Reaper reaper;

    protected BaseOperation(OkHttpClient client, Config config, String resourceT, String namespace, String name, Boolean cascading, T item) {
        super(client, config, resourceT, namespace, name);
        this.cascading = cascading;
        this.item = item;
        this.type = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        this.listType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[1];
        this.doneableType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[2];
        this.reaper = null;
    }

    protected BaseOperation(OkHttpClient client, Config config, String resourceT, String namespace, String name, Boolean cascading, T item, Class<T> type, Class<L> listType, Class<D> doneableType) {
        super(client, config, resourceT, namespace, name);
        this.cascading = cascading;
        this.item = item;
        this.type = type;
        this.listType = listType;
        this.doneableType = doneableType;
        this.reaper = null;
    }

    public T get() {
        if (this.item != null) {
            return this.item;
        }
        try {
            URL requestUrl = this.getNamespacedUrl();
            if (this.name != null) {
                requestUrl = new URL(URLUtils.join((String[])new String[]{requestUrl.toString(), this.name}));
            }
            return this.handleGet(requestUrl);
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return null;
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public RootPaths getRootPaths() {
        try {
            URL requestUrl = new URL(this.config.getMasterUrl());
            Request.Builder req = new Request.Builder().get().url(requestUrl);
            return this.handleResponse(req, 200, RootPaths.class);
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return null;
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public T getMandatory() {
        T item = this.get();
        if (item != null) {
            return item;
        }
        throw new KubernetesClientException("Resource not found!", 404, (Status)((StatusBuilder)((StatusBuilder)new StatusBuilder().withCode(Integer.valueOf(404))).withMessage("Not found.")).build());
    }

    public D edit() throws KubernetesClientException {
        throw new KubernetesClientException("Cannot edit read-only resources");
    }

    public R withName(String name) {
        try {
            return (R)((ClientResource)this.getClass().getConstructor(OkHttpClient.class, Config.class, String.class, String.class, Boolean.class, this.type).newInstance(this.client, this.config, this.namespace, name, this.cascading, this.item));
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((Throwable)t);
        }
    }

    public ClientNonNamespaceOperation<T, L, D, R> inNamespace(String namespace) {
        try {
            return (ClientNonNamespaceOperation)this.getClass().getConstructor(OkHttpClient.class, Config.class, String.class, String.class, Boolean.class, this.type).newInstance(this.client, this.config, namespace, this.name, this.cascading, this.item);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((Throwable)t);
        }
    }

    public ClientNonNamespaceOperation<T, L, D, R> inAnyNamespace() {
        return this.inNamespace(null);
    }

    public EditReplaceDeletable<T, T, D, Boolean> cascading(boolean enabled) {
        try {
            return (EditReplaceDeletable)this.getClass().getConstructor(OkHttpClient.class, Config.class, String.class, String.class, Boolean.class, this.type).newInstance(this.client, this.config, this.namespace, this.name, enabled, this.item);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((Throwable)t);
        }
    }

    public R load(InputStream is) {
        try {
            return (R)((ClientResource)this.getClass().getConstructor(OkHttpClient.class, Config.class, String.class, String.class, Boolean.class, this.type).newInstance(this.client, this.config, this.namespace, this.name, this.cascading, this.unmarshal(is, this.type)));
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((Throwable)t);
        }
    }

    public T create(T ... resources) throws KubernetesClientException {
        try {
            if (resources.length > 1) {
                throw new IllegalArgumentException("Too many items to create.");
            }
            if (resources.length == 1) {
                return this.handleCreate(resources[0]);
            }
            if (this.getItem() == null) {
                throw new IllegalArgumentException("Nothing to create.");
            }
            return this.handleCreate(this.getItem());
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public D createNew() throws KubernetesClientException {
        Visitor visitor = new Visitor<T>(){

            public void visit(T resource) {
                try {
                    BaseOperation.this.create(resource);
                }
                catch (Exception e) {
                    throw KubernetesClientException.launderThrowable((Throwable)e);
                }
            }
        };
        try {
            return (D)((Doneable)this.getDoneableType().getDeclaredConstructor(Visitor.class).newInstance(visitor));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public FilterWatchListDeletable<T, L, Boolean> withLabels(Map<String, String> labels) {
        this.labels.putAll(labels);
        return this;
    }

    public FilterWatchListDeletable<T, L, Boolean> withoutLabels(Map<String, String> labels) throws KubernetesClientException {
        this.labelsNot.putAll(labels);
        return this;
    }

    public FilterWatchListDeletable<T, L, Boolean> withLabelIn(String key, String ... values) throws KubernetesClientException {
        this.labelsIn.put(key, values);
        return this;
    }

    public FilterWatchListDeletable<T, L, Boolean> withLabelNotIn(String key, String ... values) throws KubernetesClientException {
        this.labelsNotIn.put(key, values);
        return this;
    }

    public FilterWatchListDeletable<T, L, Boolean> withLabel(String key, String value) {
        this.labels.put(key, value);
        return this;
    }

    public FilterWatchListDeletable<T, L, Boolean> withoutLabel(String key, String value) throws KubernetesClientException {
        this.labelsNot.put(key, value);
        return this;
    }

    public FilterWatchListDeletable<T, L, Boolean> withFields(Map<String, String> labels) {
        this.fields.putAll(labels);
        return this;
    }

    public FilterWatchListDeletable<T, L, Boolean> withField(String key, String value) {
        this.fields.put(key, value);
        return this;
    }

    public String getLabelQueryParam() {
        Map.Entry<String, String> entry;
        Iterator<Map.Entry<String, String>> iter;
        StringBuilder sb = new StringBuilder();
        if (this.labels != null && !this.labels.isEmpty()) {
            iter = this.labels.entrySet().iterator();
            while (iter.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                entry = iter.next();
                sb.append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        if (this.labelsNot != null && !this.labelsNot.isEmpty()) {
            iter = this.labelsNot.entrySet().iterator();
            while (iter.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                entry = iter.next();
                sb.append(entry.getKey()).append("!=").append(entry.getValue());
            }
        }
        if (this.labelsIn != null && !this.labelsIn.isEmpty()) {
            iter = this.labelsIn.entrySet().iterator();
            while (iter.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                entry = iter.next();
                sb.append(entry.getKey()).append(" in ").append("(").append(Utils.join((Object[])((Object[])entry.getValue()))).append(")");
            }
        }
        if (this.labelsNotIn != null && !this.labelsNotIn.isEmpty()) {
            iter = this.labelsNotIn.entrySet().iterator();
            while (iter.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                entry = iter.next();
                sb.append(entry.getKey()).append(" notin ").append("(").append(Utils.join((Object[])((Object[])entry.getValue()))).append(")");
            }
        }
        return sb.toString();
    }

    public String getFieldQueryParam() {
        StringBuilder sb = new StringBuilder();
        if (this.fields != null && !this.fields.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            for (Map.Entry<String, String> entry : this.fields.entrySet()) {
                sb.append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        return sb.toString();
    }

    public L list() throws KubernetesClientException {
        try {
            String fieldQueryString;
            HttpUrl.Builder requestUrlBuilder = HttpUrl.get((URL)this.getNamespacedUrl()).newBuilder();
            String labelQueryParam = this.getLabelQueryParam();
            if (labelQueryParam.length() > 0) {
                requestUrlBuilder.addQueryParameter("labelSelector", labelQueryParam);
            }
            if ((fieldQueryString = this.getFieldQueryParam()).length() > 0) {
                requestUrlBuilder.addQueryParameter("fieldSelector", fieldQueryString);
            }
            Request.Builder requestBuilder = new Request.Builder().get().url(requestUrlBuilder.build());
            return (L)((KubernetesResourceList)this.handleResponse(requestBuilder, 200, this.listType));
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public Boolean delete() {
        if (this.name != null && !this.name.isEmpty()) {
            try {
                if (this.cascading.booleanValue() && !this.isReaping() && this.reaper != null) {
                    this.setReaping(true);
                    this.reaper.reap();
                }
                this.deleteThis();
                return true;
            }
            catch (KubernetesClientException e) {
                if (e.getCode() != 404) {
                    throw e;
                }
                return false;
            }
        }
        try {
            this.deleteList();
            return true;
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return false;
        }
    }

    public Boolean delete(T ... items) {
        return this.delete((List)Arrays.asList(items));
    }

    public Boolean delete(List<T> items) {
        try {
            for (T item : items) {
                this.handleDelete(item);
            }
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return false;
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
        return true;
    }

    void deleteThis() throws KubernetesClientException {
        try {
            if (this.item != null) {
                this.handleDelete(this.item);
            } else {
                this.handleDelete(this.getResourceUrl());
            }
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    void deleteList() throws KubernetesClientException {
        this.delete(this.list().getItems());
    }

    public Watch watch(Watcher<T> watcher) throws KubernetesClientException {
        return this.watch(null, watcher);
    }

    public Watch watch(String resourceVersion, Watcher<T> watcher) throws KubernetesClientException {
        try {
            return new WatchConnectionManager(this.client, this, resourceVersion, watcher, this.config.getWatchReconnectInterval(), this.config.getWatchReconnectLimit());
        }
        catch (InterruptedException | MalformedURLException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public T update(T item) {
        return this.replace(item);
    }

    public T replace(T item) {
        throw new KubernetesClientException("Cannot update read-only resources");
    }

    @Override
    public boolean isNamespaceRequired() {
        return true;
    }

    protected T handleResponse(Request.Builder requestBuilder, int successStatusCode) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        return this.handleResponse(requestBuilder, successStatusCode, this.getType());
    }

    protected T handleCreate(T resource) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        return this.handleCreate(resource, this.getType());
    }

    protected T handleReplace(T updated) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        return this.handleReplace(updated, this.getType());
    }

    protected T handleGet(URL resourceUrl) throws InterruptedException, ExecutionException, IOException {
        return this.handleGet(resourceUrl, this.getType());
    }

    public Boolean isCascading() {
        return this.cascading;
    }

    public T getItem() {
        return this.item;
    }

    @Override
    public String getResourceT() {
        return this.resourceT;
    }

    public Class<T> getType() {
        return this.type;
    }

    public Class<L> getListType() {
        return this.listType;
    }

    public Class<D> getDoneableType() {
        return this.doneableType;
    }

    protected boolean isReaping() {
        return this.reaping;
    }

    protected void setReaping(boolean reaping) {
        this.reaping = reaping;
    }
}

