/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.mock;

import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.server.mock.Returnable;
import io.fabric8.kubernetes.server.mock.Timeable;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.OAuthClientBuilder;
import io.fabric8.openshift.api.model.OAuthClientFluent;
import io.fabric8.openshift.api.model.OAuthClientList;
import io.fabric8.openshift.api.model.OAuthClientListBuilder;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.mock.OpenShiftMockServerTestBase;
import org.junit.Assert;
import org.junit.Test;

public class OAuthClientTest
extends OpenShiftMockServerTestBase {
    @Test
    public void testList() {
        ((Timeable)((Returnable)this.expect().withPath("/oapi/v1/oauthclients")).andReturn(200, (Object)((OAuthClientListBuilder)((OAuthClientListBuilder)new OAuthClientListBuilder().addNewItem().and()).addNewItem().and()).build())).once();
        OpenShiftClient client = this.getOpenshiftClient();
        OAuthClientList oauthclientList = (OAuthClientList)client.oAuthClients().list();
        Assert.assertNotNull((Object)oauthclientList);
        Assert.assertEquals((long)2L, (long)oauthclientList.getItems().size());
    }

    @Test
    public void testGet() {
        ((Timeable)((Returnable)this.expect().withPath("/oapi/v1/oauthclients/client1")).andReturn(200, (Object)((OAuthClientBuilder)((OAuthClientFluent.MetadataNested)new OAuthClientBuilder().withNewMetadata().withName("client1")).endMetadata()).build())).once();
        ((Timeable)((Returnable)this.expect().withPath("/oapi/v1/oauthclients/client2")).andReturn(200, (Object)((OAuthClientBuilder)((OAuthClientFluent.MetadataNested)new OAuthClientBuilder().withNewMetadata().withName("client2")).endMetadata()).build())).once();
        OpenShiftClient client = this.getOpenshiftClient();
        OAuthClient oauthclient = (OAuthClient)((ClientResource)client.oAuthClients().withName("client1")).get();
        Assert.assertNotNull((Object)oauthclient);
        Assert.assertEquals((Object)"client1", (Object)oauthclient.getMetadata().getName());
        oauthclient = (OAuthClient)((ClientResource)client.oAuthClients().withName("client2")).get();
        Assert.assertNotNull((Object)oauthclient);
        Assert.assertEquals((Object)"client2", (Object)oauthclient.getMetadata().getName());
        oauthclient = (OAuthClient)((ClientResource)client.oAuthClients().withName("client3")).get();
        Assert.assertNull((Object)oauthclient);
    }

    @Test
    public void testDelete() {
        ((Timeable)((Returnable)this.expect().withPath("/oapi/v1/oauthclients/client1")).andReturn(200, (Object)new OAuthClientBuilder().build())).once();
        ((Timeable)((Returnable)this.expect().withPath("/oapi/v1/oauthclients/client2")).andReturn(200, (Object)new OAuthClientBuilder().build())).once();
        OpenShiftClient client = this.getOpenshiftClient();
        Boolean deleted = (Boolean)((ClientResource)client.oAuthClients().withName("client1")).delete();
        Assert.assertNotNull((Object)deleted);
        deleted = (Boolean)((ClientResource)client.oAuthClients().withName("client2")).delete();
        Assert.assertTrue((boolean)deleted);
        deleted = (Boolean)((ClientResource)client.oAuthClients().withName("client3")).delete();
        Assert.assertFalse((boolean)deleted);
    }
}

