/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.mock;

import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.server.mock.Returnable;
import io.fabric8.kubernetes.server.mock.Timeable;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.ProjectBuilder;
import io.fabric8.openshift.api.model.ProjectFluent;
import io.fabric8.openshift.api.model.ProjectList;
import io.fabric8.openshift.api.model.ProjectListBuilder;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.mock.OpenShiftMockServerTestBase;
import org.junit.Assert;
import org.junit.Test;

public class ProjectTest
extends OpenShiftMockServerTestBase {
    @Test
    public void testList() {
        ((Timeable)((Returnable)this.expect().withPath("/oapi/v1/projects")).andReturn(200, (Object)((ProjectListBuilder)((ProjectListBuilder)new ProjectListBuilder().addNewItem().and()).addNewItem().and()).build())).once();
        OpenShiftClient client = this.getOpenshiftClient();
        ProjectList projectList = (ProjectList)client.projects().list();
        Assert.assertNotNull((Object)projectList);
        Assert.assertEquals((long)2L, (long)projectList.getItems().size());
    }

    @Test
    public void testGet() {
        ((Timeable)((Returnable)this.expect().withPath("/oapi/v1/projects/project1")).andReturn(200, (Object)((ProjectBuilder)((ProjectFluent.MetadataNested)new ProjectBuilder().withNewMetadata().withName("project1")).endMetadata()).build())).once();
        ((Timeable)((Returnable)this.expect().withPath("/oapi/v1/projects/project2")).andReturn(200, (Object)((ProjectBuilder)((ProjectFluent.MetadataNested)new ProjectBuilder().withNewMetadata().withName("project2")).endMetadata()).build())).once();
        OpenShiftClient client = this.getOpenshiftClient();
        Project project = (Project)((ClientResource)client.projects().withName("project1")).get();
        Assert.assertNotNull((Object)project);
        Assert.assertEquals((Object)"project1", (Object)project.getMetadata().getName());
        project = (Project)((ClientResource)client.projects().withName("project2")).get();
        Assert.assertNotNull((Object)project);
        Assert.assertEquals((Object)"project2", (Object)project.getMetadata().getName());
        project = (Project)((ClientResource)client.projects().withName("project3")).get();
        Assert.assertNull((Object)project);
    }

    @Test
    public void testDelete() {
        ((Timeable)((Returnable)this.expect().withPath("/oapi/v1/projects/project1")).andReturn(200, (Object)new ProjectBuilder().build())).once();
        ((Timeable)((Returnable)this.expect().withPath("/oapi/v1/projects/project2")).andReturn(200, (Object)new ProjectBuilder().build())).once();
        OpenShiftClient client = this.getOpenshiftClient();
        Boolean deleted = (Boolean)((ClientResource)client.projects().withName("project1")).delete();
        Assert.assertNotNull((Object)deleted);
        deleted = (Boolean)((ClientResource)client.projects().withName("project2")).delete();
        Assert.assertTrue((boolean)deleted);
        deleted = (Boolean)((ClientResource)client.projects().withName("project3")).delete();
        Assert.assertFalse((boolean)deleted);
    }
}

