/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.process.fabric;

import com.google.common.collect.ImmutableMap;
import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.fusesource.process.fabric.ContainerInstallOptions;
import org.fusesource.process.fabric.ContainerProcessManagerServiceMBean;
import org.fusesource.process.fabric.ProcessManagerCallback;
import org.fusesource.process.fabric.support.ProcessManagerJmxTemplate;
import org.fusesource.process.manager.InstallTask;
import org.fusesource.process.manager.Installation;
import org.fusesource.process.manager.service.ProcessManagerServiceMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerProcessManagerService
implements ContainerProcessManagerServiceMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainerProcessManagerService.class);
    private final ObjectName objectName = new ObjectName("io.fabric8:type=FabricProcesses");
    private FabricService fabricService;
    private MBeanServer mbeanServer;

    public void bindMBeanServer(MBeanServer mbeanServer) {
        this.unbindMBeanServer(this.mbeanServer);
        this.mbeanServer = mbeanServer;
        if (mbeanServer != null) {
            this.registerMBeanServer(mbeanServer);
        }
    }

    public void unbindMBeanServer(MBeanServer mbeanServer) {
        if (mbeanServer != null) {
            this.unregisterMBeanServer(mbeanServer);
            this.mbeanServer = null;
        }
    }

    public void registerMBeanServer(MBeanServer mbeanServer) {
        try {
            if (!mbeanServer.isRegistered(this.objectName)) {
                mbeanServer.registerMBean(this, this.objectName);
            }
        }
        catch (Exception e) {
            LOGGER.warn("An error occured during mbean server registration: " + e, (Throwable)e);
        }
    }

    public void unregisterMBeanServer(MBeanServer mbeanServer) {
        if (mbeanServer != null) {
            try {
                ObjectName name = this.objectName;
                if (mbeanServer.isRegistered(name)) {
                    mbeanServer.unregisterMBean(name);
                }
            }
            catch (Exception e) {
                LOGGER.warn("An error occured during mbean server registration: " + e, (Throwable)e);
            }
        }
    }

    private ProcessManagerJmxTemplate getJmxTemplate(Container container, String jmxUser, String jmxPassword) {
        return new ProcessManagerJmxTemplate(container, jmxUser, jmxPassword, true);
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    public void setFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    @Override
    public List<Installation> listInstallations(ContainerInstallOptions options) {
        Container container = this.fabricService.getContainer(options.getContainer());
        ProcessManagerJmxTemplate jmxTemplate = this.getJmxTemplate(container, options.getUser(), options.getPassword());
        return jmxTemplate.execute(new ProcessManagerCallback<List<Installation>>(){

            @Override
            public List<Installation> doWithProcessManager(ProcessManagerServiceMBean processManagerService) throws Exception {
                return processManagerService.listInstallations();
            }
        });
    }

    @Override
    public Installation install(final ContainerInstallOptions options, final InstallTask postInstall) throws Exception {
        Container container = this.fabricService.getContainer(options.getContainer());
        ProcessManagerJmxTemplate jmxTemplate = this.getJmxTemplate(container, options.getUser(), options.getPassword());
        return jmxTemplate.execute(new ProcessManagerCallback<Installation>(){

            @Override
            public Installation doWithProcessManager(ProcessManagerServiceMBean processManagerService) throws Exception {
                return processManagerService.install(options.asInstallOptions(), postInstall);
            }
        });
    }

    @Override
    public Installation installJar(final ContainerInstallOptions options) throws Exception {
        Container container = this.fabricService.getContainer(options.getContainer());
        ProcessManagerJmxTemplate jmxTemplate = this.getJmxTemplate(container, options.getUser(), options.getPassword());
        return jmxTemplate.execute(new ProcessManagerCallback<Installation>(){

            @Override
            public Installation doWithProcessManager(ProcessManagerServiceMBean processManagerService) throws Exception {
                return processManagerService.installJar(options.asInstallOptions());
            }
        });
    }

    @Override
    public ImmutableMap<Integer, Installation> listInstallationMap(ContainerInstallOptions options) {
        Container container = this.fabricService.getContainer(options.getContainer());
        ProcessManagerJmxTemplate jmxTemplate = this.getJmxTemplate(container, options.getUser(), options.getPassword());
        return jmxTemplate.execute(new ProcessManagerCallback<ImmutableMap<Integer, Installation>>(){

            @Override
            public ImmutableMap<Integer, Installation> doWithProcessManager(ProcessManagerServiceMBean processManagerService) throws Exception {
                return processManagerService.listInstallationMap();
            }
        });
    }
}

