/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.process.fabric.child;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fusesource.process.fabric.child.DeploymentInfo;
import org.fusesource.process.manager.InstallOptions;

public class ProcessRequirements {
    private String id;
    private String kind;
    private String url;
    private String layout;
    private String extractCmd;
    private List<DeploymentInfo> deployments = new ArrayList<DeploymentInfo>();
    private List<String> profiles = new ArrayList<String>();
    private Map<String, Object> properties = new HashMap<String, Object>();

    public ProcessRequirements(String id) {
        this.id = id;
    }

    public String toString() {
        return "Process(" + this.id + " " + this.kind + " " + this.url + " profiles: " + this.profiles + ")";
    }

    public List<DeploymentInfo> getDeployments() {
        return this.deployments;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getExtractCmd() {
        return this.extractCmd;
    }

    public void setExtractCmd(String extractCmd) {
        this.extractCmd = extractCmd;
    }

    public void addProfile(String profile) {
        this.profiles.add(profile);
    }

    public List<String> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(List<String> profiles) {
        this.profiles = profiles;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public InstallOptions createInstallOptions() throws MalformedURLException {
        InstallOptions.InstallOptionsBuilder builder = InstallOptions.builder().properties(this.properties).name(this.id);
        if (this.url != null) {
            builder = builder.url(this.url);
        }
        if (this.kind != null) {
            if (this.kind.indexOf(58) < 0) {
                this.kind = "profile:" + this.kind + ".json";
            }
            builder = builder.controllerUrl(this.kind);
        }
        builder.extractCmd(this.extractCmd);
        return builder.build();
    }
}

