/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.process.fabric.commands;

import com.google.common.collect.ImmutableMap;
import org.apache.felix.gogo.commands.Argument;
import org.fusesource.process.fabric.ContainerInstallOptions;
import org.fusesource.process.fabric.commands.ContainerProcessCommandSupport;
import org.fusesource.process.manager.Installation;

public abstract class ContainerProcessControllerSupport
extends ContainerProcessCommandSupport {
    @Argument(index=1, required=true, multiValued=true, name="id", description="The id of the managed processes to control")
    protected int[] ids;

    protected abstract void doControlCommand(Installation var1) throws Exception;

    @Override
    void doWithAuthentication(String jmxUser, String jmxPassword) throws Exception {
        ContainerInstallOptions options = ContainerInstallOptions.builder().container(this.container).user(jmxUser).password(jmxPassword).build();
        ImmutableMap<Integer, Installation> map = this.getContainerProcessManager().listInstallationMap(options);
        for (int id : this.ids) {
            Installation installation = (Installation)map.get(id);
            if (installation == null) {
                System.out.println("No such process number: " + id);
                continue;
            }
            this.doControlCommand(installation);
        }
    }
}

