/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.boot.commands.support;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.Version;
import io.fabric8.api.scr.AbstractComponent;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.ArgumentCompleter;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.apache.karaf.shell.console.jline.CommandSessionHolder;

public abstract class AbstractProfileCompleter
extends AbstractComponent
implements Completer {
    private final int containerArgumentIndex;
    private final boolean assigned;
    private final boolean unassigned;

    protected AbstractProfileCompleter(int containerArgumentIndex, boolean assigned, boolean unassigned) {
        this.containerArgumentIndex = containerArgumentIndex;
        this.assigned = assigned;
        this.unassigned = unassigned;
    }

    public int complete(String buffer, int cursor, List<String> candidates) {
        StringsCompleter delegate = new StringsCompleter();
        try {
            Version version = this.getFabricService().getDefaultVersion();
            Container container = this.getFabricService().getCurrentContainer();
            try {
                container = this.getFabricService().getContainer(this.getContainer(CommandSessionHolder.getSession(), this.containerArgumentIndex));
            }
            catch (Exception ex) {
                // empty catch block
            }
            Profile[] containerProfiles = container.getProfiles();
            LinkedList<String> containerProfileNames = new LinkedList<String>();
            if (containerProfiles != null) {
                for (Profile p : containerProfiles) {
                    containerProfileNames.add(p.getId());
                }
            }
            Profile[] profiles = version.getProfiles();
            LinkedList<String> allProfileNames = new LinkedList<String>();
            if (containerProfiles != null) {
                for (Profile p : profiles) {
                    allProfileNames.add(p.getId());
                }
            }
            if (this.assigned && this.unassigned) {
                delegate.getStrings().addAll(allProfileNames);
            } else if (this.assigned) {
                delegate.getStrings().addAll(containerProfileNames);
            } else if (this.unassigned) {
                allProfileNames.removeAll(containerProfileNames);
                delegate.getStrings().addAll(allProfileNames);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return delegate.complete(buffer, cursor, candidates);
    }

    private String getContainer(CommandSession commandSession, int index) {
        List<String> arguments;
        String containerName = this.getRuntimeProperties().getProperty("karaf.name");
        ArgumentCompleter.ArgumentList list = (ArgumentCompleter.ArgumentList)commandSession.get("ARGUMENTS_LIST");
        if (list != null && list.getArguments() != null && list.getArguments().length > 0 && (arguments = Arrays.asList(list.getArguments())).size() > index) {
            containerName = arguments.get(index);
        }
        return containerName;
    }

    protected abstract FabricService getFabricService();

    protected abstract RuntimeProperties getRuntimeProperties();
}

