/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.boot.commands.support;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import io.fabric8.internal.ProfileImpl;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.osgi.service.cm.ConfigurationAdmin;

public abstract class FabricCommand
extends OsgiCommandSupport {
    private CuratorFramework curator;
    protected FabricService fabricService;
    protected ConfigurationAdmin configurationAdmin;

    public FabricService getFabricService() {
        return this.fabricService;
    }

    public void setFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public CuratorFramework getCurator() {
        return this.curator;
    }

    public void setCurator(CuratorFramework curator) {
        this.curator = curator;
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    protected void checkFabricAvailable() throws Exception {
    }

    public static String toString(Profile[] profiles) {
        if (profiles == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < profiles.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(profiles[i].getId());
        }
        return sb.toString();
    }

    public static String toString(Iterable<String> profiles) {
        if (profiles == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String profile : profiles) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(profile);
            first = false;
        }
        return sb.toString();
    }

    public static Profile[] getProfiles(FabricService fabricService, String version, List<String> names) {
        return FabricCommand.getProfiles(fabricService, fabricService.getVersion(version), names);
    }

    public static Profile[] getProfiles(FabricService fabricService, Version version, List<String> names) {
        Profile[] allProfiles = version.getProfiles();
        ArrayList<ProfileImpl> profiles = new ArrayList<ProfileImpl>();
        if (names == null) {
            return new Profile[0];
        }
        for (String name : names) {
            ProfileImpl profile = null;
            for (Profile p : allProfiles) {
                if (!name.equals(p.getId())) continue;
                profile = p;
                break;
            }
            if (profile == null) {
                profile = new ProfileImpl(name, version.getId(), fabricService);
            }
            profiles.add(profile);
        }
        return profiles.toArray(new Profile[profiles.size()]);
    }

    public static Profile getProfile(Version ver, String name) {
        Profile p = ver.getProfile(name);
        if (p == null) {
            throw new IllegalArgumentException("Profile " + name + " does not exist.");
        }
        return p;
    }

    public static boolean isPartOfEnsemble(FabricService fabricService, String containerName) {
        boolean result = false;
        CuratorFramework curator = (CuratorFramework)fabricService.adapt(CuratorFramework.class);
        try {
            ArrayList containerList = new ArrayList();
            String clusterId = ZooKeeperUtils.getStringData((CuratorFramework)curator, (String)ZkPath.CONFIG_ENSEMBLES.getPath(new String[0]));
            String containers = ZooKeeperUtils.getStringData((CuratorFramework)curator, (String)ZkPath.CONFIG_ENSEMBLE.getPath(new String[]{clusterId}));
            Collections.addAll(containerList, containers.split(","));
            result = containerList.contains(containerName);
        }
        catch (Throwable t) {
            // empty catch block
        }
        return result;
    }

    public static Container getContainer(FabricService fabricService, String name) {
        Container[] containers;
        for (Container container : containers = fabricService.getContainers()) {
            if (!container.getId().equals(name)) continue;
            return container;
        }
        throw new IllegalArgumentException("Container " + name + " does not exist.");
    }

    public static boolean doesContainerExist(FabricService fabricService, String name) {
        Container[] containers;
        for (Container container : containers = fabricService.getContainers()) {
            if (!container.getId().equals(name)) continue;
            return true;
        }
        return false;
    }

    protected String percentText(double value) {
        return NumberFormat.getPercentInstance().format(value);
    }
}

