/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.download;

import io.fabric8.agent.download.DefaultFuture;
import io.fabric8.agent.download.DownloadFuture;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDownloadTask
extends DefaultFuture<DownloadFuture>
implements DownloadFuture,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDownloadTask.class);
    protected final String url;
    protected final ExecutorService executor;
    private long scheduleDelay = 250L;
    private int scheduleNbRun = 0;

    public AbstractDownloadTask(String url, ExecutorService executor) {
        super(null);
        this.url = url;
        this.executor = executor;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public File getFile() throws IOException {
        Object v = this.getValue();
        if (v instanceof File) {
            return (File)v;
        }
        if (v instanceof IOException) {
            throw (IOException)v;
        }
        return null;
    }

    public void setFile(File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        this.setValue(file);
    }

    public void setException(IOException exception) {
        if (exception == null) {
            throw new NullPointerException("exception");
        }
        this.setValue(exception);
    }

    @Override
    public final void run() {
        boolean done = false;
        try {
            while (!done) {
                try {
                    File file = this.download();
                    this.setFile(file);
                    done = true;
                    return;
                }
                catch (IOException e) {
                    if (++this.scheduleNbRun < 5) {
                        long delay = (long)((double)(this.scheduleDelay * 3L / 2L) + Math.random() * (double)this.scheduleDelay / 2.0);
                        LOGGER.debug("Error downloading " + this.url + ": " + e.getMessage() + ". Retrying in approx " + delay + " ms.");
                        Thread.sleep(delay);
                        this.scheduleDelay *= 2L;
                        continue;
                    }
                    this.setException(AbstractDownloadTask.initIOException("Error downloading " + this.url, e));
                    done = true;
                }
            }
        }
        catch (Throwable e) {
            this.setException(AbstractDownloadTask.initIOException("Error downloading " + this.url, e));
        }
    }

    protected abstract File download() throws Exception;

    static IOException initIOException(String message, Throwable cause) {
        IOException exception = new IOException(message);
        exception.initCause(cause);
        return exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            int len;
            byte[] buffer = new byte[8192];
            while ((len = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, len);
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {}
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

