/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.utils;

import io.fabric8.agent.download.DownloadFuture;
import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.download.FutureListener;
import io.fabric8.agent.mvn.Parser;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.common.util.MultiException;
import io.fabric8.common.util.Strings;
import io.fabric8.service.VersionPropertyPointerResolver;
import io.fabric8.utils.PatchUtils;
import io.fabric8.utils.features.FeatureUtils;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.internal.FeatureValidationUtil;
import org.apache.karaf.features.internal.RepositoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentUtils.class);
    public static final String FAB_PROTOCOL = "fab:";
    public static final String REQ_PROTOCOL = "req:";

    public static Map<String, Parser> getProfileArtifacts(FabricService fabricService, DownloadManager downloadManager, Profile profile) throws Exception {
        return AgentUtils.getProfileArtifacts(fabricService, downloadManager, profile, null);
    }

    public static Map<String, Parser> getProfileArtifacts(FabricService fabricService, DownloadManager downloadManager, Profile profile, Callback<String> callback) throws Exception {
        List bundles = profile.getBundles();
        HashSet<Feature> features = new HashSet<Feature>();
        AgentUtils.addFeatures(features, fabricService, downloadManager, profile);
        return AgentUtils.getProfileArtifacts(fabricService, profile, bundles, features, callback);
    }

    public static Map<String, Parser> getProfileArtifacts(FabricService fabricService, Profile profile, Iterable<String> bundles, Iterable<Feature> features) {
        return AgentUtils.getProfileArtifacts(fabricService, profile, bundles, features, null);
    }

    public static File waitForFileDownload(DownloadFuture future) throws IOException {
        File file = future.getFile();
        while (file == null && !future.isDone() && !future.isCanceled()) {
            try {
                future.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            file = future.getFile();
        }
        return file;
    }

    public static Map<String, Parser> getProfileArtifacts(FabricService fabricService, Profile profile, Iterable<String> bundles, Iterable<Feature> features, Callback<String> nonMavenLocationCallback) {
        HashSet<String> locations = new HashSet<String>();
        for (Feature feature : features) {
            List<BundleInfo> bundleList = feature.getBundles();
            if (bundleList == null) {
                LOGGER.warn("No bundles for feature " + feature);
                continue;
            }
            for (BundleInfo bundle : bundleList) {
                locations.add(bundle.getLocation());
            }
        }
        for (String bundle : bundles) {
            locations.add(bundle);
        }
        HashMap<String, Parser> artifacts = new HashMap<String, Parser>();
        for (String location : locations) {
            try {
                if (location.contains("$")) {
                    location = VersionPropertyPointerResolver.replaceVersions((FabricService)fabricService, (Map)profile.getOverlay().getConfigurations(), (String)location);
                }
                if (location.startsWith("mvn:") || location.contains(":mvn:")) {
                    Parser parser = Parser.parsePathWithSchemePrefix(location);
                    artifacts.put(location, parser);
                    continue;
                }
                if (nonMavenLocationCallback == null) continue;
                nonMavenLocationCallback.call(location);
            }
            catch (MalformedURLException e) {
                LOGGER.error("Failed to parse bundle URL: " + location + ". " + e, (Throwable)e);
            }
        }
        return artifacts;
    }

    public static void addRepository(DownloadManager manager, Map<URI, Repository> repositories, URI uri) throws Exception {
        if (!repositories.containsKey(uri)) {
            File file = ((DownloadFuture)manager.download(uri.toString()).await()).getFile();
            FeatureValidationUtil.validate(file.toURI());
            RepositoryImpl repo = new RepositoryImpl(file.toURI());
            repositories.put(uri, repo);
            repo.load();
            for (URI ref : repo.getRepositories()) {
                AgentUtils.addRepository(manager, repositories, ref);
            }
        }
    }

    protected static Map<URI, Repository> getRepositories(FabricService fabricService, DownloadManager downloadManager, Profile profile) throws Exception {
        HashMap<URI, Repository> repositories = new HashMap<URI, Repository>();
        for (String repositoryUrl : profile.getRepositories()) {
            if (!Strings.isNotBlank((String)repositoryUrl)) continue;
            try {
                String replacedUrl = repositoryUrl;
                if (repositoryUrl.contains("$")) {
                    replacedUrl = VersionPropertyPointerResolver.replaceVersions((FabricService)fabricService, (Map)profile.getConfigurations(), (String)repositoryUrl);
                }
                URI repoUri = new URI(replacedUrl);
                AgentUtils.addRepository(downloadManager, repositories, repoUri);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to add repository " + repositoryUrl + " for profile " + profile.getId() + ". " + e);
            }
        }
        return repositories;
    }

    public static void addFeatures(Set<Feature> features, FabricService fabricService, DownloadManager downloadManager, Profile profile) throws Exception {
        List featureNames = profile.getFeatures();
        Map<URI, Repository> repositories = AgentUtils.getRepositories(fabricService, downloadManager, profile);
        for (String featureName : featureNames) {
            Feature feature = FeatureUtils.search(featureName, repositories.values());
            if (feature == null) {
                LOGGER.warn("Could not find feature " + featureName + " for profile " + profile.getId() + " in repositories " + repositories.keySet());
                continue;
            }
            features.addAll(AgentUtils.expandFeature(feature, repositories));
        }
    }

    public static Set<Feature> expandFeature(Feature feature, Map<URI, Repository> repositories) {
        HashSet<Feature> features = new HashSet<Feature>();
        for (Feature f : feature.getDependencies()) {
            Feature loaded = FeatureUtils.search(f.getName(), repositories.values());
            features.addAll(AgentUtils.expandFeature(loaded, repositories));
        }
        features.add(feature);
        return features;
    }

    public static Map<String, Repository> loadRepositories(DownloadManager manager, Set<String> uris) throws Exception {
        RepositoryDownloader downloader = new RepositoryDownloader(manager);
        downloader.download(uris);
        return downloader.await();
    }

    public static Map<String, File> downloadProfileArtifacts(FabricService fabricService, DownloadManager downloadManager, Profile profile) throws Exception {
        List bundles = profile.getBundles();
        HashSet<Feature> features = new HashSet<Feature>();
        AgentUtils.addFeatures(features, fabricService, downloadManager, profile);
        return AgentUtils.downloadBundles(downloadManager, features, bundles, Collections.EMPTY_SET);
    }

    public static Map<String, File> downloadBundles(DownloadManager manager, Iterable<Feature> features, Iterable<String> bundles, Set<String> overrides) throws Exception {
        HashSet<String> locations = new HashSet<String>();
        for (Feature feature : features) {
            for (BundleInfo bundle : feature.getBundles()) {
                locations.add(bundle.getLocation());
            }
        }
        for (String bundle : bundles) {
            locations.add(bundle);
        }
        for (String override : overrides) {
            locations.add(PatchUtils.extractUrl(override));
        }
        return AgentUtils.downloadLocations(manager, locations);
    }

    public static Map<String, File> downloadLocations(DownloadManager manager, Collection<String> locations) throws MalformedURLException, InterruptedException, MultiException {
        FileDownloader downloader = new FileDownloader(manager);
        downloader.download(locations);
        return downloader.await();
    }

    public static void addMavenProxies(Dictionary props, FabricService fabricService) {
        try {
            if (fabricService != null) {
                StringBuilder sb = new StringBuilder();
                for (URI uri : fabricService.getMavenRepoURIs()) {
                    String mavenRepo = uri.toString();
                    if (!mavenRepo.endsWith("/")) {
                        mavenRepo = mavenRepo + "/";
                    }
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(mavenRepo);
                    sb.append("@snapshots");
                }
                String existingRepos = (String)props.get("org.ops4j.pax.url.mvn.repositories");
                if (existingRepos != null) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(existingRepos);
                }
                props.put("org.ops4j.pax.url.mvn.repositories", sb.toString());
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unable to retrieve maven proxy urls: " + e.getMessage());
            LOGGER.debug("Unable to retrieve maven proxy urls: " + e.getMessage(), (Throwable)e);
        }
    }

    public static class FileDownloader
    extends ArtifactDownloader<File> {
        public FileDownloader(DownloadManager manager) {
            super(manager);
        }

        @Override
        protected File getArtifact(String uri, File file) throws Exception {
            return file;
        }
    }

    public static class RepositoryDownloader
    extends ArtifactDownloader<Repository> {
        public RepositoryDownloader(DownloadManager manager) {
            super(manager);
        }

        @Override
        protected Repository getArtifact(String uri, File file) throws Exception {
            FeatureValidationUtil.validate(file.toURI());
            RepositoryImpl repo = new RepositoryImpl(file.toURI());
            repo.load();
            for (URI ref : repo.getRepositories()) {
                this.download(ref.toString());
            }
            return repo;
        }
    }

    public static abstract class ArtifactDownloader<T> {
        protected final DownloadManager manager;
        protected final Object lock = new Object();
        protected final ConcurrentMap<String, DownloadFuture> futures = new ConcurrentHashMap<String, DownloadFuture>();
        protected final ConcurrentMap<String, T> artifacts = new ConcurrentHashMap<String, T>();
        protected final List<Throwable> errors = new CopyOnWriteArrayList<Throwable>();
        protected final AtomicInteger pendings = new AtomicInteger();

        public ArtifactDownloader(DownloadManager manager) {
            this.manager = manager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void download(String uri, final DownloadCallback callback) throws MalformedURLException {
            Object object = this.lock;
            synchronized (object) {
                DownloadFuture future = (DownloadFuture)this.futures.get(uri);
                if (future == null) {
                    this.pendings.incrementAndGet();
                    future = this.manager.download(uri);
                    future.addListener(new FutureListener<DownloadFuture>(){

                        @Override
                        public void operationComplete(DownloadFuture future) {
                            ArtifactDownloader.this.onDownloaded(future, callback);
                        }
                    });
                    this.futures.put(uri, future);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DownloadFuture download(String uri) throws MalformedURLException {
            Object object = this.lock;
            synchronized (object) {
                DownloadFuture future = (DownloadFuture)this.futures.get(uri);
                if (future == null) {
                    this.pendings.incrementAndGet();
                    future = this.manager.download(uri);
                    future.addListener(new FutureListener<DownloadFuture>(){

                        @Override
                        public void operationComplete(DownloadFuture future) {
                            ArtifactDownloader.this.onDownloaded(future, null);
                        }
                    });
                    this.futures.put(uri, future);
                }
                return future;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onDownloaded(DownloadFuture future, DownloadCallback callback) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    String url = future.getUrl();
                    File file = future.getFile();
                    if (file != null) {
                        T t = this.getArtifact(url, file);
                        this.artifacts.put(url, t);
                        if (callback != null) {
                            callback.downloaded(file);
                        }
                    }
                }
                catch (Throwable t) {
                    this.errors.add(t);
                }
                finally {
                    this.pendings.decrementAndGet();
                    this.lock.notifyAll();
                }
            }
        }

        protected abstract T getArtifact(String var1, File var2) throws Exception;

        public void download(Iterable<String> uris) throws MalformedURLException {
            for (String uri : uris) {
                this.download(uri);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, T> await() throws InterruptedException, MultiException {
            Object object = this.lock;
            synchronized (object) {
                while (this.pendings.get() > 0) {
                    this.lock.wait();
                }
                if (!this.errors.isEmpty()) {
                    StringWriter sw = new StringWriter();
                    int nr = 1;
                    int pad = Integer.toString(this.errors.size()).length();
                    for (Throwable t : this.errors) {
                        sw.append(String.format("%n\t%0" + pad + "d: %s", nr++, t.getMessage()));
                    }
                    LOGGER.error("Summary of errors while downloading artifacts:" + sw.toString());
                    throw new MultiException(String.format("Error%s while downloading artifacts:%s", this.errors.size() == 1 ? "" : "s", sw.toString()), this.errors);
                }
                return this.artifacts;
            }
        }
    }

    public static interface DownloadCallback {
        public void downloaded(File var1) throws Exception;
    }

    public static interface Callback<T> {
        public void call(T var1);
    }
}

