/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.boot.commands.support;

import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.Validatable;
import io.fabric8.api.scr.ValidationSupport;
import io.fabric8.boot.commands.support.ParameterCompleter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.karaf.shell.console.CompletableFunction;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.NullCompleter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractCommandComponent
extends AbstractCommand
implements Validatable,
CompletableFunction {
    private static final transient Logger LOG = LoggerFactory.getLogger(AbstractCommandComponent.class);
    private final ValidationSupport active = new ValidationSupport();
    private final List<Completer> completers = new ArrayList<Completer>();
    private final Map<String, Completer> optionalCompleters = new HashMap<String, Completer>();

    public void activateComponent() {
        this.active.setValid();
        LOG.info("activateComponent: " + (Object)((Object)this));
    }

    public void deactivateComponent() {
        LOG.info("deactivateComponent: " + (Object)((Object)this));
        this.active.setInvalid();
    }

    public boolean isValid() {
        return this.active.isValid();
    }

    public void assertValid() {
        this.active.assertValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Completer> getCompleters() {
        List<Completer> list = this.completers;
        synchronized (list) {
            if (this.completers.isEmpty()) {
                return Arrays.asList(new NullCompleter());
            }
            return Collections.unmodifiableList(this.completers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Completer> getOptionalCompleters() {
        Map<String, Completer> map = this.optionalCompleters;
        synchronized (map) {
            return Collections.unmodifiableMap(this.optionalCompleters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindCompleter(Completer completer) {
        List<Completer> list = this.completers;
        synchronized (list) {
            this.completers.add(completer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindCompleter(Completer completer) {
        List<Completer> list = this.completers;
        synchronized (list) {
            this.completers.remove(completer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindOptionalCompleter(ParameterCompleter completer) {
        Map<String, Completer> map = this.optionalCompleters;
        synchronized (map) {
            this.optionalCompleters.put(completer.getParameter(), completer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindOptionalCompleter(ParameterCompleter completer) {
        Map<String, Completer> map = this.optionalCompleters;
        synchronized (map) {
            this.optionalCompleters.remove(completer.getParameter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindOptionalCompleter(String key, Completer completer) {
        Map<String, Completer> map = this.optionalCompleters;
        synchronized (map) {
            this.optionalCompleters.put(key, completer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindOptionalCompleter(String key) {
        Map<String, Completer> map = this.optionalCompleters;
        synchronized (map) {
            this.optionalCompleters.remove(key);
        }
    }
}

