/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.fabric.commands;

import io.fabric8.process.fabric.ContainerInstallOptions;
import io.fabric8.process.fabric.commands.ContainerProcessCommandSupport;
import io.fabric8.process.manager.Installation;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.apache.felix.gogo.commands.Command;

@Command(name="ps", scope="process", description="Lists the currently installed managed processes.")
public class ProcessList
extends ContainerProcessCommandSupport {
    static final String[] HEADERS = new String[]{"[id]", "[pid]", "[name]"};
    static final String FORMAT = "%7s %9s %s";

    @Override
    void doWithAuthentication(String jmxUser, String jmxPassword) throws Exception {
        ContainerInstallOptions options = ((ContainerInstallOptions.ContainerInstallOptionsBuilder)ContainerInstallOptions.builder().container(this.getContainerObject())).user(jmxUser).password(jmxPassword).build();
        List<Installation> installations = this.getContainerProcessManager().listInstallations(options);
        this.printInstallations(installations, System.out);
    }

    protected void printInstallations(List<Installation> installations, PrintStream out) {
        out.println(String.format(FORMAT, HEADERS));
        for (Installation installation : installations) {
            String id = installation.getId();
            Long pid = null;
            try {
                pid = installation.getActivePid();
            }
            catch (IOException e) {
                System.err.println("Failed to find pid for id: " + id + ". " + e);
            }
            out.println(String.format(FORMAT, "" + id, pid != null ? pid.toString() : "", installation.getName()));
        }
    }
}

