/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.fabric.child;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.OptionsProvider;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileBuilder;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Profiles;
import io.fabric8.api.Version;
import io.fabric8.common.util.Objects;
import io.fabric8.deployer.JavaContainers;
import io.fabric8.process.fabric.child.ProcessRequirements;
import io.fabric8.process.manager.InstallOptions;
import io.fabric8.process.manager.InstallTask;
import io.fabric8.process.manager.Installation;
import io.fabric8.process.manager.ProcessController;
import io.fabric8.process.manager.ProcessManager;
import io.fabric8.process.manager.support.ApplyConfigurationTask;
import io.fabric8.process.manager.support.CompositeTask;
import io.fabric8.process.manager.support.InstallDeploymentsTask;
import io.fabric8.process.manager.support.ProcessUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildProcessManager {
    private static final transient Logger LOG = LoggerFactory.getLogger(ChildProcessManager.class);
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private FabricService fabricService;
    private ProcessManager processManager;

    public void destroy() {
        this.executorService.shutdown();
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    public void setFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public ProcessManager getProcessManager() {
        return this.processManager;
    }

    public void setProcessManager(ProcessManager processManager) {
        this.processManager = processManager;
    }

    Installation provisionProcess(ProcessRequirements requirements) throws Exception {
        this.uninstallProcess(requirements);
        InstallOptions installOptions = requirements.createInstallOptions();
        Profile processProfile = this.getProcessProfile(requirements, true);
        Profile deployProcessProfile = this.getProcessProfile(requirements, false);
        Map configuration = ProcessUtils.getProcessLayout((FabricService)this.fabricService, (Profile)processProfile, (String)requirements.getLayout());
        ApplyConfigurationTask applyConfiguration = new ApplyConfigurationTask(configuration, installOptions.getProperties());
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        profiles.add(deployProcessProfile);
        Map javaArtifacts = JavaContainers.getJavaContainerArtifactsFiles((FabricService)this.fabricService, profiles, (ExecutorService)this.executorService);
        String versionId = Profiles.versionId((Version)this.fabricService.getCurrentContainer().getVersion());
        List profileIds = Profiles.profileIds(profiles);
        Map contextPathConfiguration = Profiles.getOverlayConfiguration((FabricService)this.fabricService, (Iterable)profileIds, (String)versionId, (String)"io.fabric8.web.contextPath");
        InstallDeploymentsTask applyProfile = new InstallDeploymentsTask(javaArtifacts, contextPathConfiguration);
        CompositeTask compositeTask = new CompositeTask(new InstallTask[]{applyConfiguration, applyProfile});
        Installation installation = this.processManager.install(installOptions, (InstallTask)compositeTask);
        if (installation != null) {
            installation.getController().start();
        }
        return installation;
    }

    void uninstallProcess(ProcessRequirements requirements) throws Exception {
        String id = requirements.getId();
        Installation installation = this.findProcessInstallation(id);
        if (installation != null) {
            ProcessController controller = installation.getController();
            try {
                controller.stop();
            }
            catch (Exception e) {
                LOG.warn("Ignored exception while trying to stop process " + installation + " " + e);
            }
            controller.uninstall();
            controller = null;
        }
    }

    protected Profile getProcessProfile(ProcessRequirements requirements, boolean includeController) {
        Container container = this.fabricService.getCurrentContainer();
        ProfileService profileService = (ProfileService)this.fabricService.adapt(ProfileService.class);
        Profile processProfile = this.getProcessProfile(requirements, includeController, container);
        return Profiles.getEffectiveProfile((FabricService)this.fabricService, (Profile)profileService.getOverlayProfile(processProfile));
    }

    protected Installation findProcessInstallation(String id) {
        List installations = this.processManager.listInstallations();
        for (Installation installation : installations) {
            String name = installation.getName();
            if (!Objects.equal((Object)id, (Object)name)) continue;
            return installation;
        }
        return null;
    }

    private Profile getProcessProfile(ProcessRequirements requirements, boolean includeController, Container container) {
        String versionId = container.getVersion().getId();
        String profileId = "process-profile-" + requirements.getId();
        ProfileBuilder builder = ProfileBuilder.Factory.create((String)versionId, (String)profileId);
        ProcessProfileOptions optionsProvider = new ProcessProfileOptions(container, requirements, includeController);
        return ((ProfileBuilder)builder.addOptions((OptionsProvider)optionsProvider)).getProfile();
    }

    static class ProcessProfileOptions
    implements OptionsProvider<ProfileBuilder> {
        private final Container container;
        private final ProcessRequirements requirements;
        private final boolean includeContainerProfile;

        ProcessProfileOptions(Container container, ProcessRequirements requirements, boolean includeContainerProfile) {
            this.container = container;
            this.requirements = requirements;
            this.includeContainerProfile = includeContainerProfile;
        }

        public ProfileBuilder addOptions(ProfileBuilder builder) {
            builder.addAttribute("abstract", Boolean.TRUE.toString());
            builder.addAttribute("locked", Boolean.TRUE.toString());
            builder.addAttribute("hidden", Boolean.TRUE.toString());
            builder.addParents(this.getParents());
            return builder;
        }

        private List<Profile> getParents() {
            List<String> parents = this.requirements.getProfiles();
            LinkedList<Profile> profiles = new LinkedList<Profile>();
            if (this.includeContainerProfile) {
                profiles.add(this.container.getOverlayProfile());
            }
            for (String parent : parents) {
                Profile p = this.container.getVersion().getRequiredProfile(parent);
                profiles.add(p);
            }
            return profiles;
        }
    }
}

