/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.security.sso.activemq;

import io.fabric8.security.sso.activemq.TokenPrincipal;
import io.fabric8.security.sso.client.OpenAMRestClient;
import java.io.IOException;
import java.security.Principal;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerFilter;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.jaas.JassCredentialCallbackHandler;
import org.apache.activemq.security.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAMAuthenticationBroker
extends BrokerFilter {
    private static Logger LOG = LoggerFactory.getLogger(OpenAMAuthenticationBroker.class);
    private final OpenAMRestClient client;
    private final String jassConfiguration;
    private final CopyOnWriteArrayList<SecurityContext> securityContexts = new CopyOnWriteArrayList();
    private boolean authorizeSend = false;

    public OpenAMAuthenticationBroker(Broker next, String jassConfiguration, OpenAMRestClient client) {
        super(next);
        this.jassConfiguration = jassConfiguration;
        this.client = client;
    }

    public void setAuthorizeSend(boolean authorizeSend) {
        this.authorizeSend = authorizeSend;
    }

    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
        LOG.info("Adding connection with context {} and info {}", new Object[]{context, info});
        if (context.getSecurityContext() == null) {
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(OpenAMAuthenticationBroker.class.getClassLoader());
            try {
                JassCredentialCallbackHandler callback = new JassCredentialCallbackHandler(info.getUserName(), info.getPassword());
                LoginContext lc = new LoginContext(this.jassConfiguration, (CallbackHandler)callback);
                lc.login();
                Subject subject = lc.getSubject();
                LOG.info("Got subject {}", (Object)subject);
                OpenAMSecurityContext s = new OpenAMSecurityContext(info.getUserName(), subject, lc);
                context.setSecurityContext((SecurityContext)s);
                this.securityContexts.add(s);
            }
            catch (Exception e) {
                throw (SecurityException)new SecurityException("User name or password is invalid.").initCause(e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
        super.addConnection(context, info);
    }

    public void addProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        String token = this.getToken(context.getSecurityContext());
        this.authorizeDestinations(info.getDestination(), token, "addProducer");
        super.addProducer(context, info);
    }

    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        String token = this.getToken(context.getSecurityContext());
        this.authorizeDestinations(info.getDestination(), token, "addConsumer");
        return super.addConsumer(context, info);
    }

    public void send(ProducerBrokerExchange producer, Message message) throws Exception {
        if (message.getProperty("SSO_TOKEN") == null) {
            LOG.info("No SSO token on incoming message, checking if producer had logged in previously");
            this.addToken(producer, message);
        } else {
            LOG.info("SSO token present in incoming message");
        }
        if (this.authorizeSend) {
            String token = this.getToken(message);
            this.authorizeDestinations(message.getDestination(), token, "send");
        }
        super.send(producer, message);
    }

    private void authorizeDestinations(ActiveMQDestination destination, String token, String action) {
        LOG.info("checking if token {} can interact with destination {}", new Object[]{token, destination});
        if (destination == null) {
            return;
        }
        if (destination.isComposite()) {
            for (ActiveMQDestination dest : destination.getCompositeDestinations()) {
                this.authorizeDestinations(dest, token, action);
            }
        } else {
            String uri = "/" + action + "/" + destination.getDestinationTypeAsString() + "/" + destination.getPhysicalName();
            LOG.info("Authorizing token {} for uri {}", new Object[]{token, this.client.getURLPrefix() + uri});
            if (!this.client.authorize(uri, token)) {
                throw new SecurityException(String.format("Client is not authorized to perform action \"%s\" on destination \"%s\"", action, destination.getQualifiedName()));
            }
        }
    }

    private String getToken(SecurityContext sc) {
        if (sc == null) {
            return "";
        }
        for (Object principal : sc.getPrincipals()) {
            if (!(principal instanceof TokenPrincipal)) continue;
            return ((TokenPrincipal)principal).getName();
        }
        return "";
    }

    private void addToken(ProducerBrokerExchange producer, Message message) throws IOException {
        message.setProperty("SSO_TOKEN", (Object)this.getToken(producer.getConnectionContext().getSecurityContext()));
    }

    private String getToken(Message message) throws IOException {
        String token;
        Object t = message.getProperty("SSO_TOKEN");
        if (t == null) {
            throw new SecurityException("No SSO token available in message for verification");
        }
        if (t instanceof byte[]) {
            token = new String((byte[])t);
        } else if (t instanceof String) {
            token = (String)t;
        } else {
            throw new SecurityException("Unrecognized SSO token format");
        }
        return token;
    }

    public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Exception {
        super.removeConnection(context, info, error);
        SecurityContext s = context.getSecurityContext();
        if (this.securityContexts.remove(s)) {
            if (s instanceof OpenAMSecurityContext) {
                ((OpenAMSecurityContext)s).getLoginContext().logout();
            }
            context.setSecurityContext(null);
        }
    }

    public void refresh() {
        LOG.info(String.format("%s.%s", ((Object)((Object)this)).getClass().getSimpleName(), "refresh"));
        for (SecurityContext sc : this.securityContexts) {
            sc.getAuthorizedReadDests().clear();
            sc.getAuthorizedWriteDests().clear();
        }
    }

    static class OpenAMSecurityContext
    extends SecurityContext {
        private final Subject subject;
        private final LoginContext lc;

        public OpenAMSecurityContext(String userName, Subject subject, LoginContext lc) {
            super(userName);
            this.subject = subject;
            this.lc = lc;
        }

        public Set<Principal> getPrincipals() {
            return this.subject.getPrincipals();
        }

        public LoginContext getLoginContext() {
            return this.lc;
        }
    }
}

