/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.security.sso.activemq;

import io.fabric8.security.sso.activemq.TokenPrincipal;
import io.fabric8.security.sso.client.OpenAMRestClient;
import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.activemq.util.IntrospectionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAMLoginModule
implements LoginModule {
    private static Logger LOG = LoggerFactory.getLogger(OpenAMLoginModule.class);
    OpenAMRestClient client = new OpenAMRestClient();
    private boolean debug = false;
    private Set<Principal> principals = new HashSet<Principal>();
    private Subject subject;
    private CallbackHandler handler;
    private String token;
    private boolean loginSucceeded;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        HashMap tmpOptions = new HashMap();
        for (String key : options.keySet()) {
            tmpOptions.put(key, options.get(key));
        }
        IntrospectionSupport.setProperties((Object)this, tmpOptions);
        this.subject = subject;
        this.handler = callbackHandler;
        if (this.debug) {
            LOG.info("Initializing {} ", (Object)this);
        }
    }

    public String toString() {
        return "OpenAMLoginModule{token='" + this.token + '\'' + ", handler=" + this.handler + ", subject=" + this.subject + ", debug=" + this.debug + ", client=" + this.client + '}';
    }

    public String getOrElse(Map<String, ?> map, String key, String theElse) {
        String result = (String)map.get(key);
        return result == null ? result : theElse;
    }

    @Override
    public boolean login() throws LoginException {
        LOG.info("login");
        this.loginSucceeded = this.doLogin();
        if (this.loginSucceeded) {
            this.principals.add(new TokenPrincipal(this.token));
            this.subject.getPrincipals().addAll(this.principals);
        }
        return this.loginSucceeded;
    }

    private boolean doLogin() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        try {
            this.handler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getMessage() + " not available to obtain information from user");
        }
        String user = ((NameCallback)callbacks[0]).getName();
        char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        if (user == null) {
            throw new FailedLoginException("user name is null");
        }
        String pass = new String(tmpPassword);
        this.token = this.client.authenticate(user, pass);
        if (this.token == null) {
            return true;
        }
        if (!this.client.isValidToken(this.token)) {
            return true;
        }
        return this.client.authorize("/login", this.token);
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.loginSucceeded) {
            if (this.debug) {
                LOG.info("Successfully logged in user with token {}", (Object)this.token);
            }
        } else {
            this.clear();
            if (this.debug) {
                LOG.info("Cleaned up failed attempt to log in");
            }
        }
        return true;
    }

    private void clear() {
        this.token = null;
        this.loginSucceeded = false;
    }

    @Override
    public boolean abort() throws LoginException {
        this.clear();
        if (this.debug) {
            LOG.info("Abort");
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.client.logout(this.token);
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        this.clear();
        if (this.debug) {
            LOG.info("Logged out token {}", (Object)this.token);
        }
        return true;
    }

    public boolean getDebug() {
        return this.debug && this.client.isDebug();
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        this.client.setDebug(debug);
    }

    public String getOpenAMHostName() {
        return this.client.getOpenAMHostName();
    }

    public void setOpenAMHostName(String openAMHostName) {
        this.client.setOpenAMHostName(openAMHostName);
    }

    public String getOpenAMPort() {
        return this.client.getOpenAMPort();
    }

    public void setOpenAMPort(String openAMPort) {
        this.client.setOpenAMPort(openAMPort);
    }

    public String getOpenAMMethod() {
        return this.client.getOpenAMMethod();
    }

    public void setOpenAMMethod(String openAMMethod) {
        this.client.setOpenAMMethod(openAMMethod);
    }

    public String getOpenAMURLPrefix() {
        return this.client.getOpenAMURLPrefix();
    }

    public void setOpenAMURLPrefix(String openAMURLPrefix) {
        this.client.setOpenAMURLPrefix(openAMURLPrefix);
    }

    public String getOpenAMRealm() {
        return this.client.getOpenAMRealm();
    }

    public void setOpenAMRealm(String openAMRealm) {
        this.client.setOpenAMRealm(openAMRealm);
    }

    public String getOpenAMService() {
        return this.client.getOpenAMService();
    }

    public void setOpenAMService(String openAMService) {
        this.client.setOpenAMService(openAMService);
    }

    public void setServicePrefix(String servicePrefix) {
        this.client.setServicePrefix(servicePrefix);
    }

    public String getServicePrefix() {
        return this.client.getServicePrefix();
    }
}

