/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.security.sso.activemq;

import io.fabric8.security.sso.activemq.OpenAMAuthenticationBroker;
import io.fabric8.security.sso.client.OpenAMRestClient;
import java.net.URL;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAMAuthenticationPlugin
implements BrokerPlugin {
    private static Logger LOG = LoggerFactory.getLogger(OpenAMAuthenticationPlugin.class);
    protected String configuration = "activemq-domain";
    protected OpenAMRestClient client = new OpenAMRestClient();
    protected boolean discoverLoginConfig = true;
    protected boolean authorizeSend = false;

    public Broker installPlugin(Broker broker) {
        LOG.info("Installing OpenAM Authentication plugin - {}", (Object)this);
        this.initialiseJaas();
        OpenAMAuthenticationBroker rc = new OpenAMAuthenticationBroker(broker, this.configuration, this.client);
        rc.setAuthorizeSend(this.authorizeSend);
        return rc;
    }

    public String toString() {
        return "OpenAMAuthenticationPlugin{configuration='" + this.configuration + '\'' + ", client=" + this.client + ", discoverLoginConfig=" + this.discoverLoginConfig + '}';
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setClient(OpenAMRestClient client) {
        this.client = client;
    }

    public OpenAMRestClient getClient() {
        return this.client;
    }

    public void setConfiguration(String jaasConfiguration) {
        this.configuration = jaasConfiguration;
    }

    public boolean isDiscoverLoginConfig() {
        return this.discoverLoginConfig;
    }

    public void setAuthorizeSend(boolean authorizeSend) {
        this.authorizeSend = authorizeSend;
    }

    public boolean isAuthorizeSend() {
        return this.authorizeSend;
    }

    public void setDiscoverLoginConfig(boolean discoverLoginConfig) {
        this.discoverLoginConfig = discoverLoginConfig;
    }

    protected void initialiseJaas() {
        if (this.discoverLoginConfig) {
            LOG.info("Searching for login.config");
            String path = System.getProperty("java.security.auth.login.config");
            if (path == null) {
                URL resource = null;
                if (resource == null) {
                    resource = this.getClass().getClassLoader().getResource("login.config");
                }
                if (resource != null) {
                    path = resource.getFile();
                    System.setProperty("java.security.auth.login.config", path);
                }
            }
            LOG.info("login.config found at {}", (Object)path);
        }
    }
}

