/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.security.sso.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAMRestClient {
    private static Logger LOG = LoggerFactory.getLogger(OpenAMRestClient.class);
    protected String OpenAMRealm = "/";
    protected String OpenAMService = "activemq";
    protected String OpenAMHostName = "localhost";
    protected String OpenAMPort = "8080";
    protected String OpenAMMethod = "http";
    protected String OpenAMURLPrefix = "opensso";
    protected String ServicePrefix = "http://localhost:61616/activemq";
    protected boolean debug = false;

    public String authenticate(String username, String password) {
        String rc = this.doInvoke(this.getAuthenticateUrl(username, password));
        if (!rc.startsWith("token.id=")) {
            return null;
        }
        return rc.split("=")[1].trim();
    }

    public boolean authorize(String service, String token, String action) {
        service = !service.startsWith("/") ? this.getServicePrefix() + "/" + service : this.getServicePrefix() + service;
        return this.checkResult(this.doInvoke(this.getAuthorizeUrl(service, token, action)));
    }

    public boolean authorize(String service, String token) {
        return this.authorize(service, token, "GET");
    }

    public boolean isValidToken(String token) {
        return this.checkResult(this.doInvoke(this.getIsValidTokenUrl(token)));
    }

    public String getURLPrefix() {
        return this.OpenAMMethod + "://" + this.OpenAMHostName + ":" + this.OpenAMPort + "/" + this.OpenAMURLPrefix;
    }

    public void logout(String token) {
        this.doInvoke(this.getLogoutUrl(token));
    }

    public String toString() {
        return "OpenAMRestClient{OpenAMRealm='" + this.OpenAMRealm + '\'' + ", OpenAMService='" + this.OpenAMService + '\'' + ", OpenAMHostName='" + this.OpenAMHostName + '\'' + ", OpenAMPort='" + this.OpenAMPort + '\'' + ", OpenAMMethod='" + this.OpenAMMethod + '\'' + ", OpenAMURLPrefix='" + this.OpenAMURLPrefix + '\'' + ", ServicePrefix='" + this.ServicePrefix + '\'' + ", debug=" + this.debug + '}';
    }

    protected boolean checkResult(String result) {
        if (!(result = result.trim()).startsWith("boolean=")) {
            return false;
        }
        try {
            return Boolean.parseBoolean(result.split("=")[1]);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected String read(InputStream is) throws IOException {
        byte[] b = new byte[is.available()];
        is.read(b);
        return new String(b);
    }

    protected String doInvoke(String url) {
        try {
            if (this.debug) {
                LOG.info("Sending : {}", (Object)url);
            }
            HttpURLConnection auth = (HttpURLConnection)new URL(url).openConnection();
            auth.setRequestMethod("POST");
            auth.connect();
            String rc = "";
            rc = auth.getResponseCode() == 200 ? this.read(auth.getInputStream()) : this.read(auth.getErrorStream());
            auth.disconnect();
            if (this.debug) {
                LOG.info("Got : {}", (Object)rc);
            }
            return rc;
        }
        catch (Exception e) {
            LOG.warn("Exception invoking on REST API", (Throwable)e);
            throw new RuntimeException("Exception invoking on REST API : " + e.getMessage());
        }
    }

    protected String getLogoutUrl(String token) {
        return String.format("%s/identity/logout?subjectid=%s", this.getURLPrefix(), token);
    }

    protected String getIsValidTokenUrl(String token) {
        return String.format("%s/identity/isTokenValid?tokenid=%s", this.getURLPrefix(), token);
    }

    protected String getAuthorizeUrl(String uri, String token, String action) {
        return String.format("%s/identity/authorize?uri=%s&action=%s&subjectid=%s", this.getURLPrefix(), uri, action, token);
    }

    protected String getAuthenticateUrl(String username, String password) {
        return String.format("%s/identity/authenticate?username=%s&password=%s", this.getURLPrefix(), username, password);
    }

    public String getOpenAMRealm() {
        return this.OpenAMRealm;
    }

    public void setOpenAMRealm(String openAMRealm) {
        this.OpenAMRealm = openAMRealm;
    }

    public String getOpenAMService() {
        return this.OpenAMService;
    }

    public void setOpenAMService(String openAMService) {
        this.OpenAMService = openAMService;
    }

    public String getOpenAMHostName() {
        return this.OpenAMHostName;
    }

    public void setOpenAMHostName(String openAMHostName) {
        this.OpenAMHostName = openAMHostName;
    }

    public String getOpenAMPort() {
        return this.OpenAMPort;
    }

    public void setOpenAMPort(String openAMPort) {
        this.OpenAMPort = openAMPort;
    }

    public String getOpenAMMethod() {
        return this.OpenAMMethod;
    }

    public void setOpenAMMethod(String openAMMethod) {
        this.OpenAMMethod = openAMMethod;
    }

    public String getOpenAMURLPrefix() {
        return this.OpenAMURLPrefix;
    }

    public void setOpenAMURLPrefix(String openAMURLPrefix) {
        this.OpenAMURLPrefix = openAMURLPrefix;
    }

    public String getServicePrefix() {
        return this.ServicePrefix;
    }

    public void setServicePrefix(String servicePrefix) {
        this.ServicePrefix = servicePrefix;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

