/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tooling.testing.pax.exam.karaf;

import io.fabric8.tooling.testing.pax.exam.karaf.CommandExecutionException;
import io.fabric8.tooling.testing.pax.exam.karaf.ServiceLocator;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.security.auth.Subject;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.junit.Assert;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.ops4j.pax.exam.junit.ProbeBuilder;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.options.MavenArtifactProvisionOption;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricKarafTestSupport {
    public static final Long DEFAULT_TIMEOUT = 30000L;
    public static final Long SYSTEM_TIMEOUT = 30000L;
    public static final Long DEFAULT_WAIT = 10000L;
    public static final Long PROVISION_TIMEOUT = 300000L;
    public static final Long COMMAND_TIMEOUT = 70000L;
    static final ExecutorService executor = Executors.newCachedThreadPool();
    static final Logger LOGGER = LoggerFactory.getLogger(FabricKarafTestSupport.class);
    @Inject
    protected BundleContext bundleContext;

    protected Bundle installBundle(String groupId, String artifactId) throws Exception {
        MavenArtifactProvisionOption mvnUrl = CoreOptions.mavenBundle((String)groupId, (String)artifactId).versionAsInProject();
        return this.bundleContext.installBundle(mvnUrl.getURL());
    }

    protected Bundle getInstalledBundle(String symbolicName) {
        for (Bundle b : this.bundleContext.getBundles()) {
            if (!b.getSymbolicName().equals(symbolicName)) continue;
            return b;
        }
        for (Bundle b : this.bundleContext.getBundles()) {
            System.err.println("Bundle: " + b.getSymbolicName());
        }
        throw new RuntimeException("Bundle " + symbolicName + " does not exist");
    }

    public static Option copySystemProperty(String propertyName) {
        return KarafDistributionOption.editConfigurationFilePut((String)"etc/system.properties", (String)propertyName, (String)(System.getProperty(propertyName) != null ? System.getProperty(propertyName) : ""));
    }

    protected static MavenArtifactProvisionOption mavenBundle(String groupId, String artifactId) {
        return CoreOptions.mavenBundle((String)groupId, (String)artifactId).versionAsInProject();
    }

    protected static MavenArtifactProvisionOption mavenBundle(String groupId, String artifactId, String version) {
        return CoreOptions.mavenBundle((String)groupId, (String)artifactId).version(version);
    }

    public static String tryCommand(String command) {
        try {
            return FabricKarafTestSupport.executeCommands(COMMAND_TIMEOUT, false, null, command);
        }
        catch (Throwable t) {
            return "Error executing command:" + t.getMessage();
        }
    }

    public static String executeCommand(String command) {
        return FabricKarafTestSupport.executeCommands(COMMAND_TIMEOUT, false, null, command);
    }

    public static String executeCommand(Set<RolePrincipal> roles, String command) {
        return FabricKarafTestSupport.executeCommands(COMMAND_TIMEOUT, false, roles, command);
    }

    public static String executeCommands(String ... commands) {
        return FabricKarafTestSupport.executeCommands(COMMAND_TIMEOUT, false, null, commands);
    }

    public static String executeCommand(Set<RolePrincipal> roles, String ... commands) {
        return FabricKarafTestSupport.executeCommands(COMMAND_TIMEOUT, false, roles, commands);
    }

    public static String executeCommand(String command, long timeout, boolean silent) {
        return FabricKarafTestSupport.executeCommands(timeout, silent, null, command);
    }

    public static String executeCommands(long timeout, final boolean silent, final Set<RolePrincipal> roles, final String ... commands) {
        String response = null;
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        final PrintStream printStream = new PrintStream(byteArrayOutputStream);
        CommandProcessor commandProcessor = ServiceLocator.awaitService(FrameworkUtil.getBundle(FabricKarafTestSupport.class).getBundleContext(), CommandProcessor.class);
        final CommandSession commandSession = commandProcessor.createSession(System.in, printStream, printStream);
        commandSession.put("APPLICATION", (Object)System.getProperty("runtime.id", "root"));
        commandSession.put("USER", (Object)"karaf");
        FutureTask<String> commandFuture = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                Subject subject = new Subject();
                subject.getPrincipals().add((Principal)new UserPrincipal("admin"));
                subject.getPrincipals().add((Principal)new RolePrincipal("admin"));
                subject.getPrincipals().add((Principal)new RolePrincipal("manager"));
                subject.getPrincipals().add((Principal)new RolePrincipal("viewer"));
                if (roles != null) {
                    for (RolePrincipal role : roles) {
                        subject.getPrincipals().add((Principal)role);
                    }
                }
                return Subject.doAs(subject, new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        for (String command : commands) {
                            boolean keepRunning = true;
                            if (!silent) {
                                System.out.println(command);
                                System.out.flush();
                            }
                            LOGGER.info("Executing command: " + command);
                            while (!Thread.currentThread().isInterrupted() && keepRunning) {
                                try {
                                    commandSession.execute((CharSequence)command);
                                    keepRunning = false;
                                }
                                catch (Exception e) {
                                    if (FabricKarafTestSupport.retryException(e)) {
                                        keepRunning = true;
                                        FabricKarafTestSupport.sleep(1000L);
                                        continue;
                                    }
                                    throw new CommandExecutionException(e);
                                }
                            }
                        }
                        printStream.flush();
                        return byteArrayOutputStream.toString();
                    }
                });
            }
        });
        try {
            executor.submit(commandFuture);
            response = commandFuture.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw CommandExecutionException.launderThrowable(e.getCause());
        }
        catch (Exception e) {
            throw CommandExecutionException.launderThrowable(e);
        }
        return response;
    }

    private static boolean retryException(Exception e) {
        return e.getClass().getName().equals("org.apache.felix.gogo.runtime.CommandNotFoundException");
    }

    private static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void installAndCheckFeature(String feature) throws Exception {
        System.err.println(FabricKarafTestSupport.executeCommand("features:install " + feature));
        FeaturesService featuresService = ServiceLocator.awaitService(this.bundleContext, FeaturesService.class);
        System.err.println(FabricKarafTestSupport.executeCommand("osgi:list -t 0"));
        Assert.assertTrue((String)("Expected " + feature + " feature to be installed."), (boolean)featuresService.isInstalled(featuresService.getFeature(feature)));
    }

    public void unInstallAndCheckFeature(String feature) throws Exception {
        System.err.println(FabricKarafTestSupport.executeCommand("features:uninstall " + feature));
        FeaturesService featuresService = ServiceLocator.awaitService(this.bundleContext, FeaturesService.class);
        System.err.println(FabricKarafTestSupport.executeCommand("osgi:list -t 0"));
        Assert.assertFalse((String)("Expected " + feature + " feature to be installed."), (boolean)featuresService.isInstalled(featuresService.getFeature(feature)));
    }

    @ProbeBuilder
    public TestProbeBuilder probeConfiguration(TestProbeBuilder probe) {
        probe.setHeader("DynamicImport-Package", "*,org.apache.felix.service.*;status=provisional");
        return probe;
    }
}

