/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.check.jsonpath;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.package;
import io.gatling.commons.validation.package$;
import io.gatling.core.check.jsonpath.JsonFilter;
import io.gatling.core.check.jsonpath.JsonFilter$;
import io.gatling.core.util.cache.Cache$;
import io.gatling.jsonpath.JPError;
import io.gatling.jsonpath.JsonPath;
import io.gatling.jsonpath.JsonPath$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001m4Aa\u0002\u0005\u0001'!A!\u0004\u0001B\u0001B\u0003%1\u0004C\u0003\u001f\u0001\u0011\u0005q\u0004C\u0004$\u0001\t\u0007I\u0011\u0002\u0013\t\r-\u0003\u0001\u0015!\u0003&\u0011\u0015a\u0005\u0001\"\u0001N\u0011\u0015A\b\u0001\"\u0001z\u0005%Q5o\u001c8QCRD7O\u0003\u0002\n\u0015\u0005A!n]8oa\u0006$\bN\u0003\u0002\f\u0019\u0005)1\r[3dW*\u0011QBD\u0001\u0005G>\u0014XM\u0003\u0002\u0010!\u00059q-\u0019;mS:<'\"A\t\u0002\u0005%|7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011a!\u00118z%\u00164\u0017\u0001E2bG\",W*\u0019=DCB\f7-\u001b;z!\t)B$\u0003\u0002\u001e-\t!Aj\u001c8h\u0003\u0019a\u0014N\\5u}Q\u0011\u0001E\t\t\u0003C\u0001i\u0011\u0001\u0003\u0005\u00065\t\u0001\raG\u0001\u000eUN|g\u000eU1uQ\u000e\u000b7\r[3\u0016\u0003\u0015\u0002BAJ\u00194}5\tqE\u0003\u0002)S\u0005)1-Y2iK*\u0011!fK\u0001\tG\u00064g-Z5oK*\u0011A&L\u0001\tE\u0016tW.\u00198fg*\u0011afL\u0001\u0007O&$\b.\u001e2\u000b\u0003A\n1aY8n\u0013\t\u0011tE\u0001\u0007M_\u0006$\u0017N\\4DC\u000eDW\r\u0005\u00025w9\u0011Q'\u000f\t\u0003mYi\u0011a\u000e\u0006\u0003qI\ta\u0001\u0010:p_Rt\u0014B\u0001\u001e\u0017\u0003\u0019\u0001&/\u001a3fM&\u0011A(\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i2\u0002cA E\r6\t\u0001I\u0003\u0002B\u0005\u0006Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u0005\rs\u0011aB2p[6|gn]\u0005\u0003\u000b\u0002\u0013!BV1mS\u0012\fG/[8o!\t9\u0015*D\u0001I\u0015\tIa\"\u0003\u0002K\u0011\nA!j]8o!\u0006$\b.\u0001\bkg>t\u0007+\u0019;i\u0007\u0006\u001c\u0007.\u001a\u0011\u0002\u0015\u0015DHO]1di\u0006cG.\u0006\u0002O9R\u0019qJ\u001b<\u0015\u0005A+\u0007cA E#B\u0019!k\u0016.\u000f\u0005M+fB\u0001\u001cU\u0013\u00059\u0012B\u0001,\u0017\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001W-\u0003\u0011%#XM]1u_JT!A\u0016\f\u0011\u0005mcF\u0002\u0001\u0003\u0006;\u0016\u0011\rA\u0018\u0002\u00021F\u0011qL\u0019\t\u0003+\u0001L!!\u0019\f\u0003\u000f9{G\u000f[5oOB\u0011QcY\u0005\u0003IZ\u00111!\u00118z\u0011\u001d1W!!AA\u0004\u001d\f!\"\u001a<jI\u0016t7-\u001a\u00132!\r\t\u0003NW\u0005\u0003S\"\u0011!BS:p]\u001aKG\u000e^3s\u0011\u0015YW\u00011\u0001m\u0003\u0011Q7o\u001c8\u0011\u00055$X\"\u00018\u000b\u0005=\u0004\u0018\u0001\u00033bi\u0006\u0014\u0017N\u001c3\u000b\u0005E\u0014\u0018a\u00026bG.\u001cxN\u001c\u0006\u0003g>\n\u0011BZ1ti\u0016\u0014\b0\u001c7\n\u0005Ut'\u0001\u0003&t_:tu\u000eZ3\t\u000b],\u0001\u0019A\u001a\u0002\u0015\u0015D\bO]3tg&|g.A\bd_6\u0004\u0018\u000e\\3Kg>t\u0007+\u0019;i)\tq$\u0010C\u0003x\r\u0001\u00071\u0007")
public class JsonPaths {
    private final LoadingCache<String, Validation<JsonPath>> jsonPathCache;

    private LoadingCache<String, Validation<JsonPath>> jsonPathCache() {
        return this.jsonPathCache;
    }

    public <X> Validation<Iterator<X>> extractAll(JsonNode json, String expression, JsonFilter<X> evidence$1) {
        return this.compileJsonPath(expression).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.query(json).collect(JsonFilter$.MODULE$.apply(evidence$1).filter()));
    }

    public Validation<JsonPath> compileJsonPath(String expression) {
        return (Validation)this.jsonPathCache().get((Object)expression);
    }

    private static final Validation compile$1(String expression) {
        Failure failure;
        Either either = JsonPath$.MODULE$.compile(expression);
        if (either instanceof Left) {
            Left left = (Left)either;
            JPError error = (JPError)left.value();
            failure = package.FailureWrapper$.MODULE$.failure$extension(package$.MODULE$.FailureWrapper(error.reason()));
        } else if (either instanceof Right) {
            Right right = (Right)either;
            JsonPath path = (JsonPath)right.value();
            failure = package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)path));
        } else {
            throw new MatchError((Object)either);
        }
        return failure;
    }

    public JsonPaths(long cacheMaxCapacity) {
        this.jsonPathCache = Cache$.MODULE$.newConcurrentLoadingCache(cacheMaxCapacity, (Function1 & Serializable & scala.Serializable)expression -> JsonPaths.compile$1(expression));
    }
}

