/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats.writer;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.writer.BufferedFileChannelWriter$;
import io.gatling.core.util.Integers;
import io.gatling.core.util.Longs;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005%r!\u0002\t\u0012\u0011\u0003ab!\u0002\u0010\u0012\u0011\u0003y\u0002\"\u0002\u0014\u0002\t\u00039\u0003\"\u0002\u0015\u0002\t\u0003Ic\u0001\u0002\u0010\u0012\u0005-B\u0001\"\u0011\u0003\u0003\u0002\u0003\u0006IA\u0011\u0005\t\u0015\u0012\u0011\t\u0011)A\u0005\u0017\"A\u0011\u000b\u0002B\u0001B\u0003%!\u000bC\u0003'\t\u0011\u0005a\u000bC\u0003[\t\u0011\u00051\fC\u0003`\t\u0011%\u0001\rC\u0003g\t\u0011\u0005q\rC\u0003q\t\u0011\u0005\u0011\u000f\u0003\u0004\u0000\t\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003\u001b!A\u0011AA\b\u0011\u0019\t\u0019\u0002\u0002C!7\u0006I\")\u001e4gKJ,GMR5mK\u000eC\u0017M\u001c8fY^\u0013\u0018\u000e^3s\u0015\t\u00112#\u0001\u0004xe&$XM\u001d\u0006\u0003)U\tQa\u001d;biNT!AF\f\u0002\t\r|'/\u001a\u0006\u00031e\tqaZ1uY&twMC\u0001\u001b\u0003\tIwn\u0001\u0001\u0011\u0005u\tQ\"A\t\u00033\t+hMZ3sK\u00124\u0015\u000e\\3DQ\u0006tg.\u001a7Xe&$XM]\n\u0003\u0003\u0001\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001d\u0003\u0015\t\u0007\u000f\u001d7z)\u0015Q\u0013QCA\r!\tiBa\u0005\u0003\u0005YQ:\u0004CA\u00173\u001b\u0005q#BA\u00181\u0003\u0011a\u0017M\\4\u000b\u0003E\nAA[1wC&\u00111G\f\u0002\u0007\u001f\nTWm\u0019;\u0011\u00055*\u0014B\u0001\u001c/\u00055\tU\u000f^8DY>\u001cX-\u00192mKB\u0011\u0001hP\u0007\u0002s)\u0011!hO\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003yu\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002}\u0005\u00191m\\7\n\u0005\u0001K$!D*ue&\u001cG\u000fT8hO&tw-A\u0004dQ\u0006tg.\u001a7\u0011\u0005\rCU\"\u0001#\u000b\u0005\u00153\u0015\u0001C2iC:tW\r\\:\u000b\u0005\u001d\u0003\u0014a\u00018j_&\u0011\u0011\n\u0012\u0002\f\r&dWm\u00115b]:,G.A\u0004f]\u000e|G-\u001a:\u0011\u00051{U\"A'\u000b\u000593\u0015aB2iCJ\u001cX\r^\u0005\u0003!6\u0013ab\u00115beN,G/\u00128d_\u0012,'/\u0001\u0002cEB\u00111\u000bV\u0007\u0002\r&\u0011QK\u0012\u0002\u000b\u0005f$XMQ;gM\u0016\u0014H\u0003\u0002\u0016X1fCQ!\u0011\u0005A\u0002\tCQA\u0013\u0005A\u0002-CQ!\u0015\u0005A\u0002I\u000bQA\u001a7vg\"$\u0012\u0001\u0018\t\u0003CuK!A\u0018\u0012\u0003\tUs\u0017\u000e^\u0001\u000fK:\u001cXO]3DCB\f7-\u001b;z)\ta\u0016\rC\u0003c\u0015\u0001\u00071-A\u0001j!\t\tC-\u0003\u0002fE\t\u0019\u0011J\u001c;\u0002\u0015]\u0014\u0018\u000e^3CsR,7\u000f\u0006\u0002]Q\")\u0011n\u0003a\u0001U\u0006)!-\u001f;fgB\u0019\u0011e[7\n\u00051\u0014#!B!se\u0006L\bCA\u0011o\u0013\ty'E\u0001\u0003CsR,\u0017aC<sSR,7\u000b\u001e:j]\u001e$\"\u0001\u0018:\t\u000bMd\u0001\u0019\u0001;\u0002\rM$(/\u001b8h!\t)HP\u0004\u0002wuB\u0011qOI\u0007\u0002q*\u0011\u0011pG\u0001\u0007yI|w\u000e\u001e \n\u0005m\u0014\u0013A\u0002)sK\u0012,g-\u0003\u0002~}\n11\u000b\u001e:j]\u001eT!a\u001f\u0012\u0002#]\u0014\u0018\u000e^3Q_NLG/\u001b<f\u0019>tw\rF\u0002]\u0003\u0007Aq!!\u0002\u000e\u0001\u0004\t9!A\u0001m!\r\t\u0013\u0011B\u0005\u0004\u0003\u0017\u0011#\u0001\u0002'p]\u001e\f\u0001c\u001e:ji\u0016\u0004vn]5uSZ,\u0017J\u001c;\u0015\u0007q\u000b\t\u0002C\u0003c\u001d\u0001\u00071-A\u0003dY>\u001cX\r\u0003\u0004\u0002\u0018\r\u0001\r\u0001^\u0001\u0006eVt\u0017\n\u001a\u0005\b\u00037\u0019\u0001\u0019AA\u000f\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B!\u0011qDA\u0013\u001b\t\t\tCC\u0002\u0002$U\taaY8oM&<\u0017\u0002BA\u0014\u0003C\u0011AcR1uY&twmQ8oM&<WO]1uS>t\u0007")
public final class BufferedFileChannelWriter
implements AutoCloseable,
StrictLogging {
    private final FileChannel channel;
    private final CharsetEncoder encoder;
    private final ByteBuffer bb;
    private Logger logger;

    public static BufferedFileChannelWriter apply(String runId, GatlingConfiguration configuration) {
        return BufferedFileChannelWriter$.MODULE$.apply(runId, configuration);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void flush() {
        this.bb.flip();
        while (this.bb.hasRemaining()) {
            this.channel.write(this.bb);
        }
        this.bb.clear();
    }

    private void ensureCapacity(int i) {
        block0: {
            if (this.bb.remaining() >= i) break block0;
            this.flush();
        }
    }

    public void writeBytes(byte[] bytes) {
        this.ensureCapacity(bytes.length);
        this.bb.put(bytes);
    }

    public void writeString(String string) {
        block2: {
            BoxedUnit boxedUnit;
            this.ensureCapacity(string.length() * 4);
            CoderResult coderResult = this.encoder.encode(CharBuffer.wrap(string), this.bb, false);
            if (!coderResult.isOverflow()) break block2;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Buffer overflow, you shouldn't be logging that much data. Truncating.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void writePositiveLong(long l) {
        int stringSize = Longs.positiveLongStringSize(l);
        this.ensureCapacity(stringSize);
        Longs.writePositiveLongString(l, stringSize, this.bb);
    }

    public void writePositiveInt(int i) {
        int stringSize = Integers.positiveIntStringSize(i);
        this.ensureCapacity(stringSize);
        Integers.writePositiveIntString(i, stringSize, this.bb);
    }

    @Override
    public void close() {
        try {
            this.flush();
            this.channel.force(true);
        }
        finally {
            this.channel.close();
        }
    }

    public BufferedFileChannelWriter(FileChannel channel, CharsetEncoder encoder, ByteBuffer bb) {
        this.channel = channel;
        this.encoder = encoder;
        this.bb = bb;
        StrictLogging.$init$((StrictLogging)this);
        Statics.releaseFence();
    }
}

