/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.util;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.config.SslConfiguration;
import io.gatling.http.util.SslContexts;
import io.gatling.http.util.SslContextsFactory$;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.Serializable;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005msAB\f\u0019\u0011\u0003Q\u0002E\u0002\u0004#1!\u0005!d\t\u0005\u0006U\u0005!\t\u0001\f\u0005\b[\u0005\u0011\r\u0011\"\u0003/\u0011\u00199\u0014\u0001)A\u0005_!9\u0001(\u0001b\u0001\n\u0013I\u0004B\u0002#\u0002A\u0003%!HB\u0003#1\u0001aR\t\u0003\u0005Q\u000f\t\u0005\t\u0015!\u0003R\u0011\u0015Qs\u0001\"\u0001Z\u0011\u001davA1A\u0005\nuCa!Y\u0004!\u0002\u0013q\u0006b\u00022\b\u0005\u0004%Ia\u0019\u0005\u0007O\u001e\u0001\u000b\u0011\u00023\t\u0011!<\u0001R1A\u0005\n%Dqa]\u0004C\u0002\u0013%A\u000fC\u0004\u0002\b\u001d\u0001\u000b\u0011B;\t\u0013\u0005%qA1A\u0005\n\u0005-\u0001\u0002CA\f\u000f\u0001\u0006I!!\u0004\t\u0013\u0005eqA1A\u0005\n\u0005m\u0001\u0002CA\u0012\u000f\u0001\u0006I!!\b\t\u000f\u0005\u0015r\u0001\"\u0001\u0002(!9\u00111I\u0004\u0005\n\u0005\u0015\u0013AE*tY\u000e{g\u000e^3yiN4\u0015m\u0019;pefT!!\u0007\u000e\u0002\tU$\u0018\u000e\u001c\u0006\u00037q\tA\u0001\u001b;ua*\u0011QDH\u0001\bO\u0006$H.\u001b8h\u0015\u0005y\u0012AA5p!\t\t\u0013!D\u0001\u0019\u0005I\u00196\u000f\\\"p]R,\u0007\u0010^:GC\u000e$xN]=\u0014\u0005\u0005!\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#AB!osJ+g-\u0001\u0004=S:LGOP\u0002\u0001)\u0005\u0001\u0013A\u0006#fM\u0006,H\u000e^*tYN+7-\u001e:f%\u0006tGm\\7\u0016\u0003=\u0002\"\u0001M\u001b\u000e\u0003ER!AM\u001a\u0002\u0011M,7-\u001e:jifT\u0011\u0001N\u0001\u0005U\u00064\u0018-\u0003\u00027c\ta1+Z2ve\u0016\u0014\u0016M\u001c3p[\u00069B)\u001a4bk2$8k\u001d7TK\u000e,(/\u001a*b]\u0012|W\u000eI\u0001\u0004\u0003BtW#\u0001\u001e\u0011\u0005m\u0012U\"\u0001\u001f\u000b\u0005ur\u0014aA:tY*\u0011q\bQ\u0001\bQ\u0006tG\r\\3s\u0015\t\te$A\u0003oKR$\u00180\u0003\u0002Dy\tI\u0012\t\u001d9mS\u000e\fG/[8o!J|Go\\2pY\u000e{gNZ5h\u0003\u0011\t\u0005O\u001c\u0011\u0014\u0007\u001d!c\t\u0005\u0002H\u001d6\t\u0001J\u0003\u0002J\u0015\u0006a1oY1mC2|wmZ5oO*\u00111\nT\u0001\tif\u0004Xm]1gK*\tQ*A\u0002d_6L!a\u0014%\u0003\u001bM#(/[2u\u0019><w-\u001b8h\u0003%\u00198\u000f\\\"p]\u001aLw\r\u0005\u0002S/6\t1K\u0003\u0002U+\u000611m\u001c8gS\u001eT!A\u0016\u000f\u0002\t\r|'/Z\u0005\u00031N\u0013\u0001cU:m\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0015\u0005i[\u0006CA\u0011\b\u0011\u0015\u0001\u0016\u00021\u0001R\u0003))8/Z(qK:\u001c6\u000f\\\u000b\u0002=B\u0011QeX\u0005\u0003A\u001a\u0012qAQ8pY\u0016\fg.A\u0006vg\u0016|\u0005/\u001a8Tg2\u0004\u0013\u0001G:tYN+7o]5p]RKW.Z8viN+7m\u001c8egV\tA\r\u0005\u0002&K&\u0011aM\n\u0002\u0005\u0019>tw-A\rtg2\u001cVm]:j_:$\u0016.\\3pkR\u001cVmY8oIN\u0004\u0013\u0001\u0007#fM\u0006,H\u000e\u001e&bm\u0006\u001c6\u000f\u001c)be\u0006lW\r^3sgV\t!\u000e\u0005\u0002lc6\tAN\u0003\u0002>[*\u0011an\\\u0001\u0004]\u0016$(\"\u00019\u0002\u000b)\fg/\u0019=\n\u0005Id'!D*T\u0019B\u000b'/Y7fi\u0016\u00148/\u0001\tf]\u0006\u0014G.\u001a3Qe>$xnY8mgV\tQ\u000fE\u0002&mbL!a\u001e\u0014\u0003\u000b\u0005\u0013(/Y=\u0011\u0007e\f\tA\u0004\u0002{}B\u00111PJ\u0007\u0002y*\u0011QpK\u0001\u0007yI|w\u000e\u001e \n\u0005}4\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0004\u0005\u0015!AB*ue&twM\u0003\u0002\u0000M\u0005\tRM\\1cY\u0016$\u0007K]8u_\u000e|Gn\u001d\u0011\u0002'\u0015t\u0017M\u00197fI\u000eK\u0007\u000f[3s'VLG/Z:\u0016\u0005\u00055\u0001#BA\b\u0003'AXBAA\t\u0015\tI2'\u0003\u0003\u0002\u0016\u0005E!\u0001\u0002'jgR\fA#\u001a8bE2,GmQ5qQ\u0016\u00148+^5uKN\u0004\u0013aC:tYB\u0013xN^5eKJ,\"!!\b\u0011\u0007m\ny\"C\u0002\u0002\"q\u00121bU:m!J|g/\u001b3fe\u0006a1o\u001d7Qe>4\u0018\u000eZ3sA\u0005qa.Z<Tg2\u001cuN\u001c;fqR\u001cHCBA\u0015\u0003_\t\u0019\u0004E\u0002\"\u0003WI1!!\f\u0019\u0005-\u00196\u000f\\\"p]R,\u0007\u0010^:\t\r\u0005ER\u00031\u0001_\u00031AG\u000f\u001e93\u000b:\f'\r\\3e\u0011\u001d\t)$\u0006a\u0001\u0003o\t\u0001\u0004]3s+N,'oS3z\u001b\u0006t\u0017mZ3s\r\u0006\u001cGo\u001c:z!\u0015)\u0013\u0011HA\u001f\u0013\r\tYD\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007-\fy$C\u0002\u0002B1\u0014\u0011cS3z\u001b\u0006t\u0017mZ3s\r\u0006\u001cGo\u001c:z\u0003AqWm\u001e&eWN\u001bHnQ8oi\u0016DH\u000f\u0006\u0004\u0002H\u00055\u0013q\u000b\t\u0004w\u0005%\u0013bAA&y\tQ1k\u001d7D_:$X\r\u001f;\t\u000f\u0005=c\u00031\u0001\u0002R\u0005i!\u000eZ6Tg2\u001cuN\u001c;fqR\u00042a[A*\u0013\r\t)\u0006\u001c\u0002\u000b'Nc5i\u001c8uKb$\bBBA--\u0001\u0007!(A\u0002ba:\u0004")
public class SslContextsFactory
implements StrictLogging {
    private SSLParameters DefaultJavaSslParameters;
    private final SslConfiguration sslConfig;
    private final boolean useOpenSsl;
    private final long sslSessionTimeoutSeconds;
    private final String[] enabledProtocols;
    private final List<String> enabledCipherSuites;
    private final SslProvider sslProvider;
    private Logger logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private boolean useOpenSsl() {
        return this.useOpenSsl;
    }

    private long sslSessionTimeoutSeconds() {
        return this.sslSessionTimeoutSeconds;
    }

    private SSLParameters DefaultJavaSslParameters$lzycompute() {
        SslContextsFactory sslContextsFactory = this;
        synchronized (sslContextsFactory) {
            if (!this.bitmap$0) {
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(null, null, null);
                this.DefaultJavaSslParameters = context.getDefaultSSLParameters();
                this.bitmap$0 = true;
            }
        }
        return this.DefaultJavaSslParameters;
    }

    private SSLParameters DefaultJavaSslParameters() {
        if (!this.bitmap$0) {
            return this.DefaultJavaSslParameters$lzycompute();
        }
        return this.DefaultJavaSslParameters;
    }

    private String[] enabledProtocols() {
        return this.enabledProtocols;
    }

    private List<String> enabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    private SslProvider sslProvider() {
        return this.sslProvider;
    }

    public SslContexts newSslContexts(boolean http2Enabled, Option<KeyManagerFactory> perUserKeyManagerFactory) {
        Option kmf = perUserKeyManagerFactory.orElse((Function0 & Serializable)() -> $this.sslConfig.keyManagerFactory());
        Option tmf = this.sslConfig.trustManagerFactory().orElse((Function0 & Serializable)() -> {
            if ($this.sslConfig.useInsecureTrustManager()) {
                return new Some((Object)InsecureTrustManagerFactory.INSTANCE);
            }
            return None$.MODULE$;
        });
        if (this.useOpenSsl()) {
            SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(this.sslProvider());
            Object object = this.sslConfig.sessionCacheSize() > 0 ? sslContextBuilder.sessionCacheSize((long)this.sslConfig.sessionCacheSize()) : BoxedUnit.UNIT;
            Object object2 = this.sslConfig.sessionTimeout().$greater((Object)Duration$.MODULE$.Zero()) ? sslContextBuilder.sessionTimeout(this.sslSessionTimeoutSeconds()) : BoxedUnit.UNIT;
            Object object3 = ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])this.enabledProtocols())) ? sslContextBuilder.protocols(this.enabledProtocols()) : BoxedUnit.UNIT;
            SslContextBuilder sslContextBuilder2 = this.sslConfig.enabledCipherSuites().nonEmpty() ? sslContextBuilder.ciphers(this.enabledCipherSuites()) : sslContextBuilder.ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE_DEFAULTING_TO_SUPPORTED_CIPHERS);
            kmf.foreach((Function1 & Serializable)x$1 -> sslContextBuilder.keyManager(x$1));
            tmf.foreach((Function1 & Serializable)x$1 -> sslContextBuilder.trustManager(x$1));
            return new SslContexts((Function0<Tuple2<SslContext, Option<SslContext>>>)(Function0 & Serializable)() -> {
                SslContext sslContext = sslContextBuilder.build();
                None$ alpnSslContext = http2Enabled ? new Some((Object)sslContextBuilder.applicationProtocolConfig(SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$Apn()).build()) : None$.MODULE$;
                return new Tuple2((Object)sslContext, (Object)alpnSslContext);
            });
        }
        return new SslContexts((Function0<Tuple2<SslContext, Option<SslContext>>>)(Function0 & Serializable)() -> {
            SSLContext jdkSslContext = SSLContext.getInstance("TLS");
            jdkSslContext.init((KeyManager[])kmf.map((Function1 & Serializable)x$1 -> x$1.getKeyManagers()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (TrustManager[])tmf.map((Function1 & Serializable)x$2 -> x$2.getTrustManagers()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$DefaultSslSecureRandom());
            SslContext sslContext = this.newJdkSslContext(jdkSslContext, null);
            None$ alpnSslContext = http2Enabled ? new Some((Object)this.newJdkSslContext(jdkSslContext, SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$Apn())) : None$.MODULE$;
            return new Tuple2((Object)sslContext, (Object)alpnSslContext);
        });
    }

    private SslContext newJdkSslContext(SSLContext jdkSslContext, ApplicationProtocolConfig apn) {
        return new JdkSslContext(jdkSslContext, true, this.enabledCipherSuites().isEmpty() ? null : this.enabledCipherSuites(), (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE_DEFAULTING_TO_SUPPORTED_CIPHERS, apn, ClientAuth.NONE, ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])this.enabledProtocols())) ? this.enabledProtocols() : null, false);
    }

    public SslContextsFactory(SslConfiguration sslConfig) {
        List list;
        String[] stringArray;
        boolean bl;
        this.sslConfig = sslConfig;
        StrictLogging.$init$((StrictLogging)this);
        if (sslConfig.useOpenSsl()) {
            BoxedUnit boxedUnit;
            boolean available = OpenSsl.isAvailable();
            if (!available) {
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("OpenSSL is enabled in the Gatling configuration but it's not available on your architecture.");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = available;
        } else {
            bl = false;
        }
        this.useOpenSsl = bl;
        this.sslSessionTimeoutSeconds = sslConfig.sessionTimeout().toSeconds();
        if (this.useOpenSsl()) {
            stringArray = (String[])sslConfig.enabledProtocols().toArray(ClassTag$.MODULE$.apply(String.class));
        } else {
            Set supportedProtocols = Predef$.MODULE$.wrapRefArray((Object[])this.DefaultJavaSslParameters().getProtocols()).toSet();
            stringArray = this.enabledProtocols = (String[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])sslConfig.enabledProtocols().toArray(ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)supportedProtocols.contains((Object)elem)));
        }
        if (this.useOpenSsl()) {
            list = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)sslConfig.enabledCipherSuites()).asJava();
        } else {
            String[] supportedCipherSuites = this.DefaultJavaSslParameters().getCipherSuites();
            Object object = Predef$.MODULE$.refArrayOps((Object[])supportedCipherSuites);
            list = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)sslConfig.enabledCipherSuites().filter((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.contains$extension(object, (Object)elem)))).asJava();
        }
        this.enabledCipherSuites = list;
        this.sslProvider = this.useOpenSsl() && sslConfig.useOpenSslFinalizers() ? SslProvider.OPENSSL : SslProvider.OPENSSL_REFCNT;
        Statics.releaseFence();
    }
}

