/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.engine.tx;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.CoreComponents;
import io.gatling.core.controller.throttle.Throttler;
import io.gatling.core.session.Session;
import io.gatling.core.util.NameGen;
import io.gatling.http.cache.ContentCacheEntry;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.cache.SslContextSupport$;
import io.gatling.http.client.HttpListener;
import io.gatling.http.client.Request;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.client.util.Pair;
import io.gatling.http.engine.GatlingHttpListener;
import io.gatling.http.engine.HttpEngine;
import io.gatling.http.engine.response.DefaultResponseProcessor;
import io.gatling.http.engine.response.DefaultStatsProcessor;
import io.gatling.http.engine.response.NoopStatsProcessor$;
import io.gatling.http.engine.response.ResourceNextExecutor;
import io.gatling.http.engine.response.ResourceSessionProcessor;
import io.gatling.http.engine.response.ResponseProcessor;
import io.gatling.http.engine.response.RootNextExecutor;
import io.gatling.http.engine.response.RootSessionProcessor;
import io.gatling.http.engine.response.StatsProcessor;
import io.gatling.http.engine.tx.HttpTx;
import io.gatling.http.engine.tx.ResourceTx;
import io.gatling.http.fetch.ResourceAggregator;
import io.gatling.http.fetch.ResourceFetcher;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.response.HttpFailure;
import io.gatling.http.util.SslContexts;
import io.netty.handler.ssl.SslContext;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005d\u0001\u0002\u000b\u0016\u0001\u0001B\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!A1\t\u0001B\u0001B\u0003%A\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011!\t\u0006A!A!\u0002\u0013\u0011\u0006\"\u0002-\u0001\t\u0003I\u0006bB1\u0001\u0005\u0004%IA\u0019\u0005\u0007S\u0002\u0001\u000b\u0011B2\t\u000b)\u0004A\u0011B6\t\u000bi\u0004A\u0011B>\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e!9\u00111\u0004\u0001\u0005\u0002\u0005\u0005\u0002bBA\u000e\u0001\u0011\u0005\u0011Q\u0005\u0005\b\u00037\u0001A\u0011AA\u001b\u0011%\tY\u0003\u0001b\u0001\n\u0013\tY\u0004\u0003\u0005\u0002>\u0001\u0001\u000b\u0011BA\u0017\u0011\u001d\ty\u0004\u0001C\u0005\u0003\u0003Bq!!\u0012\u0001\t\u0013\t9\u0005C\u0004\u0002V\u0001!\t!a\u0016\u0003\u001d!#H\u000f\u001d+y\u000bb,7-\u001e;pe*\u0011acF\u0001\u0003ibT!\u0001G\r\u0002\r\u0015tw-\u001b8f\u0015\tQ2$\u0001\u0003iiR\u0004(B\u0001\u000f\u001e\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011AH\u0001\u0003S>\u001c\u0001a\u0005\u0003\u0001C\u001dz\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g\r\u0005\u0002)[5\t\u0011F\u0003\u0002+W\u0005!Q\u000f^5m\u0015\ta3$\u0001\u0003d_J,\u0017B\u0001\u0018*\u0005\u001dq\u0015-\\3HK:\u0004\"\u0001M\u001c\u000e\u0003ER!AM\u001a\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005Q*\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003Y\n1aY8n\u0013\tA\u0014GA\u0007TiJL7\r\u001e'pO\u001eLgnZ\u0001\u000fG>\u0014XmQ8na>tWM\u001c;t!\tYD(D\u0001,\u0013\ti4F\u0001\bD_J,7i\\7q_:,g\u000e^:\u0002\u0015!$H\u000f]#oO&tW\r\u0005\u0002A\u00036\tq#\u0003\u0002C/\tQ\u0001\n\u001e;q\u000b:<\u0017N\\3\u0002\u0015!$H\u000f]\"bG\",7\u000f\u0005\u0002F\u00116\taI\u0003\u0002H3\u0005)1-Y2iK&\u0011\u0011J\u0012\u0002\u000b\u0011R$\boQ1dQ\u0016\u001c\u0018!\u00063fM\u0006,H\u000e^*uCR\u001c\bK]8dKN\u001cxN\u001d\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d^\t\u0001B]3ta>t7/Z\u0005\u0003!6\u0013Q\u0003R3gCVdGo\u0015;biN\u0004&o\\2fgN|'/\u0001\u0007iiR\u0004\bK]8u_\u000e|G\u000e\u0005\u0002T-6\tAK\u0003\u0002V3\u0005A\u0001O]8u_\u000e|G.\u0003\u0002X)\na\u0001\n\u001e;q!J|Go\\2pY\u00061A(\u001b8jiz\"bA\u0017/^=~\u0003\u0007CA.\u0001\u001b\u0005)\u0002\"B\u001d\u0007\u0001\u0004Q\u0004\"\u0002 \u0007\u0001\u0004y\u0004\"B\"\u0007\u0001\u0004!\u0005\"\u0002&\u0007\u0001\u0004Y\u0005\"B)\u0007\u0001\u0004\u0011\u0016a\u0004:fg>,(oY3GKR\u001c\u0007.\u001a:\u0016\u0003\r\u0004\"\u0001Z4\u000e\u0003\u0015T!AZ\r\u0002\u000b\u0019,Go\u00195\n\u0005!,'a\u0004*fg>,(oY3GKR\u001c\u0007.\u001a:\u0002!I,7o\\;sG\u00164U\r^2iKJ\u0004\u0013\u0001E3yK\u000e,H/Z,ji\"\u001c\u0015m\u00195f)\ta\u0007\u0010\u0006\u0002naB\u0011!E\\\u0005\u0003_\u000e\u0012A!\u00168ji\")\u0011/\u0003a\u0001e\u0006\ta\r\u0005\u0003#gVl\u0017B\u0001;$\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002\\m&\u0011q/\u0006\u0002\u0007\u0011R$\b\u000f\u0016=\t\u000beL\u0001\u0019A;\u0002\r=\u0014\u0018n\u001a+y\u0003U)\u00070Z2vi\u0016DE\u000f\u001e93/&$\bnQ1dQ\u0016$2\u0001`A\f)\tiW\u0010C\u0003r\u0015\u0001\u0007a\u0010\u0005\u0003#g~l\u0007#BA\u0001\u0003#)h\u0002BA\u0002\u0003\u001bqA!!\u0002\u0002\f5\u0011\u0011q\u0001\u0006\u0004\u0003\u0013y\u0012A\u0002\u001fs_>$h(C\u0001%\u0013\r\tyaI\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019\"!\u0006\u0003\u0011%#XM]1cY\u0016T1!a\u0004$\u0011\u0019\tIB\u0003a\u0001\u007f\u00069qN]5h)b\u001c\u0018aB3yK\u000e,H/\u001a\u000b\u0004[\u0006}\u0001\"B=\f\u0001\u0004)HcA7\u0002$!1\u0011\u0011\u0004\u0007A\u0002}$R!\\A\u0014\u0003SAQ!_\u0007A\u0002UDq!a\u000b\u000e\u0001\u0004\ti#\u0001\rsKN\u0004xN\\:f!J|7-Z:t_J4\u0015m\u0019;pef\u0004RAI:v\u0003_\u00012\u0001TA\u0019\u0013\r\t\u0019$\u0014\u0002\u0012%\u0016\u001c\bo\u001c8tKB\u0013xnY3tg>\u0014H#B7\u00028\u0005e\u0002BBA\r\u001d\u0001\u0007q\u0010C\u0004\u0002,9\u0001\r!!\f\u0016\u0005\u00055\u0012!\u0007:fgB|gn]3Qe>\u001cWm]:pe\u001a\u000b7\r^8ss\u0002\n\u0001D\\3x%>|GOU3ta>t7/\u001a)s_\u000e,7o]8s)\u0011\ty#a\u0011\t\u000bY\t\u0002\u0019A;\u000299,wOU3t_V\u00148-\u001a*fgB|gn]3Qe>\u001cWm]:peR1\u0011qFA%\u0003\u0017BQA\u0006\nA\u0002UDq!!\u0014\u0013\u0001\u0004\ty%\u0001\u0006sKN|WO]2f)b\u00042aWA)\u0013\r\t\u0019&\u0006\u0002\u000b%\u0016\u001cx.\u001e:dKRC\u0018AD:uCR\u001c\bK]8dKN\u001cxN\u001d\u000b\u0005\u00033\ny\u0006E\u0002M\u00037J1!!\u0018N\u00059\u0019F/\u0019;t!J|7-Z:t_JDQAF\nA\u0002U\u0004")
public class HttpTxExecutor
implements NameGen,
StrictLogging {
    private final CoreComponents coreComponents;
    private final HttpEngine httpEngine;
    private final HttpCaches httpCaches;
    private final DefaultStatsProcessor defaultStatsProcessor;
    private final HttpProtocol httpProtocol;
    private final ResourceFetcher resourceFetcher;
    private final Function1<HttpTx, ResponseProcessor> responseProcessorFactory;
    private Logger logger;

    public String genName(String base) {
        return NameGen.genName$((NameGen)this, (String)base);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private ResourceFetcher resourceFetcher() {
        return this.resourceFetcher;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void executeWithCache(HttpTx origTx, Function1<HttpTx, BoxedUnit> f) {
        Option<ResourceAggregator> option;
        Option<Object> option2;
        Some some;
        ContentCacheEntry contentCacheEntry;
        Option<Object> option3;
        Some some2;
        ContentCacheEntry contentCacheEntry2;
        HttpTx tx = this.httpCaches.applyPermanentRedirect(origTx);
        Request clientRequest = tx.request().clientRequest();
        Uri uri = clientRequest.getUri();
        Option<ContentCacheEntry> option4 = this.httpCaches.contentCacheEntry(tx.session(), clientRequest);
        boolean bl = None$.MODULE$.equals(option4) ? true : option4 instanceof Some && (contentCacheEntry2 = (ContentCacheEntry)(some2 = (Some)option4).value()) != null && None$.MODULE$.equals(option3 = contentCacheEntry2.expires());
        if (bl) {
            BoxedUnit boxedUnit = (BoxedUnit)f.apply((Object)tx);
            return;
        }
        if (option4 instanceof Some && (contentCacheEntry = (ContentCacheEntry)(some = (Some)option4).value()) != null && (option2 = contentCacheEntry.expires()) instanceof Some) {
            Some some3 = (Some)option2;
            long expire = BoxesRunTime.unboxToLong((Object)some3.value());
            if (this.coreComponents.clock().nowMillis() > expire) {
                HttpTx newTx = tx.copy(this.httpCaches.clearContentCache(tx.session(), clientRequest), tx.copy$default$2(), tx.copy$default$3(), tx.copy$default$4(), tx.copy$default$5());
                BoxedUnit boxedUnit = (BoxedUnit)f.apply((Object)newTx);
                return;
            }
        }
        if ((option = this.resourceFetcher().newResourceAggregatorForCachedPage(tx)) instanceof Some) {
            BoxedUnit boxedUnit;
            Some some4 = (Some)option;
            ResourceAggregator aggregator = (ResourceAggregator)some4.value();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Fetching resources of cached page request={} uri={}: scenario={}, userId={}", new Object[]{tx.request().requestName(), uri, tx.session().scenario(), BoxesRunTime.boxToLong((long)tx.session().userId())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            aggregator.start(tx.session());
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Skipping cached request={} uri={}: scenario={}, userId={}", new Object[]{tx.request().requestName(), uri, tx.session().scenario(), BoxesRunTime.boxToLong((long)tx.session().userId())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Option<ResourceTx> option5 = tx.resourceTx();
            if (option5 instanceof Some) {
                Some some5 = (Some)option5;
                ResourceTx resourceTx = (ResourceTx)some5.value();
                resourceTx.aggregator().onCachedResource(resourceTx, tx);
                BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
            } else {
                tx.next().$bang(tx.session());
                BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void executeHttp2WithCache(Iterable<HttpTx> origTxs, Function1<Iterable<HttpTx>, BoxedUnit> f) {
        ListBuffer cached = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ListBuffer nonCached = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ObjectRef session = ObjectRef.create((Object)((HttpTx)origTxs.head()).session());
        origTxs.foreach((Function1 & Serializable)tx -> {
            Option<Object> option;
            Some some;
            ContentCacheEntry contentCacheEntry;
            HttpTx updatedTx = $this.httpCaches.applyPermanentRedirect((HttpTx)tx);
            Option<ContentCacheEntry> txCacheEntry = $this.httpCaches.contentCacheEntry(updatedTx.session(), updatedTx.request().clientRequest());
            Option<ContentCacheEntry> option2 = txCacheEntry;
            boolean bl = None$.MODULE$.equals(option2) ? true : option2 instanceof Some && (contentCacheEntry = (ContentCacheEntry)(some = (Some)option2).value()) != null && None$.MODULE$.equals(option = contentCacheEntry.expires());
            if (bl) {
                return (ListBuffer)nonCached.$plus$eq((Object)updatedTx);
            }
            if (!(option2 instanceof Some)) return (ListBuffer)cached.$plus$eq((Object)updatedTx);
            Some some2 = (Some)option2;
            ContentCacheEntry contentCacheEntry2 = (ContentCacheEntry)some2.value();
            if (contentCacheEntry2 == null) return (ListBuffer)cached.$plus$eq((Object)updatedTx);
            Option<Object> option3 = contentCacheEntry2.expires();
            if (!(option3 instanceof Some)) return (ListBuffer)cached.$plus$eq((Object)updatedTx);
            Some some3 = (Some)option3;
            long expire = BoxesRunTime.unboxToLong((Object)some3.value());
            if ($this.coreComponents.clock().nowMillis() <= expire) return (ListBuffer)cached.$plus$eq((Object)updatedTx);
            Request requestToClean = updatedTx.request().clientRequest();
            session$1.elem = $this.httpCaches.clearContentCache((Session)session$1.elem, requestToClean);
            return (ListBuffer)nonCached.$plus$eq((Object)updatedTx);
        });
        f.apply(nonCached.map((Function1 & Serializable)x$1 -> x$1.copy((Session)session$1.elem, x$1.copy$default$2(), x$1.copy$default$3(), x$1.copy$default$4(), x$1.copy$default$5())));
        ((IterableOnceOps)cached.map((Function1 & Serializable)x$2 -> x$2.copy((Session)session$1.elem, x$2.copy$default$2(), x$2.copy$default$3(), x$2.copy$default$4(), x$2.copy$default$5()))).foreach((Function1 & Serializable)tx -> {
            HttpTxExecutor.$anonfun$executeHttp2WithCache$4(this, tx);
            return BoxedUnit.UNIT;
        });
    }

    public void execute(HttpTx origTx) {
        this.execute(origTx, this.responseProcessorFactory());
    }

    public void execute(Iterable<HttpTx> origTxs) {
        this.execute(origTxs, this.responseProcessorFactory());
    }

    public void execute(HttpTx origTx, Function1<HttpTx, ResponseProcessor> responseProcessorFactory) {
        this.executeWithCache(origTx, (Function1<HttpTx, BoxedUnit>)(Function1 & Serializable)tx -> {
            HttpTxExecutor.$anonfun$execute$1(this, responseProcessorFactory, tx);
            return BoxedUnit.UNIT;
        });
    }

    public void execute(Iterable<HttpTx> origTxs, Function1<HttpTx, ResponseProcessor> responseProcessorFactory) {
        this.executeHttp2WithCache(origTxs, (Function1<Iterable<HttpTx>, BoxedUnit>)(Function1 & Serializable)txs -> {
            HttpTxExecutor.$anonfun$execute$5(this, responseProcessorFactory, txs);
            return BoxedUnit.UNIT;
        });
    }

    private Function1<HttpTx, ResponseProcessor> responseProcessorFactory() {
        return this.responseProcessorFactory;
    }

    private ResponseProcessor newRootResponseProcessor(HttpTx tx) {
        return new DefaultResponseProcessor(tx, new RootSessionProcessor(tx.silent(), tx.request().clientRequest(), tx.request().requestConfig().checks(), this.httpCaches, this.httpProtocol), this.statsProcessor(tx), new RootNextExecutor(tx, this.resourceFetcher(), this), this.coreComponents.configuration().core().charset());
    }

    private ResponseProcessor newResourceResponseProcessor(HttpTx tx, ResourceTx resourceTx) {
        return new DefaultResponseProcessor(tx.copy(resourceTx.aggregator().currentSession(), tx.copy$default$2(), tx.copy$default$3(), tx.copy$default$4(), tx.copy$default$5()), new ResourceSessionProcessor(tx.silent(), tx.request().clientRequest(), tx.request().requestConfig().checks(), this.httpCaches, this.httpProtocol), this.statsProcessor(tx), new ResourceNextExecutor(tx, resourceTx), this.coreComponents.configuration().core().charset());
    }

    public StatsProcessor statsProcessor(HttpTx tx) {
        return tx.silent() ? NoopStatsProcessor$.MODULE$ : this.defaultStatsProcessor;
    }

    public static final /* synthetic */ void $anonfun$executeHttp2WithCache$4(HttpTxExecutor $this, HttpTx tx) {
        Uri uri = tx.request().clientRequest().getUri();
        Option<ResourceAggregator> option = $this.resourceFetcher().newResourceAggregatorForCachedPage(tx);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            ResourceAggregator aggregator = (ResourceAggregator)some.value();
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug("Fetching resources of cached page request={} uri={}: scenario={}, userId={}", new Object[]{tx.request().requestName(), uri, tx.session().scenario(), BoxesRunTime.boxToLong((long)tx.session().userId())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            aggregator.start(tx.session());
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug("Skipping cached request={} uri={}: scenario={}, userId={}", new Object[]{tx.request().requestName(), uri, tx.session().scenario(), BoxesRunTime.boxToLong((long)tx.session().userId())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Option<ResourceTx> option2 = tx.resourceTx();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                ResourceTx resourceTx = (ResourceTx)some.value();
                resourceTx.aggregator().onCachedResource(resourceTx, tx);
                BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$execute$1(HttpTxExecutor $this, Function1 responseProcessorFactory$1, HttpTx tx) {
        BoxedUnit boxedUnit;
        if (tx.redirectCount() >= tx.request().requestConfig().httpProtocol().responsePart().maxRedirects()) {
            long now = $this.coreComponents.clock().nowMillis();
            ((ResponseProcessor)responseProcessorFactory$1.apply((Object)tx)).onComplete(new HttpFailure(tx.request().clientRequest(), now, now, new StringBuilder(27).append("Too many redirects, max is ").append(tx.request().requestConfig().httpProtocol().responsePart().maxRedirects()).toString()));
            return;
        }
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("Sending request={} uri={}: scenario={}, userId={}", new Object[]{tx.request().requestName(), tx.request().clientRequest().getUri(), tx.session().scenario(), BoxesRunTime.boxToLong((long)tx.session().userId())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Request clientRequest = tx.request().clientRequest();
        long clientId = tx.session().userId();
        boolean shared = tx.request().requestConfig().httpProtocol().enginePart().shareConnections();
        GatlingHttpListener listener = new GatlingHttpListener(tx, $this.coreComponents.clock(), (ResponseProcessor)responseProcessorFactory$1.apply((Object)tx));
        Option<SslContexts> userSslContexts = SslContextSupport$.MODULE$.sslContexts(tx.session());
        SslContext sslContext = (SslContext)userSslContexts.map((Function1 & Serializable)x$3 -> x$3.sslContext()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        SslContext alpnSslContext = (SslContext)userSslContexts.flatMap((Function1 & Serializable)x$4 -> x$4.alpnSslContext()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Option option = $this.coreComponents.throttler();
        if (option instanceof Some) {
            Some some = (Some)option;
            Throttler th = (Throttler)some.value();
            if (tx.request().requestConfig().throttled()) {
                th.throttle(tx.session().scenario(), (Function0)(JFunction0.mcV.sp & Serializable)() -> $this.httpEngine.executeRequest(clientRequest, clientId, shared, tx.session().eventLoop(), listener, sslContext, alpnSslContext));
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                return;
            }
        }
        $this.httpEngine.executeRequest(clientRequest, clientId, shared, tx.session().eventLoop(), listener, sslContext, alpnSslContext);
        BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$execute$6(HttpTxExecutor $this, HttpTx tx) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("Sending request={} uri={} scenario={}, userId={}", new Object[]{tx.request().requestName(), tx.request().clientRequest().getUri(), tx.session().scenario(), BoxesRunTime.boxToLong((long)tx.session().userId())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$execute$5(HttpTxExecutor $this, Function1 responseProcessorFactory$2, Iterable txs) {
        HttpTx headTx = (HttpTx)txs.head();
        txs.foreach((Function1 & Serializable)tx -> {
            HttpTxExecutor.$anonfun$execute$6($this, tx);
            return BoxedUnit.UNIT;
        });
        Iterable requestsAndListeners = (Iterable)txs.map((Function1 & Serializable)tx -> {
            GatlingHttpListener listener = new GatlingHttpListener((HttpTx)tx, $this.coreComponents.clock(), (ResponseProcessor)responseProcessorFactory$2.apply(tx));
            return new Pair((Object)tx.request().clientRequest(), (Object)listener);
        });
        long clientId = headTx.session().userId();
        boolean shared = headTx.request().requestConfig().httpProtocol().enginePart().shareConnections();
        Option<SslContexts> userSslContexts = SslContextSupport$.MODULE$.sslContexts(headTx.session());
        SslContext sslContext = (SslContext)userSslContexts.map((Function1 & Serializable)x$5 -> x$5.sslContext()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        SslContext alpnSslContext = (SslContext)userSslContexts.flatMap((Function1 & Serializable)x$6 -> x$6.alpnSslContext()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Option option = $this.coreComponents.throttler();
        if (option instanceof Some) {
            Some some = (Some)option;
            Throttler th = (Throttler)some.value();
            if (((HttpTx)txs.head()).request().requestConfig().throttled()) {
                th.throttle(headTx.session().scenario(), (Function0)(JFunction0.mcV.sp & Serializable)() -> $this.httpEngine.executeHttp2Requests((Iterable<Pair<Request, HttpListener>>)requestsAndListeners, clientId, shared, headTx.session().eventLoop(), sslContext, alpnSslContext));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        $this.httpEngine.executeHttp2Requests((Iterable<Pair<Request, HttpListener>>)requestsAndListeners, clientId, shared, headTx.session().eventLoop(), sslContext, alpnSslContext);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public HttpTxExecutor(CoreComponents coreComponents, HttpEngine httpEngine, HttpCaches httpCaches, DefaultStatsProcessor defaultStatsProcessor, HttpProtocol httpProtocol) {
        this.coreComponents = coreComponents;
        this.httpEngine = httpEngine;
        this.httpCaches = httpCaches;
        this.defaultStatsProcessor = defaultStatsProcessor;
        this.httpProtocol = httpProtocol;
        NameGen.$init$((NameGen)this);
        StrictLogging.$init$((StrictLogging)this);
        this.resourceFetcher = new ResourceFetcher(coreComponents, httpCaches, httpProtocol, this);
        this.responseProcessorFactory = (Function1 & Serializable)tx -> {
            ResponseProcessor responseProcessor;
            Option<ResourceTx> option = tx.resourceTx();
            if (option instanceof Some) {
                Some some = (Some)option;
                ResourceTx resourceTx = (ResourceTx)some.value();
                responseProcessor = this.newResourceResponseProcessor((HttpTx)tx, resourceTx);
            } else {
                responseProcessor = this.newRootResponseProcessor((HttpTx)tx);
            }
            return responseProcessor;
        };
        Statics.releaseFence();
    }
}

