/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.utils;

import io.github.ascopes.protobufmavenplugin.utils.FileUtils;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.Scanner;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public final class HostSystem {
    private static final Logger log = LoggerFactory.getLogger(HostSystem.class);
    private final String operatingSystem;
    private final String cpuArchitecture;
    private final String pathSeparator;
    private final Path workingDirectory;
    private final Path javaHome;
    private final String javaVendor;
    private final List<Path> path;
    private final SortedSet<String> pathExt;

    @Inject
    public HostSystem() {
        this(System.getProperties(), System::getenv);
    }

    public HostSystem(Properties properties, Function<String, String> envProvider) {
        this.operatingSystem = properties.getProperty("os.name", "");
        this.cpuArchitecture = properties.getProperty("os.arch", "");
        this.pathSeparator = properties.getProperty("path.separator", "");
        this.workingDirectory = FileUtils.normalize(Path.of("", new String[0]));
        this.javaHome = FileUtils.normalize(Path.of(properties.getProperty("java.home", ""), new String[0]));
        this.javaVendor = properties.getProperty("java.vendor", "");
        this.path = HostSystem.parsePath(Objects.requireNonNullElse(envProvider.apply("PATH"), ""), this.pathSeparator);
        this.pathExt = HostSystem.parsePathExt(Objects.requireNonNullElse(envProvider.apply("PATHEXT"), ""), this.pathSeparator);
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public String getCpuArchitecture() {
        return this.cpuArchitecture;
    }

    public boolean isProbablyLinux() {
        return this.operatingSystem.toLowerCase(Locale.ROOT).startsWith("linux");
    }

    public boolean isProbablyTermux() {
        return this.javaVendor.equalsIgnoreCase("termux");
    }

    public boolean isProbablyMacOs() {
        return this.operatingSystem.toLowerCase(Locale.ROOT).startsWith("mac os");
    }

    public boolean isProbablyWindows() {
        return this.operatingSystem.toLowerCase(Locale.ROOT).startsWith("windows");
    }

    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    public Path getJavaExecutablePath() {
        return this.javaHome.resolve("bin").resolve(this.isProbablyWindows() ? "java.exe" : "java");
    }

    public List<Path> getSystemPath() {
        return this.path;
    }

    public String getPathSeparator() {
        return this.pathSeparator;
    }

    public SortedSet<String> getSystemPathExtensions() {
        return this.pathExt;
    }

    private static List<Path> parsePath(String rawPath, String pathSeparator) {
        return HostSystem.tokenizeFilePath(rawPath, pathSeparator, paths -> paths.flatMap(HostSystem.tryParseSystemFilePath()).distinct().filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toUnmodifiableList()));
    }

    private static SortedSet<String> parsePathExt(String rawPathExt, String pathSeparator) {
        return HostSystem.tokenizeFilePath(rawPathExt, pathSeparator, extensions -> extensions.map(String::toLowerCase).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet(String::compareToIgnoreCase)), Collections::unmodifiableSortedSet)));
    }

    private static <T> T tokenizeFilePath(String rawValue, String separator, Function<Stream<String>, T> mapper) {
        String separatorRegex = Pattern.quote(separator);
        try (Scanner scanner = new Scanner(rawValue).useDelimiter(separatorRegex);){
            Stream<String> stream = scanner.tokens().map(String::trim).filter(Predicate.not(String::isBlank));
            T t = mapper.apply(stream);
            return t;
        }
    }

    private static Function<String, Stream<Path>> tryParseSystemFilePath() {
        return path -> Stream.of(path).map(String::trim).filter(Predicate.not(String::isBlank)).map(trimmedPath -> {
            try {
                return Path.of(trimmedPath, new String[0]);
            }
            catch (InvalidPathException ex) {
                log.warn("Ignoring path {} in $PATH environment variable. Please check your system settings!", trimmedPath, (Object)ex);
                return null;
            }
        }).filter(Objects::nonNull).map(FileUtils::normalize);
    }
}

