/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.dependencies.aether;

import io.github.ascopes.protobufmavenplugin.dependencies.aether.ProtobufMavenPluginRepositorySession;
import io.github.ascopes.protobufmavenplugin.utils.ResolutionException;
import io.github.ascopes.protobufmavenplugin.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.filter.ScopeDependencyFilter;
import org.eclipse.sisu.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="Wraps Eclipse Aether to provide dependency and artifact resolution capabilities")
@MojoExecutionScoped
@Named
final class AetherResolver {
    private static final Logger log = LoggerFactory.getLogger(AetherResolver.class);
    private final RepositorySystem repositorySystem;
    private final ProtobufMavenPluginRepositorySession repositorySystemSession;
    private final List<RemoteRepository> remoteRepositories;

    @Inject
    AetherResolver(RepositorySystem repositorySystem, MavenSession mavenSession, ProtobufMavenPluginRepositorySession repositorySystemSession) {
        this.repositorySystem = repositorySystem;
        this.repositorySystemSession = repositorySystemSession;
        this.remoteRepositories = mavenSession.getCurrentProject().getRemoteProjectRepositories();
    }

    Artifact resolveRequiredArtifact(Artifact artifact) throws ResolutionException {
        ArtifactResult result;
        log.info("Resolving artifact \"{}\"", (Object)artifact);
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact(artifact);
        request.setRepositories(this.remoteRepositories);
        try {
            result = this.repositorySystem.resolveArtifact((RepositorySystemSession)this.repositorySystemSession, request);
        }
        catch (ArtifactResolutionException ex) {
            log.debug("Discarding internal exception while resolving \"{}\"", (Object)artifact, (Object)ex);
            result = ex.getResult();
        }
        if (result.isMissing()) {
            throw this.mapExceptions("Failed to resolve artifact \"" + String.valueOf(artifact) + "\"", result.getExceptions());
        }
        this.reportWarnings(result.getExceptions());
        return Objects.requireNonNull(result.getArtifact(), () -> "No result was returned by Aether while resolving artifact \"" + String.valueOf(artifact) + "\"");
    }

    Collection<Artifact> resolveDependencies(List<Dependency> dependencies, Set<String> allowedDependencyScopes) throws ResolutionException {
        DependencyResult dependencyResult;
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setDependencies(dependencies);
        collectRequest.setRepositories(this.remoteRepositories);
        DependencyRequest dependencyRequest = new DependencyRequest();
        dependencyRequest.setCollectRequest(collectRequest);
        ScopeDependencyFilter filter = new ScopeDependencyFilter(allowedDependencyScopes, List.of());
        dependencyRequest.setFilter((DependencyFilter)filter);
        log.debug("Resolving {} with {} {} - {}", new Object[]{StringUtils.pluralize(dependencies.size(), "dependency", "dependencies"), StringUtils.pluralize(allowedDependencyScopes.size(), "scope", "scopes"), allowedDependencyScopes, dependencies});
        try {
            dependencyResult = this.repositorySystem.resolveDependencies((RepositorySystemSession)this.repositorySystemSession, dependencyRequest);
        }
        catch (DependencyResolutionException ex) {
            log.debug("Discarding internal exception while resolving {}", dependencies, (Object)ex);
            dependencyResult = ex.getResult();
        }
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        ArrayList exceptions = new ArrayList(dependencyResult.getCollectExceptions());
        for (ArtifactResult artifactResult : dependencyResult.getArtifactResults()) {
            Artifact artifact = artifactResult.getArtifact();
            if (artifactResult.isResolved() && artifact != null) {
                log.debug("Resolution of dependencies returned artifact \"{}\"", (Object)artifact);
                artifacts.add(artifact);
            }
            if (artifactResult.isMissing()) {
                log.debug("Could not find artifact \"{}\" during dependency resolution", (Object)artifact);
            }
            exceptions.addAll(artifactResult.getExceptions());
        }
        this.reportWarnings(exceptions);
        return Collections.unmodifiableList(artifacts);
    }

    private ResolutionException mapExceptions(String message, Collection<Exception> causes) {
        Iterator<Exception> causeIterator = causes.iterator();
        Exception cause = causeIterator.next();
        ResolutionException exception = new ResolutionException(message + " - resolution failed with " + StringUtils.pluralize(causes.size(), "error: ", "errors - first was: ") + cause.getMessage(), cause);
        causeIterator.forEachRemaining(exception::addSuppressed);
        return exception;
    }

    private void reportWarnings(Iterable<? extends Exception> exceptions) {
        exceptions.forEach(exception -> log.debug("Dependency resolution warning was reported. This might be okay, or it could indicate a further issue - {}: {}", new Object[]{exception.getClass().getName(), exception.getMessage(), exception}));
    }
}

