/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class ArgumentFileBuilder {
    private final List<String> arguments = new ArrayList<String>();

    public ArgumentFileBuilder add(Object argument) {
        this.arguments.add(argument.toString());
        return this;
    }

    public ArgumentFileBuilder addIfTrue(boolean condition, Supplier<String> content) {
        if (condition) {
            this.add(content.get());
        }
        return this;
    }

    public ArgumentFileBuilder apply(Consumer<ArgumentFileBuilder> operator) {
        operator.accept(this);
        return this;
    }

    public <T> ArgumentFileBuilder applyForEach(Iterable<T> items, BiConsumer<ArgumentFileBuilder, T> operator) {
        for (Object item : items) {
            this.apply(self -> operator.accept((ArgumentFileBuilder)self, item));
        }
        return this;
    }

    public void writeToProtocArgumentFile(Appendable appendable) throws IOException {
        for (String argument : this.arguments) {
            appendable.append(argument).append("\n");
        }
    }

    public void writeToJavaArgumentFile(Appendable appendable) throws IOException {
        for (String argument : this.arguments) {
            if (argument.chars().noneMatch(c -> " \n\r\t'\"".indexOf(c) >= 0)) {
                appendable.append(argument).append("\n");
                continue;
            }
            appendable.append('\"');
            block9: for (int i = 0; i < argument.length(); ++i) {
                char nextChar = argument.charAt(i);
                switch (nextChar) {
                    case '\"': {
                        appendable.append("\\\"");
                        continue block9;
                    }
                    case '\'': {
                        appendable.append("\\'");
                        continue block9;
                    }
                    case '\\': {
                        appendable.append("\\\\");
                        continue block9;
                    }
                    case '\n': {
                        appendable.append("\\n");
                        continue block9;
                    }
                    case '\r': {
                        appendable.append("\\r");
                        continue block9;
                    }
                    case '\t': {
                        appendable.append("\\t");
                        continue block9;
                    }
                    default: {
                        appendable.append(nextChar);
                    }
                }
            }
            appendable.append("\"\n");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String argument : this.arguments) {
            sb.append(argument).append("\n");
        }
        return sb.toString().trim();
    }
}

