/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie;

import io.github.linpeilie.AbstractCachedConverterFactory;
import io.github.linpeilie.BaseMapMapper;
import io.github.linpeilie.BaseMapper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.mapstruct.factory.Mappers;

public class DefaultConverterFactory
extends AbstractCachedConverterFactory {
    private static final Map<String, Class<?>> baseMappers = new HashMap();
    private static final Map<String, Class<?>> baseMapMappers = new HashMap();

    public DefaultConverterFactory() {
        this.loadMappers();
    }

    private void loadMappers() {
        Enumeration<URL> resources;
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            resources = classLoader.getResources("");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ArrayList classes = new ArrayList();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            if (!url.getProtocol().equals("file")) continue;
            this.loadClasses(null, url.getPath(), classes, classLoader);
        }
        classes.forEach(clazz -> {
            List<Type> baseMapMapperGenericTypes;
            boolean isBaseMapMapperImplemented;
            List<Type> baseMapperGenericTypes;
            boolean isBaseMapperImplemented = this.isInterfaceImplemented((Class<?>)clazz, BaseMapper.class);
            if (isBaseMapperImplemented && (baseMapperGenericTypes = this.getInterfaceGenericType((Class<?>)clazz, BaseMapper.class)).size() == 2) {
                Type source = baseMapperGenericTypes.get(0);
                Type target = baseMapperGenericTypes.get(1);
                baseMappers.put(this.getMapperName(source.getTypeName(), target.getTypeName()), (Class<?>)clazz);
            }
            if ((isBaseMapMapperImplemented = this.isInterfaceImplemented((Class<?>)clazz, BaseMapMapper.class)) && (baseMapMapperGenericTypes = this.getInterfaceGenericType((Class<?>)clazz, BaseMapMapper.class)).size() == 1) {
                Type source = baseMapMapperGenericTypes.get(0);
                baseMapMappers.put(source.getTypeName(), (Class<?>)clazz);
            }
        });
    }

    private String getMapperName(String sourceQualifiedName, String targetQualifiedName) {
        return sourceQualifiedName.replaceAll("\\.", "_") + "To_" + targetQualifiedName.replaceAll("\\.", "_");
    }

    private boolean isInterfaceImplemented(Class<?> clazz, Class<?> interfaceClass) {
        List<Class<?>> interfaces = Arrays.asList(clazz.getInterfaces());
        return interfaces.contains(interfaceClass);
    }

    private List<Type> getInterfaceGenericType(Class<?> clazz, Class<?> interfaceClass) {
        Type[] genericInterfaces;
        for (Type genericInterface : genericInterfaces = clazz.getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            if (!(genericInterface instanceof ParameterizedType) || !(parameterizedType = (ParameterizedType)genericInterface).getRawType().equals(interfaceClass)) continue;
            return Arrays.asList(parameterizedType.getActualTypeArguments());
        }
        return Collections.emptyList();
    }

    private void loadClasses(String root, String path, List<Class<?>> classes, ClassLoader classLoader) {
        File file = new File(path);
        if (root == null) {
            root = file.getPath();
        }
        if (file.isFile()) {
            if (!file.getName().endsWith(".class")) {
                return;
            }
            try {
                String classPath = file.getPath();
                String className = classPath.substring(root.length() + 1, classPath.length() - 6).replaceAll(Matcher.quoteReplacement(File.separator), ".");
                classes.add(classLoader.loadClass(className));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            File[] files = file.listFiles();
            if (files == null) {
                return;
            }
            for (File f : files) {
                this.loadClasses(root, f.getPath(), classes, classLoader);
            }
        }
    }

    @Override
    public <S, T> BaseMapper<S, T> findMapper(Class<S> sourceType, Class<T> targetType) {
        String mapperClassName = this.getMapperName(sourceType.getName(), targetType.getName());
        Class<?> baseMapperClass = baseMappers.get(mapperClassName);
        if (baseMapperClass == null) {
            return null;
        }
        return (BaseMapper)Mappers.getMapper(baseMapperClass);
    }

    @Override
    protected <S> BaseMapMapper findMapMapper(Class<?> source) {
        Class<?> mapMapperClass = baseMapMappers.get(source.getName());
        if (mapMapperClass == null) {
            return null;
        }
        return (BaseMapMapper)Mappers.getMapper(mapMapperClass);
    }
}

