/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer.internal;

import io.github.resilience4j.core.lang.NonNull;
import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.micrometer.Timer;
import io.github.resilience4j.micrometer.TimerConfig;
import io.github.resilience4j.micrometer.event.TimerEvent;
import io.github.resilience4j.micrometer.event.TimerOnFailureEvent;
import io.github.resilience4j.micrometer.event.TimerOnStartEvent;
import io.github.resilience4j.micrometer.event.TimerOnSuccessEvent;
import io.github.resilience4j.micrometer.internal.TimerEventProcessor;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.logging.LoggingMeterRegistry;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerImpl
implements Timer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimerImpl.class);
    private final String name;
    private final MeterRegistry registry;
    private final TimerConfig timerConfig;
    private final Map<String, String> tags;
    private final List<Tag> parsedTags;
    private final TimerEventProcessor eventProcessor;

    public TimerImpl(@NonNull String name, @Nullable MeterRegistry registry, @NonNull TimerConfig timerConfig, @NonNull Map<String, String> tags) {
        this.name = Objects.requireNonNull(name, "Name must not be null");
        if (registry != null) {
            this.registry = registry;
        } else {
            LOGGER.warn("No meter registry provided to '{}' timer. Will use the logging meter registry", (Object)name);
            this.registry = new LoggingMeterRegistry();
        }
        this.timerConfig = Objects.requireNonNull(timerConfig, "Timer config must not be null");
        this.tags = Map.copyOf(Objects.requireNonNull(tags, "Tags must not be null"));
        this.parsedTags = this.tags.entrySet().stream().map(tagsEntry -> Tag.of((String)((String)tagsEntry.getKey()), (String)((String)tagsEntry.getValue()))).collect(Collectors.toList());
        this.eventProcessor = new TimerEventProcessor();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TimerConfig getTimerConfig() {
        return this.timerConfig;
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    public Timer.Context createContext() {
        return new ContextImpl(this.name, this.registry, this.parsedTags, this.timerConfig, this.eventProcessor);
    }

    @Override
    public Timer.EventPublisher getEventPublisher() {
        return this.eventProcessor;
    }

    public static class ContextImpl
    implements Timer.Context {
        private static final String FAILURE_TAG = "failure";
        private static final String KIND_FAILED = "failed";
        private static final String KIND_SUCCESSFUL = "successful";
        private static final Logger LOGGER = LoggerFactory.getLogger(ContextImpl.class);
        private final String name;
        private final MeterRegistry registry;
        private final List<Tag> tags;
        private final TimerConfig timerConfig;
        private final TimerEventProcessor eventProcessor;
        private final long start;

        public ContextImpl(String name, MeterRegistry registry, List<Tag> tags, TimerConfig timerConfig, TimerEventProcessor eventProcessor) {
            this.name = name;
            this.registry = registry;
            this.tags = tags;
            this.timerConfig = timerConfig;
            this.eventProcessor = eventProcessor;
            this.start = System.nanoTime();
            if (eventProcessor.hasConsumers()) {
                this.publishEvent(new TimerOnStartEvent(name));
            }
        }

        @Override
        public void onSuccess() {
            this.recordCall(KIND_SUCCESSFUL, null, duration -> new TimerOnSuccessEvent(this.name, (Duration)duration));
        }

        @Override
        public void onFailure(Throwable throwable) {
            this.recordCall(KIND_FAILED, throwable, duration -> new TimerOnFailureEvent(this.name, (Duration)duration));
        }

        private void recordCall(String resultKind, @Nullable Throwable throwable, Function<Duration, TimerEvent> eventCreator) {
            Duration duration = Duration.ofNanos(System.nanoTime() - this.start);
            Timer.Builder calls = io.micrometer.core.instrument.Timer.builder((String)this.timerConfig.getMetricNames()).description("Timed decorated operation calls").tag("name", this.name).tag("kind", resultKind);
            if (throwable != null) {
                calls.tag(FAILURE_TAG, this.timerConfig.getOnFailureTagResolver().apply(throwable));
            }
            calls.tags(this.tags).register(this.registry).record(duration);
            if (this.eventProcessor.hasConsumers()) {
                this.publishEvent(eventCreator.apply(duration));
            }
        }

        private void publishEvent(TimerEvent event) {
            try {
                this.eventProcessor.consumeEvent(event);
            }
            catch (RuntimeException e) {
                LOGGER.warn("Failed to handle event {}", (Object)event.getEventType(), (Object)e);
            }
        }
    }
}

