/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.data2;

import com.logviewer.data2.LogReader;
import com.logviewer.data2.LogRecord;
import java.util.function.BiFunction;
import org.springframework.lang.NonNull;

public class CompaundLogReader
extends LogReader {
    private final LogReader[] readers;
    private final BiFunction<LogRecord, Integer, LogRecord> transformer;
    private int activeReader = -1;

    public CompaundLogReader(@NonNull LogReader[] readers, @NonNull BiFunction<LogRecord, Integer, LogRecord> transformer) {
        this.transformer = transformer;
        if (readers.length == 0) {
            throw new IllegalArgumentException();
        }
        this.readers = readers;
    }

    @Override
    public boolean parseRecord(byte[] data, int offset, int length, long start, long end) {
        this.activeReader = 0;
        while (this.activeReader < this.readers.length) {
            if (this.readers[this.activeReader].parseRecord(data, offset, length, start, end)) {
                return true;
            }
            ++this.activeReader;
        }
        this.activeReader = -1;
        return false;
    }

    @Override
    public boolean canAppendTail() {
        return this.readers[this.activeReader].canAppendTail();
    }

    @Override
    public void appendTail(byte[] data, int offset, int length, long realLength) {
        this.readers[this.activeReader].appendTail(data, offset, length, realLength);
    }

    @Override
    public void clear() {
        if (this.activeReader >= 0) {
            this.readers[this.activeReader].clear();
            this.activeReader = -1;
        }
    }

    @Override
    public boolean hasParsedRecord() {
        if (this.activeReader >= 0) {
            return this.readers[this.activeReader].hasParsedRecord();
        }
        return false;
    }

    @Override
    public LogRecord buildRecord() {
        LogRecord res = this.readers[this.activeReader].buildRecord();
        res = this.transformer.apply(res, this.activeReader);
        this.activeReader = -1;
        return res;
    }
}

