/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.data2;

import com.logviewer.utils.Destroyer;
import com.logviewer.utils.Pair;
import com.logviewer.utils.RuntimeInterruptedException;
import com.logviewer.utils.Utils;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.lang.NonNull;

public class FileWatcherService
implements DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(FileWatcherService.class);
    static final String THREAD_NAME = "logviewer-file-watcher-thread";
    private Thread watcherThread;
    private WatchService watchService;
    private final Map<Path, Pair<WatchKey, List<WatcherDestroyer>>> listeners = new HashMap<Path, Pair<WatchKey, List<WatcherDestroyer>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destroyer watchDirectory(@NonNull Path dir, @NonNull Consumer<List<Path>> listener) throws IOException {
        assert (dir.isAbsolute());
        if (Files.exists(dir, new LinkOption[0]) && !Files.isDirectory(dir, new LinkOption[0])) {
            throw new IllegalArgumentException("path must be a directory: " + dir);
        }
        FileWatcherService fileWatcherService = this;
        synchronized (fileWatcherService) {
            Pair<WatchKey, List<WatcherDestroyer>> pair;
            if (this.watchService == null) {
                this.watchService = dir.getFileSystem().newWatchService();
            }
            if ((pair = this.listeners.get(dir)) == null) {
                WatchKey key = dir.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
                pair = Pair.of(key, new ArrayList());
                this.listeners.put(dir, pair);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Started watching {}", (Object)dir);
                }
            }
            WatcherDestroyer closer = new WatcherDestroyer(dir, listener);
            pair.getSecond().add(closer);
            if (this.watcherThread == null) {
                this.watcherThread = new Thread(this::doWatch, THREAD_NAME);
                this.watcherThread.start();
            }
            return closer;
        }
    }

    public synchronized List<Path> watchedDirectories() {
        return new ArrayList<Path>(this.listeners.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWatch() {
        try {
            while (true) {
                ArrayList listeners;
                WatchKey key;
                if (!(key = this.watchService.take()).isValid()) {
                    continue;
                }
                ArrayList<Path> paths = new ArrayList<Path>();
                Path dir = (Path)key.watchable();
                for (WatchEvent<?> event : key.pollEvents()) {
                    paths.add(dir.resolve((Path)event.context()));
                }
                Map<Path, Pair<WatchKey, List<WatcherDestroyer>>> map = this.listeners;
                synchronized (map) {
                    Pair<WatchKey, List<WatcherDestroyer>> pair = this.listeners.get(dir);
                    if (pair == null) {
                        LOG.error("Unregistered path: {}", (Object)dir);
                        key.cancel();
                        continue;
                    }
                    listeners = new ArrayList(pair.getSecond());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Listeners invoked for {}", (Object)dir);
                }
                for (WatcherDestroyer watcherDestroyer : listeners) {
                    try {
                        watcherDestroyer.listener.accept(paths);
                    }
                    catch (Throwable e) {
                        if (Thread.currentThread().isInterrupted()) break;
                        LOG.error("Failed to invoke listener for dir: {}", (Object)dir, (Object)e);
                    }
                }
                key.reset();
            }
        }
        catch (InterruptedException | ClosedWatchServiceException exception) {
            return;
        }
    }

    public void destroy() {
        if (this.watchService != null) {
            Utils.closeQuietly(this.watchService);
            this.watchService = null;
        }
        if (this.watcherThread != null) {
            this.watcherThread.interrupt();
            try {
                this.watcherThread.join(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeInterruptedException(e);
            }
        }
    }

    private class WatcherDestroyer
    implements Destroyer {
        private final Path dir;
        private final Consumer<List<Path>> listener;

        WatcherDestroyer(Path dir, Consumer<List<Path>> listener) {
            this.dir = dir;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            FileWatcherService fileWatcherService = FileWatcherService.this;
            synchronized (fileWatcherService) {
                Pair p = (Pair)FileWatcherService.this.listeners.get(this.dir);
                if (p == null) {
                    return;
                }
                ((List)p.getSecond()).remove(this);
                if (((List)p.getSecond()).isEmpty()) {
                    ((WatchKey)p.getFirst()).cancel();
                    FileWatcherService.this.listeners.remove(this.dir);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Stopped watching {}", (Object)this.dir);
                    }
                    if (FileWatcherService.this.listeners.isEmpty() && FileWatcherService.this.watcherThread != null) {
                        FileWatcherService.this.watcherThread.interrupt();
                        FileWatcherService.this.watcherThread = null;
                    }
                }
            }
        }
    }
}

