/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.data2;

import com.logviewer.data2.LogReader;
import java.nio.charset.Charset;
import java.util.Locale;
import org.springframework.core.env.Environment;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public interface LogFormat {
    public LogReader createReader();

    public FieldDescriptor[] getFields();

    default public int getFieldIndexByName(@NonNull String fieldName) {
        FieldDescriptor[] fields = this.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].name().equals(fieldName)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public Charset getCharset();

    @Nullable
    public Locale getLocale();

    public boolean hasFullDate();

    public void validate() throws IllegalArgumentException;

    public String getHumanReadableString();

    default public void loadGlobalConfig(@NonNull Environment env) {
    }

    public static interface FieldDescriptor {
        public static final FieldDescriptor[] EMPTY_ARRAY = new FieldDescriptor[0];

        @NonNull
        public String name();

        @Nullable
        public String type();
    }
}

