/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.data2;

import com.logviewer.api.LvFileAccessManager;
import com.logviewer.api.LvFormatRecognizer;
import com.logviewer.data2.FileWatcherService;
import com.logviewer.data2.GetFormatAndIdTask;
import com.logviewer.data2.Log;
import com.logviewer.data2.LogFormat;
import com.logviewer.data2.LogPath;
import com.logviewer.data2.LogView;
import com.logviewer.data2.RemoteLogChangeListenerService;
import com.logviewer.data2.net.NotConnectedLogView;
import com.logviewer.data2.net.RemoteLog;
import com.logviewer.data2.net.RemoteNodeService;
import com.logviewer.formats.LvDefaultFormatDetector;
import com.logviewer.formats.SimpleLogFormat;
import com.logviewer.utils.LvGsonUtils;
import com.logviewer.utils.LvTimer;
import com.logviewer.utils.Pair;
import com.logviewer.utils.RuntimeInterruptedException;
import com.logviewer.utils.Utils;
import com.logviewer.utils.Wrappers;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class LogService
implements InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(LogService.class);
    public static final LogFormat DEFAULT_FORMAT = new SimpleLogFormat(Charset.defaultCharset());
    private final Map<Pair<Path, Long>, Log> logs = new ConcurrentHashMap<Pair<Path, Long>, Log>();
    private ExecutorService executor;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private FileWatcherService fileWatcherService;
    @Autowired
    private RemoteNodeService remoteNodeService;
    @Autowired
    private LvFileAccessManager accessManager;
    @Autowired
    private Environment environment;
    @Autowired
    private RemoteLogChangeListenerService remoteLogChangeListenerService;
    @Autowired
    private LvTimer timer;
    @Autowired(required=false)
    private List<LvFormatRecognizer> formatRecognizers = Collections.emptyList();

    public void afterPropertiesSet() {
        AtomicInteger counter = new AtomicInteger();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(8, 8, 20L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), run -> {
            Thread res = new Thread(run, "log-service-" + counter.incrementAndGet());
            res.setUncaughtExceptionHandler((t, e) -> LOG.error("Unhandled error", e));
            return res;
        });
        executor.allowCoreThreadTimeOut(true);
        this.executor = executor;
    }

    public RemoteNodeService getRemoteNodeService() {
        return this.remoteNodeService;
    }

    public FileWatcherService getFileWatcherService() {
        return this.fileWatcherService;
    }

    public LvTimer getTimer() {
        return this.timer;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public LvFileAccessManager getAccessManager() {
        return this.accessManager;
    }

    @Nullable
    public LogFormat getFormatByPath(@NonNull Path path) {
        try {
            path = path.toRealPath(LinkOption.NOFOLLOW_LINKS);
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException e) {
            LOG.warn("Failed to get canonical path from " + path, (Throwable)e);
        }
        if (!this.accessManager.isFileVisible(path)) {
            return null;
        }
        LogFormat format = null;
        for (LvFormatRecognizer formatRecognizer : this.formatRecognizers) {
            format = formatRecognizer.getFormat(path);
            if (format == null) continue;
            format = LvGsonUtils.copy(format);
            break;
        }
        if (format == null) {
            format = LvDefaultFormatDetector.detectFormat(path);
        }
        if (format != null) {
            format.loadGlobalConfig(this.environment);
        }
        return format;
    }

    @NonNull
    public CompletableFuture<Map<String, LogView>> openLogs(@NonNull Collection<LogPath> paths) {
        LinkedHashMap<String, Log> res = new LinkedHashMap<String, Log>();
        ArrayList<CompletableFuture<LogView>> remoteLogs = new ArrayList<CompletableFuture<LogView>>();
        for (LogPath logPath : paths) {
            if (logPath.getNode() == null) {
                Log log = this.openLog(logPath.getFile());
                res.put(log.getId(), log);
                continue;
            }
            remoteLogs.add(this.openRemoteLog(logPath));
        }
        if (remoteLogs.isEmpty()) {
            return CompletableFuture.completedFuture(res);
        }
        return CompletableFuture.allOf(remoteLogs.toArray(new CompletableFuture[0])).thenApply(v -> {
            for (CompletableFuture remoteLog : remoteLogs) {
                LogView logView = (LogView)Utils.safeGet(remoteLog);
                res.putIfAbsent(logView.getId(), (Log)logView);
            }
            return res;
        });
    }

    @NonNull
    public CompletableFuture<LogView> openRemoteLog(@NonNull LogPath path) {
        assert (path.getNode() != null);
        CompletableFuture<LogView> res = new CompletableFuture<LogView>();
        this.remoteNodeService.getNodeConnection(path.getNode()).whenComplete((BiConsumer)Wrappers.of(LOG, (conn, error) -> {
            if (error != null) {
                res.complete(new NotConnectedLogView(path, (Throwable)error));
            } else {
                conn.execute(new GetFormatAndIdTask(path.getFile())).whenComplete(Wrappers.of(LOG, (info, t) -> {
                    if (t != null) {
                        res.complete(new NotConnectedLogView(path, (Throwable)t));
                    } else {
                        LogFormat format;
                        try {
                            format = (LogFormat)LvGsonUtils.GSON.fromJson((String)info.getFirst(), LogFormat.class);
                        }
                        catch (Throwable e1) {
                            LOG.error("Incorrect log format", e1);
                            res.complete(new NotConnectedLogView(path, e1));
                            return;
                        }
                        res.complete(new RemoteLog(path, format, (String)info.getSecond(), (String)info.getThird(), this.remoteNodeService, this.remoteLogChangeListenerService));
                    }
                }));
            }
        }));
        return res;
    }

    @NonNull
    public Log openLog(@NonNull String pathStr) {
        Path path = this.normalizePath(Paths.get(pathStr, new String[0]));
        LogFormat format = this.getFormatByPath(path);
        return this.openLog0(path, format);
    }

    @NonNull
    public Log openLog(@NonNull String path, @Nullable LogFormat format) {
        return this.openLog(Paths.get(path, new String[0]), format);
    }

    @NonNull
    public Log openLog(@NonNull Path path, @Nullable LogFormat format) {
        return this.openLog0(this.normalizePath(path), format);
    }

    private Path normalizePath(Path path) {
        try {
            return path.toRealPath(LinkOption.NOFOLLOW_LINKS);
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException e) {
            LOG.warn("Failed to get canonical path from " + path, (Throwable)e);
        }
        return path;
    }

    @NonNull
    private Log openLog0(@NonNull Path path, @Nullable LogFormat format) {
        LogFormat finalFormat = format == null ? DEFAULT_FORMAT : LvGsonUtils.copy(format);
        return this.logs.computeIfAbsent(Pair.of(path, Utils.getFormatHash(finalFormat)), p -> {
            Log res = new Log((Path)p.getFirst(), finalFormat, this.executor);
            this.applicationContext.getAutowireCapableBeanFactory().autowireBeanProperties((Object)res, 0, false);
            return res;
        });
    }

    public void destroy() {
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeInterruptedException(e);
        }
    }

    public void reset() {
        this.logs.clear();
    }
}

