/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.data2.net;

import java.io.Serializable;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class Node
implements Serializable {
    private final String sshUser;
    private final String host;
    private final Integer port;

    public Node(@NonNull String host) {
        this(host, null);
    }

    public Node(@NonNull String host, @Nullable Integer port) {
        this(null, host, port);
    }

    public Node(@Nullable String sshUser, @NonNull String host, @Nullable Integer port) {
        this.sshUser = sshUser;
        this.host = host;
        this.port = port;
    }

    public String getSshUser() {
        return this.sshUser;
    }

    @NonNull
    public String getHost() {
        return this.host;
    }

    @Nullable
    public Integer getPort() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        if (!this.host.equals(node.host)) {
            return false;
        }
        return this.port != null ? this.port.equals(node.port) : node.port == null;
    }

    public int hashCode() {
        int result = this.host.hashCode();
        result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
        return result;
    }

    public String toString() {
        if (this.port == null) {
            return this.host;
        }
        return this.host + ':' + this.port;
    }
}

