/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.data2.net.server;

import com.logviewer.data2.Log;
import com.logviewer.data2.LogFormat;
import com.logviewer.data2.net.server.api.RemoteTask;
import com.logviewer.data2.net.server.api.RemoteTaskContext;
import com.logviewer.formats.SimpleLogFormat;
import com.logviewer.utils.Pair;
import java.nio.charset.Charset;
import org.springframework.lang.NonNull;

public class LoadContentTask
implements RemoteTask<Pair<String, Integer>> {
    private final String file;
    private final long offset;
    private final int length;
    private final Charset encoding;

    public LoadContentTask(String file, long offset, int length, Charset encoding) {
        this.file = file;
        this.offset = offset;
        this.length = length;
        this.encoding = encoding;
        if (length > 32768) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void start(@NonNull RemoteTaskContext<Pair<String, Integer>> ctx) {
        Log log = ctx.getLogService().openLog(this.file, (LogFormat)new SimpleLogFormat(this.encoding));
        log.loadContent(this.offset, this.length).whenComplete((res, error) -> {
            if (error != null) {
                ctx.sendErrorAndCloseChannel((Throwable)error);
            } else {
                ctx.sendAndCloseChannel((Pair<String, Integer>)res);
            }
        });
    }

    @Override
    public void cancel() {
    }
}

