/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.filters;

import com.logviewer.data2.LogFilterContext;
import com.logviewer.data2.LogRecord;
import com.logviewer.filters.RecordPredicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.lang.Nullable;

public class CompositeRecordPredicate
implements RecordPredicate {
    private final List<RecordPredicate> predicates = new ArrayList<RecordPredicate>();
    private boolean isAnd;

    public CompositeRecordPredicate() {
    }

    public CompositeRecordPredicate(boolean isAnd, Collection<RecordPredicate> predicates) {
        this.isAnd = isAnd;
        this.predicates.addAll(predicates);
    }

    public CompositeRecordPredicate(boolean isAnd, RecordPredicate ... predicates) {
        this.isAnd = isAnd;
        Collections.addAll(this.predicates, predicates);
    }

    public void addPredicate(RecordPredicate recordPredicate) {
        this.predicates.add(recordPredicate);
    }

    public boolean isAnd() {
        return this.isAnd;
    }

    public List<RecordPredicate> getPredicates() {
        return Collections.unmodifiableList(this.predicates);
    }

    @Override
    public boolean test(LogRecord record, LogFilterContext ctx) {
        if (this.isAnd) {
            for (RecordPredicate predicate : this.predicates) {
                if (predicate.test(record, ctx)) continue;
                return false;
            }
            return true;
        }
        for (RecordPredicate predicate : this.predicates) {
            if (!predicate.test(record, ctx)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static RecordPredicate and(RecordPredicate ... filters) {
        if (filters == null || filters.length == 0) {
            return null;
        }
        return CompositeRecordPredicate.and(Arrays.asList(filters));
    }

    public static RecordPredicate and(@Nullable Collection<RecordPredicate> filters) {
        if (filters == null || filters.isEmpty()) {
            return null;
        }
        if (filters.size() == 1) {
            return filters.iterator().next();
        }
        return new CompositeRecordPredicate(true, filters);
    }
}

