/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.filters;

import com.logviewer.data2.LogFilterContext;
import com.logviewer.data2.LogRecord;
import com.logviewer.filters.RecordPredicate;
import java.util.Objects;
import org.springframework.lang.NonNull;

public class FieldArgPredicate
implements RecordPredicate {
    private String fieldName;
    private String value;
    private Operator operator = Operator.EQUALS;

    public FieldArgPredicate(@NonNull String fieldName, String value) {
        this(fieldName, value, Operator.EQUALS);
    }

    public FieldArgPredicate(@NonNull String fieldName, String value, @NonNull Operator operator) {
        this.fieldName = fieldName;
        this.value = value;
        this.operator = operator;
    }

    @NonNull
    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(@NonNull String fieldName) {
        this.fieldName = fieldName;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @NonNull
    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(@NonNull Operator operator) {
        this.operator = operator;
    }

    @Override
    public boolean test(LogRecord record, LogFilterContext ctx) {
        String fieldValue = "_".equals(this.fieldName) ? record.getMessage() : record.getFieldText(this.fieldName);
        return this.operator.test(fieldValue, this.value);
    }

    public static enum Operator {
        EQUALS{

            @Override
            public boolean test(String fieldValue, String arg) {
                return Objects.equals(fieldValue, arg);
            }
        }
        ,
        NOT_EQUALS{

            @Override
            public boolean test(String fieldValue, String arg) {
                return !Objects.equals(fieldValue, arg);
            }
        }
        ,
        IEQUALS{

            @Override
            public boolean test(String fieldValue, String arg) {
                return fieldValue == null ? arg == null : fieldValue.equalsIgnoreCase(arg);
            }
        }
        ,
        NOT_IEQUALS{

            @Override
            public boolean test(String fieldValue, String arg) {
                return !(fieldValue != null ? fieldValue.equalsIgnoreCase(arg) : arg == null);
            }
        }
        ,
        CONTAINS{

            @Override
            public boolean test(String fieldValue, String arg) {
                return fieldValue != null && arg != null && fieldValue.contains(arg);
            }
        }
        ,
        START_WITH{

            @Override
            public boolean test(String fieldValue, String arg) {
                return fieldValue != null && arg != null && fieldValue.startsWith(arg);
            }
        }
        ,
        END_WITH{

            @Override
            public boolean test(String fieldValue, String arg) {
                return fieldValue != null && arg != null && fieldValue.endsWith(arg);
            }
        };


        public abstract boolean test(String var1, String var2);
    }
}

