/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.filters;

import com.logviewer.data2.LogFilterContext;
import com.logviewer.data2.LogFormat;
import com.logviewer.data2.LogRecord;
import com.logviewer.filters.RecordPredicate;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.springframework.lang.Nullable;

public class JsPredicate
implements RecordPredicate {
    private static final String KEY = "js-context";
    private final String script;
    private transient Function compiledScript;
    private transient RuntimeException compilationError;
    private volatile transient boolean initialized;

    public JsPredicate(String script) {
        this.script = script;
    }

    public Function getCompiledScript(JsContext jsContext) {
        if (!this.initialized) {
            try {
                this.compiledScript = jsContext.cx.compileFunction((Scriptable)jsContext.scriptableObject, this.script, "JsFilter", 1, null);
            }
            catch (RuntimeException exception2) {
                IllegalArgumentException exception2;
                if (exception2 instanceof IllegalArgumentException && exception2.getMessage().startsWith("compileFunction only accepts source with single JS function")) {
                    exception2 = new IllegalArgumentException("Script must be a function. Example: \"function isVisibleEvent(text, fields) { ... }\"");
                }
                this.compilationError = exception2;
            }
            this.initialized = true;
        }
        if (this.compilationError != null) {
            throw this.compilationError;
        }
        return this.compiledScript;
    }

    @Override
    public boolean test(LogRecord record, LogFilterContext ctx) {
        JsContext jsContext = ctx.getProperty(KEY, name -> {
            Context cx = Context.enter();
            return new JsContext(cx);
        });
        jsContext.jsRecordObject.init(record, ctx);
        Object res = this.getCompiledScript(jsContext).call(jsContext.cx, (Scriptable)jsContext.scriptableObject, (Scriptable)jsContext.scriptableObject, new Object[]{record.getMessage(), jsContext.jsRecordObject});
        return this.jsResultToBool(res);
    }

    private boolean jsResultToBool(@Nullable Object res) {
        if (res == null || res == Undefined.instance) {
            return false;
        }
        if (res instanceof Boolean) {
            return (Boolean)res;
        }
        if (res instanceof CharSequence) {
            return ((CharSequence)res).length() > 0;
        }
        if (res instanceof Number) {
            return ((Number)res).doubleValue() != 0.0;
        }
        return true;
    }

    private static class JsContext
    implements AutoCloseable {
        private final Context cx;
        private final ScriptableObject scriptableObject;
        private final JsRecordObject jsRecordObject;

        public JsContext(Context cx) {
            this.cx = cx;
            this.scriptableObject = cx.initSafeStandardObjects();
            this.jsRecordObject = new JsRecordObject((Scriptable)this.scriptableObject);
        }

        @Override
        public void close() {
            Context.exit();
        }
    }

    private static class JsRecordObject
    implements Scriptable {
        protected Scriptable prototype;
        protected Scriptable parent;
        private LogRecord record;
        private LogFilterContext ctx;

        private JsRecordObject(Scriptable parent) {
            this.parent = parent;
        }

        public void init(LogRecord record, LogFilterContext ctx) {
            this.record = record;
            this.ctx = ctx;
        }

        public String getClassName() {
            return "LogRecord";
        }

        public boolean has(int index, Scriptable start) {
            return index >= 0 && index < this.ctx.getFields().length;
        }

        public boolean has(String name, Scriptable start) {
            for (LogFormat.FieldDescriptor field : this.ctx.getFields()) {
                if (!field.name().equals(name)) continue;
                return true;
            }
            return false;
        }

        public Object get(String name, Scriptable start) {
            String res = this.record.getFieldText(name);
            return res == null ? NOT_FOUND : res;
        }

        public Object get(int index, Scriptable start) {
            if (index < 0 || index >= this.ctx.getFields().length) {
                return NOT_FOUND;
            }
            LogFormat.FieldDescriptor field = this.ctx.getFields()[index];
            return this.record.getFieldText(field.name());
        }

        public void put(int index, Scriptable start, Object value) {
            throw new RuntimeException("The object is immutable");
        }

        public void put(String name, Scriptable start, Object value) {
            throw new RuntimeException("The object is immutable");
        }

        public void delete(String name) {
        }

        public void delete(int index) {
        }

        public boolean hasInstance(Scriptable instance) {
            return false;
        }

        public Object getDefaultValue(Class<?> hint) {
            throw new RuntimeException();
        }

        public void setParentScope(Scriptable parent) {
            this.parent = parent;
        }

        public Scriptable getParentScope() {
            return this.parent;
        }

        public Object[] getIds() {
            LogFormat.FieldDescriptor[] fields = this.ctx.getFields();
            Object[] res = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                res[i] = fields[i].name();
            }
            return res;
        }

        public Scriptable getPrototype() {
            return this.prototype;
        }

        public void setPrototype(Scriptable prototype) {
            this.prototype = prototype;
        }
    }
}

