/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.formats;

import com.logviewer.data2.LogFormat;
import com.logviewer.data2.LogReader;
import com.logviewer.formats.CompoundFieldSet;
import com.logviewer.formats.DefaultFieldSet;
import com.logviewer.formats.FieldSet;
import com.logviewer.formats.utils.LvLayoutNode;
import com.logviewer.formats.utils.LvLayoutStretchNode;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;
import org.springframework.core.env.Environment;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public abstract class AbstractPatternLogFormat
implements LogFormat {
    private static final String[] LEVELS = new String[]{"OFF", "FATAL", "SEVERE", "EMERGENCY", "ALERT", "CRITICAL", "ERROR", "WARN", "WARNING", "INFO", "CONFIG", "NOTICE", "INFORMATIONAL", "DEBUG", "FINE", "FINER", "FINEST", "TRACE", "ALL"};
    protected static final String SOURCE_FILE_PATTERN = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.[a-z]{1,5}";
    protected static final String METHOD_PATTERN = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private Charset charset;
    private Locale locale;
    private final String pattern;
    private final String[] patterns;
    private List<String> customLevels = new ArrayList<String>();
    private volatile transient FieldSet fieldSet;

    public AbstractPatternLogFormat(@NonNull String pattern) {
        this.pattern = pattern;
        this.patterns = null;
    }

    public AbstractPatternLogFormat(@NonNull String[] patterns) {
        this.pattern = null;
        this.patterns = patterns;
        if (patterns.length == 0) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public boolean hasFullDate() {
        return this.getDelegate().hasFullDate();
    }

    public AbstractPatternLogFormat setCharset(Charset charset) {
        this.charset = charset;
        this.clearTemporaryState();
        return this;
    }

    public AbstractPatternLogFormat setLocale(Locale locale) {
        this.locale = locale;
        this.clearTemporaryState();
        return this;
    }

    protected void clearTemporaryState() {
        this.fieldSet = null;
    }

    @Nullable
    public String getPattern() {
        return this.pattern;
    }

    @Nullable
    public String[] getPatterns() {
        return this.patterns;
    }

    protected abstract String getFormatName();

    @Override
    public final String getHumanReadableString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFormatName()).append(": ");
        if (!StringUtils.isEmpty((Object)this.pattern)) {
            sb.append(this.pattern);
        } else {
            sb.append('(');
            sb.append(String.join((CharSequence)" | ", this.patterns));
            sb.append(')');
        }
        return sb.toString();
    }

    public List<String> getCustomLevels() {
        if (this.customLevels == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.customLevels);
    }

    protected String[] allLogLevels() {
        return (String[])Stream.concat(Stream.of(LEVELS), this.getCustomLevels().stream()).distinct().toArray(String[]::new);
    }

    public AbstractPatternLogFormat addCustomLevels(@Nullable List<String> customLevels) {
        if (customLevels != null) {
            if (this.customLevels == null) {
                this.customLevels = new ArrayList<String>();
            }
            this.customLevels.addAll(customLevels);
        }
        return this;
    }

    @Override
    public void loadGlobalConfig(Environment env) {
        String[] customLevels = (String[])env.getProperty("log-viewer.log-levels", String[].class);
        if (customLevels != null) {
            this.addCustomLevels(Arrays.asList(customLevels));
        }
    }

    @Override
    public LogReader createReader() {
        return this.getDelegate().createReader();
    }

    @Override
    public LogFormat.FieldDescriptor[] getFields() {
        return this.getDelegate().getFields();
    }

    protected FieldSet getDelegate() {
        FieldSet res = this.fieldSet;
        if (res == null) {
            if (!StringUtils.isEmpty((Object)this.pattern)) {
                LvLayoutNode[] nodes = this.parseLayout(this.pattern);
                res = new DefaultFieldSet(this.locale, this.charset, nodes);
            } else {
                assert (this.patterns != null);
                LvLayoutNode[][] nodes = new LvLayoutNode[this.patterns.length][];
                for (int i = 0; i < this.patterns.length; ++i) {
                    nodes[i] = this.parseLayout(this.patterns[i]);
                }
                res = new CompoundFieldSet(this.locale, this.charset, nodes);
            }
            this.fieldSet = res;
        }
        return res;
    }

    protected abstract LvLayoutNode[] parseLayout(@NonNull String var1) throws IllegalArgumentException;

    @Override
    public void validate() throws IllegalArgumentException {
        if (StringUtils.isEmpty((Object)this.pattern) && (this.patterns == null || this.patterns.length == 0)) {
            throw new IllegalArgumentException("'pattern' and 'patterns' fields are empty, one of them must be filled");
        }
        if (!StringUtils.isEmpty((Object)this.pattern) && this.patterns != null && this.patterns.length > 0) {
            throw new IllegalArgumentException("'pattern' and 'patterns' fields are not empty, one of them must be empty");
        }
        this.getDelegate();
    }

    protected static void mergeMessageFields(List<LvLayoutNode> nodes) {
        int i = 0;
        while (i + 1 < nodes.size()) {
            LvLayoutNode n1 = nodes.get(i);
            LvLayoutNode n2 = nodes.get(i + 1);
            if (n1 instanceof LvLayoutStretchNode && n2 instanceof LvLayoutStretchNode) {
                LvLayoutStretchNode ns1 = (LvLayoutStretchNode)n1;
                LvLayoutStretchNode ns2 = (LvLayoutStretchNode)n2;
                if (ns1.getFieldName().equals(ns2.getFieldName()) && Objects.equals(ns1.getFieldType(), ns2.getFieldType())) {
                    LvLayoutStretchNode merged = new LvLayoutStretchNode(ns1.getFieldName(), ns2.getFieldType(), ns1.removeSpacesBefore(), ns1.getMinSize() + ns2.getMinSize());
                    nodes.set(i, merged);
                    nodes.remove(i + 1);
                    continue;
                }
            }
            ++i;
        }
    }
}

