/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.formats;

import com.logviewer.data2.CompaundLogReader;
import com.logviewer.data2.DefaultFieldDesciptor;
import com.logviewer.data2.LogFormat;
import com.logviewer.data2.LogReader;
import com.logviewer.data2.LogRecord;
import com.logviewer.formats.DefaultFieldSet;
import com.logviewer.formats.FieldSet;
import com.logviewer.formats.utils.LvLayoutNode;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class CompoundFieldSet
implements FieldSet {
    private final DefaultFieldSet[] fieldSets;
    private final LogFormat.FieldDescriptor[] fields;
    private final Map<String, Integer> fieldNameIndexes;
    private final int[][] fields2mergedFieldsIndexes;
    private final int dateFieldIndex;

    public CompoundFieldSet(@Nullable Locale locale, @Nullable Charset charset, LvLayoutNode[][] layout) {
        this.fieldSets = new DefaultFieldSet[layout.length];
        for (int i = 0; i < layout.length; ++i) {
            this.fieldSets[i] = new DefaultFieldSet(locale, charset, layout[i]);
        }
        ArrayList<LogFormat.FieldDescriptor> mergedFields = new ArrayList<LogFormat.FieldDescriptor>();
        HashMap<LogFormat.FieldDescriptor, LogFormat.FieldDescriptor> field2mergedField = new HashMap<LogFormat.FieldDescriptor, LogFormat.FieldDescriptor>();
        ArrayList<DefaultFieldDesciptor> usedFields = new ArrayList<DefaultFieldDesciptor>();
        for (DefaultFieldSet fieldSet : this.fieldSets) {
            LogFormat.FieldDescriptor[] fields;
            usedFields.clear();
            for (LogFormat.FieldDescriptor field : fields = fieldSet.getFields()) {
                LogFormat.FieldDescriptor mergedField = null;
                for (LogFormat.FieldDescriptor f2 : mergedFields) {
                    if (usedFields.contains(f2) || !f2.name().equals(field.name()) || !Objects.equals(f2.type(), field.type())) continue;
                    mergedField = f2;
                    break;
                }
                if (mergedField == null) {
                    mergedField = new DefaultFieldDesciptor(CompoundFieldSet.selectUniqueName(mergedFields, field.name()), field.type());
                    mergedFields.add(mergedField);
                }
                usedFields.add((DefaultFieldDesciptor)mergedField);
                field2mergedField.put(field, mergedField);
            }
        }
        HashMap<LogFormat.FieldDescriptor, int[]> mergedFieldWeight = new HashMap<LogFormat.FieldDescriptor, int[]>();
        for (DefaultFieldSet fieldSet : this.fieldSets) {
            LogFormat.FieldDescriptor[] fields = fieldSet.getFields();
            for (int i = 0; i < fields.length; ++i) {
                LogFormat.FieldDescriptor mergedField = (LogFormat.FieldDescriptor)field2mergedField.get(fields[i]);
                assert (mergedField != null);
                int[] positionSumAndCount = mergedFieldWeight.computeIfAbsent(mergedField, k -> new int[2]);
                positionSumAndCount[0] = positionSumAndCount[0] + i;
                positionSumAndCount[1] = positionSumAndCount[1] + 1;
            }
        }
        mergedFields.sort(Comparator.comparingDouble(f -> {
            int[] positionSumAndCount = (int[])mergedFieldWeight.get(f);
            return (double)positionSumAndCount[0] / (double)positionSumAndCount[1];
        }));
        this.fields = mergedFields.toArray(LogFormat.FieldDescriptor.EMPTY_ARRAY);
        this.fieldNameIndexes = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < this.fields.length; ++i) {
            LogFormat.FieldDescriptor field = this.fields[i];
            this.fieldNameIndexes.put(field.name(), i);
        }
        this.fields2mergedFieldsIndexes = new int[this.fieldSets.length][];
        for (int fSetIdx = 0; fSetIdx < this.fieldSets.length; ++fSetIdx) {
            DefaultFieldSet fieldSet = this.fieldSets[fSetIdx];
            LogFormat.FieldDescriptor[] fields = fieldSet.getFields();
            this.fields2mergedFieldsIndexes[fSetIdx] = new int[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                LogFormat.FieldDescriptor mergedField = (LogFormat.FieldDescriptor)field2mergedField.get(fields[i]);
                assert (mergedField != null);
                this.fields2mergedFieldsIndexes[fSetIdx][i] = this.fieldNameIndexes.get(mergedField.name());
            }
        }
        LogFormat.FieldDescriptor mergedDateField = CompoundFieldSet.findCommonDateField(this.fieldSets, field2mergedField);
        this.dateFieldIndex = mergedDateField == null ? -1 : this.fieldNameIndexes.get(mergedDateField.name());
    }

    private static LogFormat.FieldDescriptor findCommonDateField(DefaultFieldSet[] fieldSets, Map<LogFormat.FieldDescriptor, LogFormat.FieldDescriptor> field2mergedField) {
        LogFormat.FieldDescriptor res = null;
        for (DefaultFieldSet fieldSet : fieldSets) {
            LogFormat.FieldDescriptor dateField = fieldSet.getDateField();
            if (dateField == null) {
                return null;
            }
            LogFormat.FieldDescriptor mergedField = field2mergedField.get(dateField);
            if (res != null && res != mergedField) {
                return null;
            }
            res = mergedField;
        }
        return res;
    }

    @Override
    public LogFormat.FieldDescriptor[] getFields() {
        return this.fields;
    }

    @Override
    public boolean hasFullDate() {
        return this.dateFieldIndex >= 0;
    }

    @Override
    @NonNull
    public LogReader createReader() {
        LogReader[] readers = new LogReader[this.fieldSets.length];
        for (int i = 0; i < this.fieldSets.length; ++i) {
            readers[i] = this.fieldSets[i].createReader();
        }
        return new CompaundLogReader(readers, (rec, readerIndex) -> {
            int[] mergedFieldPosition = new int[this.fields.length * 2];
            Arrays.fill(mergedFieldPosition, -1);
            int[] mergedFieldIndexes = this.fields2mergedFieldsIndexes[readerIndex];
            int[] originalPositions = rec.getFieldPositions();
            assert (mergedFieldIndexes.length * 2 == originalPositions.length);
            for (int i = 0; i < mergedFieldIndexes.length; ++i) {
                int mergedFieldIdx = mergedFieldIndexes[i];
                mergedFieldPosition[mergedFieldIdx * 2] = originalPositions[i * 2];
                mergedFieldPosition[mergedFieldIdx * 2 + 1] = originalPositions[i * 2 + 1];
            }
            return new LogRecord(rec.getMessage(), rec.getTime(), rec.getStart(), rec.getEnd(), rec.getLoadedTextLengthBytes(), mergedFieldPosition, this.fieldNameIndexes);
        });
    }

    private static boolean isUniqueName(@NonNull List<LogFormat.FieldDescriptor> fields, @NonNull String baseName) {
        for (LogFormat.FieldDescriptor field : fields) {
            if (!field.name().equals(baseName)) continue;
            return false;
        }
        return true;
    }

    private static String selectUniqueName(List<LogFormat.FieldDescriptor> fields, String baseName) {
        if (CompoundFieldSet.isUniqueName(fields, baseName)) {
            return baseName;
        }
        int i = 1;
        String name;
        while (!CompoundFieldSet.isUniqueName(fields, name = baseName + '_' + i)) {
            ++i;
        }
        return name;
    }
}

